/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.hibiscus.naturespirit.world.feature.TurnipRootFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class TurnipRootFeature
extends Feature<TurnipRootFeatureConfig> {
    public TurnipRootFeature(Codec<TurnipRootFeatureConfig> codec) {
        super(codec);
    }

    private static boolean hasSpaceForTree(WorldGenLevel world, TurnipRootFeatureConfig config, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int i = 1; i <= config.requiredVerticalSpaceForTree; ++i) {
            mutable.m_122173_(Direction.UP);
            BlockState blockState = world.m_8055_((BlockPos)mutable);
            if (TurnipRootFeature.isAirOrWater(blockState, i, config.allowedVerticalWaterForTree)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAirOrWater(BlockState state, int height, int allowedVerticalWaterForTree) {
        if (state.m_60795_()) {
            return true;
        }
        int i = height + 1;
        return i <= allowedVerticalWaterForTree && state.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    private static boolean generateTreeAndRoots(WorldGenLevel world, ChunkGenerator generator, TurnipRootFeatureConfig config, RandomSource random, BlockPos.MutableBlockPos mutablePos, BlockPos pos) {
        for (int i = 0; i < config.maxRootColumnHeight; ++i) {
            mutablePos.m_122173_(Direction.UP);
            if (!config.predicate.test((Object)world, (Object)mutablePos) || !TurnipRootFeature.hasSpaceForTree(world, config, (BlockPos)mutablePos)) continue;
            BlockPos blockPos = mutablePos.m_7495_();
            if (world.m_6425_(blockPos).m_205070_(FluidTags.f_13132_) || !world.m_8055_(blockPos).m_280296_()) {
                return false;
            }
            if (!((PlacedFeature)config.feature.m_203334_()).m_226357_(world, generator, random, (BlockPos)mutablePos)) continue;
            TurnipRootFeature.generateRootsColumn(pos, pos.m_123342_() + i, world, config, random);
            return true;
        }
        return false;
    }

    private static void generateRootsColumn(BlockPos pos, int maxY, WorldGenLevel world, TurnipRootFeatureConfig config, RandomSource random) {
        int i = pos.m_123341_();
        int j = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int k = pos.m_123342_(); k < maxY; ++k) {
            TurnipRootFeature.generateRoots(world, config, random, i, j, mutable.m_122178_(i, k, j));
        }
    }

    private static void generateRoots(WorldGenLevel world, TurnipRootFeatureConfig config, RandomSource random, int x, int z, BlockPos.MutableBlockPos mutablePos) {
        int i = config.rootRadius;
        Predicate<BlockState> predicate = state -> state.m_204336_(config.rootReplaceable);
        for (int j = 0; j < config.rootPlacementAttempts; ++j) {
            mutablePos.m_122154_((Vec3i)mutablePos, random.m_188503_(i) - random.m_188503_(i), 0, random.m_188503_(i) - random.m_188503_(i));
            if (predicate.test(world.m_8055_((BlockPos)mutablePos))) {
                world.m_7731_((BlockPos)mutablePos, config.rootStateProvider.m_213972_(random, (BlockPos)mutablePos), 2);
            }
            mutablePos.m_142451_(x);
            mutablePos.m_142443_(z);
        }
    }

    private static void generateHangingRoots(WorldGenLevel world, TurnipRootFeatureConfig config, RandomSource random, BlockPos pos, BlockPos.MutableBlockPos mutablePos) {
        int i = config.hangingRootRadius;
        int j = config.hangingRootVerticalSpan;
        for (int k = 0; k < config.hangingRootPlacementAttempts; ++k) {
            BlockState blockState;
            mutablePos.m_122154_((Vec3i)pos, random.m_188503_(i) - random.m_188503_(i), random.m_188503_(j) - random.m_188503_(j), random.m_188503_(i) - random.m_188503_(i));
            if (!world.m_46859_((BlockPos)mutablePos) || !(blockState = config.hangingRootStateProvider.m_213972_(random, (BlockPos)mutablePos)).m_60710_((LevelReader)world, (BlockPos)mutablePos) || !world.m_8055_(mutablePos.m_7494_()).m_60783_((BlockGetter)world, (BlockPos)mutablePos, Direction.DOWN)) continue;
            world.m_7731_((BlockPos)mutablePos, blockState, 2);
        }
    }

    private static void generateTurnips(WorldGenLevel world, TurnipRootFeatureConfig config, RandomSource random, BlockPos pos, BlockPos.MutableBlockPos mutablePos) {
        int i = config.hangingRootRadius;
        int j = config.hangingRootVerticalSpan;
        for (int k = 0; k < config.turnipPlacementAttempts; ++k) {
            BlockState blockState;
            mutablePos.m_122154_((Vec3i)pos, random.m_188503_(i) - random.m_188503_(i), random.m_188503_(j) - random.m_188503_(j), random.m_188503_(i) - random.m_188503_(i));
            if (world.m_8055_(mutablePos.m_5484_(Direction.UP, 1)) != config.rootStateProvider.m_213972_(random, (BlockPos)mutablePos) || !(blockState = config.turnipStateProvider.m_213972_(random, (BlockPos)mutablePos)).m_60710_((LevelReader)world, (BlockPos)mutablePos) || !world.m_8055_(mutablePos.m_7494_()).m_60783_((BlockGetter)world, (BlockPos)mutablePos, Direction.DOWN)) continue;
            world.m_7731_((BlockPos)mutablePos, blockState, 2);
        }
    }

    public boolean m_142674_(FeaturePlaceContext<TurnipRootFeatureConfig> context) {
        WorldGenLevel structureWorldAccess = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos blockPos = context.m_159777_();
        TurnipRootFeatureConfig turnipRootFeatureConfig = (TurnipRootFeatureConfig)context.m_159778_();
        BlockPos.MutableBlockPos mutable = blockPos.m_122032_();
        if (TurnipRootFeature.generateTreeAndRoots(structureWorldAccess, context.m_159775_(), turnipRootFeatureConfig, random, mutable, blockPos)) {
            TurnipRootFeature.generateHangingRoots(structureWorldAccess, turnipRootFeatureConfig, random, blockPos, mutable);
            TurnipRootFeature.generateTurnips(structureWorldAccess, turnipRootFeatureConfig, random, blockPos, mutable);
        }
        return true;
    }
}

