/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class PumpkinPatchFeature
extends Feature<OreConfiguration> {
    public PumpkinPatchFeature(Codec<OreConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<OreConfiguration> context) {
        RandomSource random = context.m_225041_();
        BlockPos blockPos = context.m_159777_();
        WorldGenLevel structureWorldAccess = context.m_159774_();
        OreConfiguration oreFeatureConfig = (OreConfiguration)context.m_159778_();
        float f = random.m_188501_() * (float)Math.PI;
        float g = (float)oreFeatureConfig.f_67839_ / 8.0f;
        int i = Mth.m_14167_((float)(((float)oreFeatureConfig.f_67839_ / 16.0f * 2.0f + 1.0f) / 2.0f));
        double d = (double)blockPos.m_123341_() + Math.sin(f) * (double)g;
        double e = (double)blockPos.m_123341_() - Math.sin(f) * (double)g;
        double h = (double)blockPos.m_123343_() + Math.cos(f) * (double)g;
        double j = (double)blockPos.m_123343_() - Math.cos(f) * (double)g;
        double l = blockPos.m_123342_();
        int n = blockPos.m_123341_() - Mth.m_14167_((float)g) - i;
        int o = blockPos.m_123342_() - 2 - i;
        int p = blockPos.m_123343_() - Mth.m_14167_((float)g) - i;
        int q = 2 * (Mth.m_14167_((float)g) + i);
        int r = 2;
        for (int s = n; s <= n + q; ++s) {
            for (int t = p; t <= p + q; ++t) {
                if (o > structureWorldAccess.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, s, t)) continue;
                return this.generateVeinPart(structureWorldAccess, random, oreFeatureConfig, d, e, h, j, l, l + 1.0, n, o, p, q, r);
            }
        }
        return false;
    }

    protected boolean generateVeinPart(WorldGenLevel world, RandomSource random, OreConfiguration config, double startX, double endX, double startZ, double endZ, double startY, double endY, int x, int y, int z, int horizontalSize, int verticalSize) {
        double h;
        double g;
        double e;
        double d;
        int k;
        int i = 0;
        BitSet bitSet = new BitSet(horizontalSize * verticalSize * horizontalSize);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int j = config.f_67839_;
        double[] ds = new double[j * 4];
        for (k = 0; k < j; ++k) {
            float f = (float)k / (float)j;
            d = Mth.m_14139_((double)f, (double)startX, (double)endX);
            e = Mth.m_14139_((double)f, (double)startY, (double)endY);
            g = Mth.m_14139_((double)f, (double)startZ, (double)endZ);
            h = random.m_188500_() * (double)j / 16.0;
            double l = ((double)(Mth.m_14031_((float)((float)Math.PI * f)) + 1.0f) * h + 1.0) / 2.0;
            ds[k * 4] = d;
            ds[k * 4 + 1] = e;
            ds[k * 4 + 2] = g;
            ds[k * 4 + 3] = l;
        }
        for (k = 0; k < j - 1; ++k) {
            if (ds[k * 4 + 3] <= 0.0) continue;
            for (int m = k + 1; m < j; ++m) {
                if (ds[m * 4 + 3] <= 0.0 || !((h = ds[k * 4 + 3] - ds[m * 4 + 3]) * h > (d = ds[k * 4] - ds[m * 4]) * d + (e = ds[k * 4 + 1] - ds[m * 4 + 1]) * e + (g = ds[k * 4 + 2] - ds[m * 4 + 2]) * g)) continue;
                if (h > 0.0) {
                    ds[m * 4 + 3] = -1.0;
                    continue;
                }
                ds[k * 4 + 3] = -1.0;
            }
        }
        try (BulkSectionAccess chunkSectionCache = new BulkSectionAccess((LevelAccessor)world);){
            for (int m = 0; m < j; ++m) {
                d = ds[m * 4 + 3];
                if (d < 0.0) continue;
                e = ds[m * 4];
                g = ds[m * 4 + 1];
                h = ds[m * 4 + 2];
                int n = Math.max(Mth.m_14107_((double)(e - d)), x);
                int o = Math.max(Mth.m_14107_((double)(g - d)), y);
                int p = Math.max(Mth.m_14107_((double)(h - d)), z);
                int q = Math.max(Mth.m_14107_((double)(e + d)), n);
                int r = Math.max(Mth.m_14107_((double)(g + d)), o);
                int s = Math.max(Mth.m_14107_((double)(h + d)), p);
                for (int t = n; t <= q; ++t) {
                    double u = ((double)t + 0.5 - e) / d;
                    if (!(u * u < 1.0)) continue;
                    for (int v = o; v <= r; ++v) {
                        double w = ((double)v + 0.5 - g) / d;
                        if (!(u * u + w * w < 1.0)) continue;
                        block11: for (int aa = p; aa <= s; ++aa) {
                            LevelChunkSection chunkSection;
                            int ac;
                            double ab = ((double)aa + 0.5 - h) / d;
                            if (!(u * u + w * w + ab * ab < 1.0) || world.m_151562_(v) || bitSet.get(ac = t - x + (v - y) * horizontalSize + (aa - z) * horizontalSize * verticalSize)) continue;
                            bitSet.set(ac);
                            mutable.m_122178_(t, v, aa);
                            if (!world.m_180807_((BlockPos)mutable) || (chunkSection = chunkSectionCache.m_156104_((BlockPos)mutable)) == null) continue;
                            int ad = SectionPos.m_123207_((int)t);
                            int ae = SectionPos.m_123207_((int)v);
                            int af = SectionPos.m_123207_((int)aa);
                            BlockState blockState = chunkSection.m_62982_(ad, ae, af);
                            for (OreConfiguration.TargetBlockState target : config.f_161005_) {
                                Objects.requireNonNull(chunkSectionCache);
                                if (!PumpkinPatchFeature.shouldPlace(blockState, arg_0 -> ((BulkSectionAccess)chunkSectionCache).m_156110_(arg_0), random, config, target, mutable)) continue;
                                chunkSection.m_62991_(ad, ae, af, target.f_161033_, false);
                                ++i;
                                if (t == q) continue block11;
                            }
                        }
                    }
                }
            }
        }
        return i > 0;
    }

    public static boolean shouldPlace(BlockState state, Function<BlockPos, BlockState> posToState, RandomSource random, OreConfiguration config, OreConfiguration.TargetBlockState target, BlockPos.MutableBlockPos pos) {
        if (!target.f_161032_.m_213865_(state, random)) {
            return false;
        }
        if (PumpkinPatchFeature.shouldNotDiscard(random, config.f_161006_)) {
            return true;
        }
        return !PumpkinPatchFeature.m_159750_(posToState, (BlockPos)pos);
    }

    protected static boolean shouldNotDiscard(RandomSource random, float chance) {
        if (chance <= 0.0f) {
            return true;
        }
        if (chance >= 1.0f) {
            return false;
        }
        return random.m_188501_() >= chance;
    }
}

