/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.mojang.serialization.Codec;
import net.hibiscus.naturespirit.world.feature.HugeMushroomFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public abstract class HugeMushroomFeature
extends Feature<HugeMushroomFeatureConfig> {
    public HugeMushroomFeature(Codec<HugeMushroomFeatureConfig> codec) {
        super(codec);
    }

    protected void generateStem(LevelAccessor world, RandomSource random, BlockPos pos, HugeMushroomFeatureConfig config, int height, BlockPos.MutableBlockPos mutablePos) {
        for (int i = 0; i < height; ++i) {
            mutablePos.m_122190_((Vec3i)pos).m_122175_(Direction.UP, i);
            if (world.m_8055_((BlockPos)mutablePos).m_60804_((BlockGetter)world, (BlockPos)mutablePos)) continue;
            this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, config.stemProvider.m_213972_(random, pos));
        }
    }

    protected int getHeight(RandomSource random, HugeMushroomFeatureConfig hugeMushroomFeatureConfig) {
        return random.m_216332_(hugeMushroomFeatureConfig.firstRandomHeight, hugeMushroomFeatureConfig.secondRandomHeight) + hugeMushroomFeatureConfig.baseHeight;
    }

    protected boolean canGenerate(LevelAccessor world, BlockPos pos, int height, BlockPos.MutableBlockPos mutablePos, HugeMushroomFeatureConfig config) {
        int i = pos.m_123342_();
        if (i >= world.m_141937_() + 1 && i + height + 1 < world.m_151558_()) {
            BlockState blockState = world.m_8055_(pos.m_7495_());
            if (!HugeMushroomFeature.m_159759_((BlockState)blockState) && !blockState.m_204336_(BlockTags.f_13057_)) {
                return false;
            }
            for (int j = 0; j <= height; ++j) {
                int k = this.getCapSize(-1, -1, config.foliageRadius, j);
                for (int l = -k; l <= k; ++l) {
                    for (int m = -k; m <= k; ++m) {
                        BlockState blockState2 = world.m_8055_((BlockPos)mutablePos.m_122154_((Vec3i)pos, l, j, m));
                        if (blockState2.m_60795_() || blockState2.m_204336_(BlockTags.f_13035_)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_142674_(FeaturePlaceContext<HugeMushroomFeatureConfig> context) {
        BlockPos.MutableBlockPos mutable;
        HugeMushroomFeatureConfig hugeMushroomFeatureConfig;
        RandomSource random;
        int i;
        BlockPos blockPos;
        WorldGenLevel structureWorldAccess = context.m_159774_();
        if (!this.canGenerate((LevelAccessor)structureWorldAccess, blockPos = context.m_159777_(), i = this.getHeight(random = context.m_225041_(), hugeMushroomFeatureConfig = (HugeMushroomFeatureConfig)context.m_159778_()), mutable = new BlockPos.MutableBlockPos(), hugeMushroomFeatureConfig)) {
            return false;
        }
        this.generateCap((LevelAccessor)structureWorldAccess, random, blockPos, i, mutable, hugeMushroomFeatureConfig);
        this.generateStem((LevelAccessor)structureWorldAccess, random, blockPos, hugeMushroomFeatureConfig, i, mutable);
        return true;
    }

    protected abstract int getCapSize(int var1, int var2, int var3, int var4);

    protected abstract void generateCap(LevelAccessor var1, RandomSource var2, BlockPos var3, int var4, BlockPos.MutableBlockPos var5, HugeMushroomFeatureConfig var6);
}

