/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.world.carver.ReplaceableRavineCarverConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class ReplaceableRavineCarver
extends WorldCarver<ReplaceableRavineCarverConfig> {
    public ReplaceableRavineCarver(Codec<ReplaceableRavineCarverConfig> codec) {
        super(codec);
    }

    public boolean isStartChunk(ReplaceableRavineCarverConfig replaceableRavineCarverConfig, RandomSource random) {
        return random.m_188501_() <= replaceableRavineCarverConfig.f_67859_;
    }

    public boolean carve(CarvingContext carverContext, ReplaceableRavineCarverConfig replaceableRavineCarverConfig, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> function, RandomSource random, Aquifer aquiferSampler, ChunkPos chunkPos, CarvingMask carvingMask) {
        int i = (this.m_65073_() * 2 - 1) * 16;
        double d = chunkPos.m_151382_(random.m_188503_(16));
        int j = replaceableRavineCarverConfig.f_159088_.m_213859_(random, (WorldGenerationContext)carverContext);
        double e = chunkPos.m_151391_(random.m_188503_(16));
        float f = random.m_188501_() * ((float)Math.PI * 2);
        float g = replaceableRavineCarverConfig.verticalRotation.m_214084_(random);
        double h = replaceableRavineCarverConfig.f_159089_.m_214084_(random);
        float k = replaceableRavineCarverConfig.shape.thickness.m_214084_(random);
        int l = (int)((float)i * replaceableRavineCarverConfig.shape.distanceFactor.m_214084_(random));
        boolean m = false;
        this.carveEllipsoid(carverContext, replaceableRavineCarverConfig, chunk, function, random.m_188505_(), aquiferSampler, d, j, e, k, f, g, 0, l, h, carvingMask);
        return true;
    }

    private void carveEllipsoid(CarvingContext context, ReplaceableRavineCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, long seed, Aquifer aquiferSampler, double x, double y, double z, float width, float yaw, float pitch, int branchStartIndex, int branchCount, double yawPitchRatio, CarvingMask mask) {
        RandomSource random = RandomSource.m_216335_((long)seed);
        float[] fs = this.createHorizontalStretchFactors(context, config, random);
        float f = 0.0f;
        float g = 0.0f;
        for (int i = branchStartIndex; i < branchCount; ++i) {
            double d = 1.5 + (double)(Mth.m_14031_((float)((float)i * (float)Math.PI / (float)branchCount)) * width);
            double e = d * yawPitchRatio;
            d *= (double)config.shape.horizontalRadiusFactor.m_214084_(random);
            e = this.getVerticalScale(config, random, e, branchCount, i);
            float h = Mth.m_14089_((float)pitch);
            float j = Mth.m_14031_((float)pitch);
            x += (double)(Mth.m_14089_((float)yaw) * h);
            y += (double)j;
            z += (double)(Mth.m_14031_((float)yaw) * h);
            pitch *= 0.7f;
            pitch += g * 0.05f;
            yaw += f * 0.05f;
            g *= 0.8f;
            f *= 0.5f;
            g += (random.m_188501_() - random.m_188501_()) * random.m_188501_() * 2.0f;
            f += (random.m_188501_() - random.m_188501_()) * random.m_188501_() * 4.0f;
            if (random.m_188503_(4) == 0) continue;
            if (!ReplaceableRavineCarver.m_159367_((ChunkPos)chunk.m_7697_(), (double)x, (double)z, (int)i, (int)branchCount, (float)width)) {
                return;
            }
            this.m_190753_(context, config, chunk, posToBiome, aquiferSampler, x, y, z, d, e, mask, (contextx, scaledRelativeX, scaledRelativeY, scaledRelativeZ, yx) -> this.isPositionExcluded(contextx, fs, scaledRelativeX, scaledRelativeY, scaledRelativeZ, yx));
        }
    }

    protected boolean carveBlock(CarvingContext context, ReplaceableRavineCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, CarvingMask mask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos tmp, Aquifer aquiferSampler, MutableBoolean replacedGrassy) {
        BlockState blockState = chunk.m_8055_((BlockPos)pos);
        if (blockState.m_60713_(Blocks.f_50440_) || blockState.m_60713_(Blocks.f_50195_) || blockState.m_60713_((Block)NSBlocks.RED_MOSS_BLOCK.get())) {
            replacedGrassy.setTrue();
        }
        if (!this.m_224910_(config, blockState) && !ReplaceableRavineCarver.m_159423_(config)) {
            return false;
        }
        BlockState blockState2 = this.getState(context, config, (BlockPos)pos, aquiferSampler, chunk);
        if (blockState2 == null) {
            return false;
        }
        chunk.m_6978_((BlockPos)pos, blockState2, false);
        if (aquiferSampler.m_142203_() && !blockState2.m_60819_().m_76178_()) {
            chunk.m_8113_((BlockPos)pos);
        }
        if (replacedGrassy.isTrue()) {
            tmp.m_122159_((Vec3i)pos, Direction.DOWN);
            if (chunk.m_8055_((BlockPos)tmp).m_60713_(Blocks.f_50493_)) {
                context.m_190646_(posToBiome, chunk, (BlockPos)tmp, !blockState2.m_60819_().m_76178_()).ifPresent(state -> {
                    chunk.m_6978_((BlockPos)tmp, state, false);
                    if (!state.m_60819_().m_76178_()) {
                        chunk.m_8113_((BlockPos)tmp);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private BlockState getState(CarvingContext context, ReplaceableRavineCarverConfig config, BlockPos pos, Aquifer sampler, ChunkAccess chunk) {
        if (pos.m_123342_() <= config.f_159090_.m_142322_((WorldGenerationContext)context)) {
            return f_64982_.m_76188_();
        }
        BlockState blockState = sampler.m_207104_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), 0.0);
        if (blockState == null) {
            return ReplaceableRavineCarver.m_159423_(config) ? config.f_159092_.m_159148_() : Blocks.f_50126_.m_49966_();
        }
        return ReplaceableRavineCarver.m_159423_(config) ? ReplaceableRavineCarver.m_159381_(config, blockState) : (chunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_()) == pos.m_123342_() ? Blocks.f_50126_.m_49966_() : blockState);
    }

    private static BlockState m_159381_(CarverConfiguration config, BlockState state) {
        if (state.m_60713_(Blocks.f_50016_)) {
            return config.f_159092_.m_159145_();
        }
        if (state.m_60713_(Blocks.f_49990_)) {
            BlockState blockState = config.f_159092_.m_159146_();
            return blockState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : blockState;
        }
        return state.m_60713_(Blocks.f_49991_) ? config.f_159092_.m_159147_() : state;
    }

    private static boolean m_159423_(CarverConfiguration config) {
        return config.f_159092_.m_159128_();
    }

    private float[] createHorizontalStretchFactors(CarvingContext context, ReplaceableRavineCarverConfig config, RandomSource random) {
        int i = context.m_142208_();
        float[] fs = new float[i];
        float f = 1.0f;
        for (int j = 0; j < i; ++j) {
            if (j == 0 || random.m_188503_(config.shape.widthSmoothness) == 0) {
                f = 1.0f + random.m_188501_() * random.m_188501_();
            }
            fs[j] = f * f;
        }
        return fs;
    }

    private double getVerticalScale(ReplaceableRavineCarverConfig config, RandomSource random, double pitch, float branchCount, float branchIndex) {
        float f = 1.0f - Mth.m_14154_((float)(0.5f - branchIndex / branchCount)) * 2.0f;
        float g = config.shape.verticalRadiusDefaultFactor + config.shape.verticalRadiusCenterFactor * f;
        return (double)g * pitch * (double)Mth.m_216283_((RandomSource)random, (float)0.75f, (float)1.0f);
    }

    private boolean isPositionExcluded(CarvingContext context, float[] horizontalStretchFactors, double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        int i = y - context.m_142201_();
        return (scaledRelativeX * scaledRelativeX + scaledRelativeZ * scaledRelativeZ) * (double)horizontalStretchFactors[i - 1] + scaledRelativeY * scaledRelativeY / 6.0 >= 1.0;
    }
}

