/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.world.carver.ReplaceableCaveCarverConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class ReplaceableCaveCarver
extends WorldCarver<ReplaceableCaveCarverConfig> {
    public ReplaceableCaveCarver(Codec<ReplaceableCaveCarverConfig> codec) {
        super(codec);
    }

    public boolean isStartChunk(ReplaceableCaveCarverConfig replaceableCaveCarverConfig, RandomSource random) {
        return random.m_188501_() <= replaceableCaveCarverConfig.f_67859_;
    }

    public boolean carve(CarvingContext carverContext, ReplaceableCaveCarverConfig replaceableCaveCarverConfig, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> function, RandomSource random, Aquifer aquiferSampler, ChunkPos chunkPos, CarvingMask carvingMask) {
        int i = SectionPos.m_123223_((int)(this.m_65073_() * 2 - 1));
        int j = random.m_188503_(random.m_188503_(random.m_188503_(this.getMaxCaveCount()) + 1) + 1);
        for (int k = 0; k < j; ++k) {
            float o;
            double d = chunkPos.m_151382_(random.m_188503_(16));
            double e = replaceableCaveCarverConfig.f_159088_.m_213859_(random, (WorldGenerationContext)carverContext);
            double f = chunkPos.m_151391_(random.m_188503_(16));
            double g = replaceableCaveCarverConfig.horizontalRadiusMultiplier.m_214084_(random);
            double h = replaceableCaveCarverConfig.verticalRadiusMultiplier.m_214084_(random);
            double l = replaceableCaveCarverConfig.floorLevel.m_214084_(random);
            WorldCarver.CarveSkipChecker skipPredicate = (contextx, scaledRelativeX, scaledRelativeY, scaledRelativeZ, y) -> ReplaceableCaveCarver.isPositionExcluded(scaledRelativeX, scaledRelativeY, scaledRelativeZ, l);
            int m = 1;
            if (random.m_188503_(4) == 0) {
                double n = replaceableCaveCarverConfig.f_159089_.m_214084_(random);
                o = 1.0f + random.m_188501_() * 6.0f;
                this.carveCave(carverContext, replaceableCaveCarverConfig, chunk, function, aquiferSampler, d, e, f, o, n, carvingMask, skipPredicate);
                m += random.m_188503_(4);
            }
            for (int p = 0; p < m; ++p) {
                float q = random.m_188501_() * ((float)Math.PI * 2);
                o = (random.m_188501_() - 0.5f) / 4.0f;
                float r = this.getTunnelSystemWidth(random);
                int s = i - random.m_188503_(i / 4);
                this.carveTunnels(carverContext, replaceableCaveCarverConfig, chunk, function, random.m_188505_(), aquiferSampler, d, e, f, g, h, r, q, o, 0, s, this.getTunnelSystemHeightWidthRatio(), carvingMask, skipPredicate);
            }
        }
        return true;
    }

    protected boolean carveBlock(CarvingContext context, ReplaceableCaveCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, CarvingMask mask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos tmp, Aquifer aquiferSampler, MutableBoolean replacedGrassy) {
        BlockState blockState = chunk.m_8055_((BlockPos)pos);
        if (blockState.m_60713_(Blocks.f_50440_) || blockState.m_60713_(Blocks.f_50195_) || blockState.m_60713_((Block)NSBlocks.RED_MOSS_BLOCK.get())) {
            replacedGrassy.setTrue();
        }
        if (!this.m_224910_(config, blockState) && !ReplaceableCaveCarver.m_159423_(config)) {
            return false;
        }
        BlockState blockState2 = this.getState(context, config, (BlockPos)pos, aquiferSampler, chunk);
        if (blockState2 == null) {
            return false;
        }
        chunk.m_6978_((BlockPos)pos, blockState2, false);
        if (aquiferSampler.m_142203_() && !blockState2.m_60819_().m_76178_()) {
            chunk.m_8113_((BlockPos)pos);
        }
        if (replacedGrassy.isTrue()) {
            tmp.m_122159_((Vec3i)pos, Direction.DOWN);
            if (chunk.m_8055_((BlockPos)tmp).m_60713_(Blocks.f_50493_)) {
                context.m_190646_(posToBiome, chunk, (BlockPos)tmp, !blockState2.m_60819_().m_76178_()).ifPresent(state -> {
                    chunk.m_6978_((BlockPos)tmp, state, false);
                    if (!state.m_60819_().m_76178_()) {
                        chunk.m_8113_((BlockPos)tmp);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private BlockState getState(CarvingContext context, ReplaceableCaveCarverConfig config, BlockPos pos, Aquifer sampler, ChunkAccess chunk) {
        if (pos.m_123342_() <= config.f_159090_.m_142322_((WorldGenerationContext)context)) {
            return f_64982_.m_76188_();
        }
        BlockState blockState = sampler.m_207104_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), 0.0);
        if (blockState == null) {
            return ReplaceableCaveCarver.m_159423_(config) ? config.f_159092_.m_159148_() : Blocks.f_50126_.m_49966_();
        }
        return ReplaceableCaveCarver.m_159423_(config) ? ReplaceableCaveCarver.m_159381_(config, blockState) : (chunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_()) == pos.m_123342_() ? Blocks.f_50126_.m_49966_() : blockState);
    }

    private static BlockState m_159381_(CarverConfiguration config, BlockState state) {
        if (state.m_60713_(Blocks.f_50016_)) {
            return config.f_159092_.m_159145_();
        }
        if (state.m_60713_(Blocks.f_49990_)) {
            BlockState blockState = config.f_159092_.m_159146_();
            return blockState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : blockState;
        }
        return state.m_60713_(Blocks.f_49991_) ? config.f_159092_.m_159147_() : state;
    }

    private static boolean m_159423_(CarverConfiguration config) {
        return config.f_159092_.m_159128_();
    }

    protected int getMaxCaveCount() {
        return 15;
    }

    protected float getTunnelSystemWidth(RandomSource random) {
        float f = random.m_188501_() * 2.0f + random.m_188501_();
        if (random.m_188503_(10) == 0) {
            f *= random.m_188501_() * random.m_188501_() * 3.0f + 1.0f;
        }
        return f;
    }

    protected double getTunnelSystemHeightWidthRatio() {
        return 1.0;
    }

    protected void carveCave(CarvingContext context, ReplaceableCaveCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, Aquifer aquiferSampler, double d, double e, double f, float g, double h, CarvingMask mask, WorldCarver.CarveSkipChecker skipPredicate) {
        double i = 1.5 + (double)(Mth.m_14031_((float)1.5707964f) * g);
        double j = i * h;
        this.m_190753_(context, config, chunk, posToBiome, aquiferSampler, d + 1.0, e, f, i, j, mask, skipPredicate);
    }

    protected void carveTunnels(CarvingContext context, ReplaceableCaveCarverConfig config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> posToBiome, long seed, Aquifer aquiferSampler, double x, double y, double z, double horizontalScale, double verticalScale, float width, float yaw, float pitch, int branchStartIndex, int branchCount, double yawPitchRatio, CarvingMask mask, WorldCarver.CarveSkipChecker skipPredicate) {
        RandomSource random = RandomSource.m_216335_((long)seed);
        int i = random.m_188503_(branchCount / 2) + branchCount / 4;
        boolean bl = random.m_188503_(6) == 0;
        float f = 0.0f;
        float g = 0.0f;
        for (int j = branchStartIndex; j < branchCount; ++j) {
            double d = 1.5 + (double)(Mth.m_14031_((float)((float)Math.PI * (float)j / (float)branchCount)) * width);
            double e = d * yawPitchRatio;
            float h = Mth.m_14089_((float)pitch);
            x += (double)(Mth.m_14089_((float)yaw) * h);
            y += (double)Mth.m_14031_((float)pitch);
            z += (double)(Mth.m_14031_((float)yaw) * h);
            pitch *= bl ? 0.92f : 0.7f;
            pitch += g * 0.1f;
            yaw += f * 0.1f;
            g *= 0.9f;
            f *= 0.75f;
            g += (random.m_188501_() - random.m_188501_()) * random.m_188501_() * 2.0f;
            f += (random.m_188501_() - random.m_188501_()) * random.m_188501_() * 4.0f;
            if (j == i && width > 1.0f) {
                this.carveTunnels(context, config, chunk, posToBiome, random.m_188505_(), aquiferSampler, x, y, z, horizontalScale, verticalScale, random.m_188501_() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, j, branchCount, 1.0, mask, skipPredicate);
                this.carveTunnels(context, config, chunk, posToBiome, random.m_188505_(), aquiferSampler, x, y, z, horizontalScale, verticalScale, random.m_188501_() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, j, branchCount, 1.0, mask, skipPredicate);
                return;
            }
            if (random.m_188503_(4) == 0) continue;
            if (!ReplaceableCaveCarver.m_159367_((ChunkPos)chunk.m_7697_(), (double)x, (double)z, (int)j, (int)branchCount, (float)width)) {
                return;
            }
            this.m_190753_(context, config, chunk, posToBiome, aquiferSampler, x, y, z, d * horizontalScale, e * verticalScale, mask, skipPredicate);
        }
    }

    private static boolean isPositionExcluded(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, double floorY) {
        if (scaledRelativeY <= floorY) {
            return true;
        }
        return scaledRelativeX * scaledRelativeX + scaledRelativeY * scaledRelativeY + scaledRelativeZ * scaledRelativeZ >= 1.0;
    }
}

