/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.hibiscus.naturespirit.config.NSConfig;
import net.hibiscus.naturespirit.registration.NSBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;

public class TerraLaetaParameters
extends OverworldBiomeBuilder {
    private final Climate.Parameter defaultParameter = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    private final Climate.Parameter[] temperatureParameters = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidityParameters = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosionParameters = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter frozenTemperature;
    private final Climate.Parameter erodedRiverTemperatureParameters;
    private final Climate.Parameter riverTemperatureParameters;
    private final Climate.Parameter mushroomFieldsContinentalness;
    private final Climate.Parameter deepOceanContinentalness;
    private final Climate.Parameter oceanContinentalness;
    private final Climate.Parameter coastContinentalness;
    private final Climate.Parameter riverContinentalness;
    private final Climate.Parameter nearInlandContinentalness;
    private final Climate.Parameter midInlandContinentalness;
    private final Climate.Parameter farInlandContinentalness;
    private final ResourceKey<Biome>[][] oceanBiomes;
    private final ResourceKey<Biome>[][] commonBiomes;
    private final ResourceKey<Biome>[][] uncommonBiomes;
    private final ResourceKey<Biome>[][] nearMountainBiomes;
    private final ResourceKey<Biome>[][] specialNearMountainBiomes;
    private final ResourceKey<Biome>[][] windsweptBiomes;
    ResourceKey<Biome> commonBiomeDesertHot = NSConfig.hasXericPlains && NSConfig.hasDrylands ? NSBiomes.DRYLANDS : Biomes.f_48203_;
    ResourceKey<Biome> commonBiomeDesertHot2 = NSConfig.hasXericPlains ? NSBiomes.XERIC_PLAINS : Biomes.f_48203_;
    ResourceKey<Biome> nearBiomeBadlandsHot = NSConfig.hasXericPlains && NSConfig.hasDrylands ? NSBiomes.DRYLANDS : Biomes.f_48159_;
    ResourceKey<Biome> nearBiomeWoodedBadlandsHot = NSConfig.hasXericPlains && NSConfig.hasDrylands ? NSBiomes.DRYLANDS : Biomes.f_186753_;
    ResourceKey<Biome> specialBiomeErodedBadlandsHot = NSConfig.hasXericPlains ? null : Biomes.f_48194_;
    ResourceKey<Biome> commonBiomeSavannaWarm = NSConfig.hasXericPlains ? NSBiomes.XERIC_PLAINS : Biomes.f_48157_;
    ResourceKey<Biome> uncommonBiomePlainsWarm = NSConfig.hasCypressFields ? null : Biomes.f_48202_;
    ResourceKey<Biome> commonBiomeForestWarm = NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.f_48205_;
    ResourceKey<Biome> commonBiomeJungleWarm;
    ResourceKey<Biome> commonBiomeJungleWarm2;
    ResourceKey<Biome> nearBiomeSavannaPlateauWarm;
    ResourceKey<Biome> nearBiomeForestWarm;
    ResourceKey<Biome> nearBiomeForestWarm2;
    ResourceKey<Biome> nearBiomeJungleWarm;
    ResourceKey<Biome> uncommonSparseJungleWarm;
    ResourceKey<Biome> uncommonBambooJungleWarm;
    ResourceKey<Biome> specialBiomeCedar;
    ResourceKey<Biome> specialBiomeNull;
    ResourceKey<Biome> commonBiomePlainsCold;
    ResourceKey<Biome> uncommonBiomePlainsCold;
    ResourceKey<Biome> commonBiomeForestCold;
    ResourceKey<Biome> specialBiomeMeadowCold;
    ResourceKey<Biome> commonBiomeSnowyPlainsFrozen;
    ResourceKey<Biome> nearBiomeMeadowCold;
    ResourceKey<Biome> nearBiomeForestCold;
    ResourceKey<Biome> commonBiomeTaiga;
    ResourceKey<Biome> commonBiomeOldTaiga;
    ResourceKey<Biome> uncommonBiomeOldTaiga;
    ResourceKey<Biome> uncommonBiomeTaiga;
    ResourceKey<Biome> specialNearBiomeCherryCold;
    ResourceKey<Biome> commonBiomeSnowyTaigaFrozen;
    ResourceKey<Biome> uncommonBiomeSnowyTaigaFrozen;
    ResourceKey<Biome> commonBiomeTaigaFrozen;
    ResourceKey[] windsweptFrozen;
    ResourceKey[] windsweptCold;

    public TerraLaetaParameters() {
        ResourceKey[] resourceKeyArray;
        ResourceKey[] resourceKeyArray2;
        ResourceKey resourceKey = this.commonBiomeJungleWarm = NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.f_48222_;
        this.commonBiomeJungleWarm2 = NSConfig.hasLavenderFields ? NSBiomes.LAVENDER_FIELDS : (NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.f_48222_);
        this.nearBiomeSavannaPlateauWarm = NSConfig.hasXericPlains ? NSBiomes.XERIC_PLAINS : Biomes.f_48158_;
        this.nearBiomeForestWarm = NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.f_48205_;
        ResourceKey resourceKey2 = this.nearBiomeForestWarm2 = NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.f_48205_;
        this.nearBiomeJungleWarm = NSConfig.hasLavenderFields ? NSBiomes.LAVENDER_FIELDS : (NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.f_48222_);
        ResourceKey resourceKey3 = this.uncommonSparseJungleWarm = NSConfig.hasCypressFields ? null : Biomes.f_186769_;
        this.uncommonBambooJungleWarm = NSConfig.hasCarnationFields ? NSBiomes.CARNATION_FIELDS : (NSConfig.hasCypressFields ? NSBiomes.CYPRESS_FIELDS : Biomes.f_48197_);
        this.specialBiomeCedar = NSConfig.hasCedarThicket ? NSBiomes.CEDAR_THICKET : null;
        this.specialBiomeNull = NSConfig.hasCypressFields ? NSBiomes.CARNATION_FIELDS : null;
        this.commonBiomePlainsCold = NSConfig.hasAlpineClearings ? NSBiomes.ALPINE_CLEARINGS : Biomes.f_48202_;
        this.uncommonBiomePlainsCold = NSConfig.hasHeatherFields ? NSBiomes.HEATHER_FIELDS : null;
        this.commonBiomeForestCold = NSConfig.hasAlpineClearings ? NSBiomes.ALPINE_CLEARINGS : Biomes.f_48205_;
        this.specialBiomeMeadowCold = NSConfig.hasAlpineClearings ? null : Biomes.f_186754_;
        this.commonBiomeSnowyPlainsFrozen = NSConfig.hasTundra && (NSConfig.hasAlpineHighlands || NSConfig.hasAlpineClearings) ? NSBiomes.TUNDRA : Biomes.f_186761_;
        ResourceKey resourceKey4 = this.nearBiomeMeadowCold = NSConfig.hasAlpineHighlands ? NSBiomes.ALPINE_HIGHLANDS : Biomes.f_186754_;
        this.nearBiomeForestCold = NSConfig.hasAlpineHighlands ? NSBiomes.ALPINE_HIGHLANDS : (NSConfig.hasAlpineClearings ? Biomes.f_186754_ : Biomes.f_48205_);
        this.commonBiomeTaiga = NSConfig.hasConiferousCovert ? NSBiomes.CONIFEROUS_COVERT : Biomes.f_48206_;
        this.commonBiomeOldTaiga = NSConfig.hasConiferousCovert ? NSBiomes.CONIFEROUS_COVERT : Biomes.f_186764_;
        this.uncommonBiomeOldTaiga = NSConfig.hasConiferousCovert ? NSBiomes.CONIFEROUS_COVERT : Biomes.f_186763_;
        ResourceKey resourceKey5 = this.uncommonBiomeTaiga = NSConfig.hasConiferousCovert ? NSBiomes.CONIFEROUS_COVERT : Biomes.f_186763_;
        this.specialNearBiomeCherryCold = NSConfig.hasHeatherFields ? NSBiomes.HEATHER_FIELDS : (NSConfig.hasAlpineClearings ? NSBiomes.ALPINE_CLEARINGS : Biomes.f_271432_);
        this.commonBiomeSnowyTaigaFrozen = NSConfig.hasBorealTaiga ? NSBiomes.BOREAL_TAIGA : Biomes.f_48152_;
        this.uncommonBiomeSnowyTaigaFrozen = NSConfig.hasBorealTaiga ? NSBiomes.BOREAL_TAIGA : Biomes.f_48152_;
        ResourceKey resourceKey6 = this.commonBiomeTaigaFrozen = NSConfig.hasBorealTaiga ? NSBiomes.BOREAL_TAIGA : Biomes.f_48206_;
        if (NSConfig.hasTundra && NSConfig.hasAlpineClearings) {
            ResourceKey[] resourceKeyArray3 = new ResourceKey[5];
            resourceKeyArray3[0] = NSBiomes.TUNDRA;
            resourceKeyArray3[1] = NSBiomes.TUNDRA;
            resourceKeyArray3[2] = NSBiomes.TUNDRA;
            resourceKeyArray3[3] = NSBiomes.TUNDRA;
            resourceKeyArray2 = resourceKeyArray3;
            resourceKeyArray3[4] = NSBiomes.TUNDRA;
        } else {
            ResourceKey[] resourceKeyArray4 = new ResourceKey[5];
            resourceKeyArray4[0] = Biomes.f_186766_;
            resourceKeyArray4[1] = Biomes.f_186766_;
            resourceKeyArray4[2] = Biomes.f_186765_;
            resourceKeyArray4[3] = Biomes.f_186767_;
            resourceKeyArray2 = resourceKeyArray4;
            resourceKeyArray4[4] = Biomes.f_186767_;
        }
        this.windsweptFrozen = resourceKeyArray2;
        if (NSConfig.hasAlpineHighlands) {
            ResourceKey[] resourceKeyArray5 = new ResourceKey[5];
            resourceKeyArray5[0] = NSBiomes.ALPINE_HIGHLANDS;
            resourceKeyArray5[1] = NSBiomes.ALPINE_HIGHLANDS;
            resourceKeyArray5[2] = NSBiomes.ALPINE_HIGHLANDS;
            resourceKeyArray5[3] = NSBiomes.ALPINE_HIGHLANDS;
            resourceKeyArray = resourceKeyArray5;
            resourceKeyArray5[4] = NSBiomes.ALPINE_HIGHLANDS;
        } else {
            ResourceKey[] resourceKeyArray6 = new ResourceKey[5];
            resourceKeyArray6[0] = Biomes.f_186766_;
            resourceKeyArray6[1] = Biomes.f_186766_;
            resourceKeyArray6[2] = Biomes.f_186765_;
            resourceKeyArray6[3] = Biomes.f_186767_;
            resourceKeyArray = resourceKeyArray6;
            resourceKeyArray6[4] = Biomes.f_186767_;
        }
        this.windsweptCold = resourceKeyArray;
        this.frozenTemperature = this.temperatureParameters[0];
        this.erodedRiverTemperatureParameters = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatureParameters[1], (Climate.Parameter)this.temperatureParameters[2]);
        this.riverTemperatureParameters = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatureParameters[3], (Climate.Parameter)this.temperatureParameters[4]);
        this.mushroomFieldsContinentalness = Climate.Parameter.m_186822_((float)-1.2f, (float)-1.05f);
        this.deepOceanContinentalness = Climate.Parameter.m_186822_((float)-1.05f, (float)-0.455f);
        this.oceanContinentalness = Climate.Parameter.m_186822_((float)-0.455f, (float)-0.19f);
        this.coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
        this.riverContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
        this.nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
        this.midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
        this.farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);
        this.oceanBiomes = new ResourceKey[][]{{Biomes.f_48172_, Biomes.f_48171_, Biomes.f_48225_, Biomes.f_48170_, Biomes.f_48166_}, {Biomes.f_48211_, Biomes.f_48168_, Biomes.f_48174_, Biomes.f_48167_, Biomes.f_48166_}};
        this.commonBiomes = new ResourceKey[][]{{this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyTaigaFrozen, this.commonBiomeTaigaFrozen}, {this.commonBiomePlainsCold, this.commonBiomePlainsCold, this.commonBiomeForestCold, this.commonBiomeTaiga, this.commonBiomeOldTaiga}, {Biomes.f_48179_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48151_}, {this.commonBiomeSavannaWarm, this.commonBiomeSavannaWarm, this.commonBiomeForestWarm, this.commonBiomeJungleWarm, this.commonBiomeJungleWarm2}, {this.commonBiomeDesertHot, this.commonBiomeDesertHot, this.commonBiomeDesertHot, this.commonBiomeDesertHot2, this.commonBiomeDesertHot2}};
        this.uncommonBiomes = new ResourceKey[][]{{Biomes.f_48182_, null, this.uncommonBiomeSnowyTaigaFrozen, null, null}, {this.uncommonBiomePlainsCold, null, null, this.uncommonBiomeTaiga, this.uncommonBiomeOldTaiga}, {null, null, null, null, null}, {this.specialBiomeCedar, null, this.uncommonBiomePlainsWarm, this.uncommonSparseJungleWarm, this.uncommonBambooJungleWarm}, {null, null, null, null, null}};
        this.nearMountainBiomes = new ResourceKey[][]{{this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyPlainsFrozen, this.commonBiomeSnowyTaigaFrozen, this.commonBiomeSnowyTaigaFrozen}, {this.nearBiomeMeadowCold, this.nearBiomeMeadowCold, this.nearBiomeForestCold, this.commonBiomeTaiga, this.commonBiomeOldTaiga}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48151_}, {this.nearBiomeSavannaPlateauWarm, this.nearBiomeSavannaPlateauWarm, this.nearBiomeForestWarm, this.nearBiomeForestWarm2, this.nearBiomeJungleWarm}, {this.nearBiomeBadlandsHot, this.nearBiomeBadlandsHot, this.nearBiomeBadlandsHot, this.nearBiomeWoodedBadlandsHot, this.nearBiomeWoodedBadlandsHot}};
        this.specialNearMountainBiomes = new ResourceKey[][]{{Biomes.f_48182_, null, null, null, null}, {this.specialNearBiomeCherryCold, null, this.specialBiomeMeadowCold, null, this.uncommonBiomeOldTaiga}, {Biomes.f_271432_, Biomes.f_271432_, Biomes.f_48205_, Biomes.f_48149_, null}, {this.specialBiomeCedar, null, null, null, this.specialBiomeNull}, {this.specialBiomeErodedBadlandsHot, this.specialBiomeErodedBadlandsHot, null, null, null}};
        this.windsweptBiomes = new ResourceKey[][]{this.windsweptFrozen, this.windsweptCold, {Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {null, null, null, null, null}, {null, null, null, null, null}};
    }

    protected void m_187175_(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.m_187195_(parameters);
        this.m_187215_(parameters);
        this.m_187226_(parameters);
    }

    private void m_187195_(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.m_187180_(parameters, this.defaultParameter, this.defaultParameter, this.mushroomFieldsContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, (ResourceKey<Biome>)Biomes.f_48215_);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            this.m_187180_(parameters, parameterRange, this.defaultParameter, this.deepOceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[0][i]);
            this.m_187180_(parameters, parameterRange, this.defaultParameter, this.oceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[1][i]);
        }
    }

    private void m_187215_(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters) {
        this.m_187217_(parameters, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
        this.m_187197_(parameters, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
        this.m_187177_(parameters, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
        this.m_187197_(parameters, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
        this.m_187217_(parameters, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
        this.m_187228_(parameters, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
        this.m_187237_(parameters, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
        this.m_187228_(parameters, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
        this.m_187217_(parameters, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
        this.m_187197_(parameters, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
        this.m_187177_(parameters, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
        this.m_187197_(parameters, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
        this.m_187217_(parameters, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
    }

    private void m_187177_(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.m_187163_(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.getXericPlainsOrRegularBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.m_187211_(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.m_187233_(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.m_202001_(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = this.m_201990_(i, j, weirdness, registryKey5);
                ResourceKey<Biome> registryKey7 = this.m_187240_(i, j, weirdness);
                ResourceKey<Biome> registryKey10 = this.getShoreCliffBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey11 = this.getBiomeOrChalkCliffs(i, j, weirdness, registryKey5);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[0], weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey10 : registryKey7);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[1], weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey10 : registryKey3);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[2], weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey10 : registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, registryKey3);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey2 : registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey2 : registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey11 : registryKey6);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void m_187197_(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.m_187163_(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.getXericPlainsOrRegularBiome(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.m_187211_(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.m_187233_(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.m_202001_(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = NSConfig.hasWhiteCliffs ? this.getBiomeOrChalkCliffs(i, j, weirdness, registryKey) : this.m_201990_(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey7 = this.m_187244_(i, j, weirdness);
                ResourceKey<Biome> registryKey8 = this.m_187240_(i, j, weirdness);
                ResourceKey<Biome> registryKey11 = this.getShoreCliffBiome(i, j, weirdness);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[2]), weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey11 : registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey8);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void m_187217_(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.m_187163_(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.m_187191_(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.m_187211_(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.m_202001_(i, j, weirdness);
                ResourceKey<Biome> registryKey5 = this.m_187233_(i, j, weirdness);
                ResourceKey<Biome> registryKey6 = this.m_187160_(i, j);
                ResourceKey<Biome> registryKey7 = NSConfig.hasWhiteCliffs ? this.getBiomeOrChalkCliffs(i, j, weirdness, registryKey) : this.m_201990_(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey8 = this.m_187222_(i, j, weirdness);
                ResourceKey<Biome> registryKey9 = this.m_187244_(i, j, weirdness);
                ResourceKey registryKey12 = this.getShoreCliffBiome(i, j, weirdness);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[2]), weirdness, 0.0f, (ResourceKey<Biome>)(NSConfig.hasWhiteCliffs ? registryKey12 : Biomes.f_186760_));
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey9);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, i == 0 ? registryKey9 : registryKey5);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey : registryKey2);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey5);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey : registryKey2);
                if (weirdness.f_186814_() < 0L) {
                    this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey6);
                    this.m_187180_(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey);
                    this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                } else {
                    this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                    this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                }
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey8);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey7);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey4);
                if (weirdness.f_186814_() < 0L) {
                    this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey6);
                } else {
                    this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey);
                }
                if (i != 0) continue;
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void m_187228_(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = this.m_187163_(i, j, weirdness);
                ResourceKey<Biome> registryKey2 = this.m_187191_(i, j, weirdness);
                ResourceKey<Biome> registryKey3 = this.m_187211_(i, j, weirdness);
                ResourceKey<Biome> registryKey4 = this.m_187160_(i, j);
                ResourceKey<Biome> registryKey5 = NSConfig.hasWhiteCliffs ? this.getBiomeOrChalkCliffs(i, j, weirdness, registryKey) : this.m_201990_(i, j, weirdness, registryKey);
                ResourceKey<Biome> registryKey6 = this.m_187222_(i, j, weirdness);
                ResourceKey<Biome> registryKey8 = this.getShoreCliffBiome(i, j, weirdness);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, NSConfig.hasWhiteCliffs ? registryKey8 : registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey : registryKey2);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey3);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[3]), weirdness, 0.0f, NSConfig.hasXericPlains ? registryKey : registryKey2);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey4);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey4);
                if (i != 0) continue;
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void m_187237_(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter weirdness) {
        this.m_187180_(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.f_186814_() < 0L ? Biomes.f_186760_ : Biomes.f_48212_));
        this.m_187180_(parameters, this.riverTemperatureParameters, this.defaultParameter, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.f_186814_() < 0L ? Biomes.f_186760_ : Biomes.f_48208_));
        this.m_187180_(parameters, this.erodedRiverTemperatureParameters, this.defaultParameter, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.f_186814_() < 0L ? Biomes.f_186760_ : Biomes.f_48208_));
        this.m_187180_(parameters, this.frozenTemperature, this.defaultParameter, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.m_187180_(parameters, this.riverTemperatureParameters, this.defaultParameter, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.m_187180_(parameters, this.erodedRiverTemperatureParameters, this.defaultParameter, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.m_187180_(parameters, this.frozenTemperature, this.defaultParameter, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.m_187180_(parameters, this.riverTemperatureParameters, this.defaultParameter, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.m_187180_(parameters, this.erodedRiverTemperatureParameters, this.defaultParameter, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[2], (Climate.Parameter)this.erosionParameters[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.m_187180_(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.m_187180_(parameters, this.riverTemperatureParameters, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.m_187180_(parameters, this.erodedRiverTemperatureParameters, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.m_187180_(parameters, this.frozenTemperature, this.defaultParameter, Climate.Parameter.m_186829_((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            Climate.Parameter parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                Climate.Parameter parameterRange2 = this.humidityParameters[j];
                ResourceKey<Biome> registryKey = NSConfig.hasXericPlains ? this.m_187163_(i, j, weirdness) : this.m_187191_(i, j, weirdness);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosionParameters[0], (Climate.Parameter)this.erosionParameters[1]), weirdness, 0.0f, registryKey);
                this.m_187180_(parameters, parameterRange, parameterRange2, Climate.Parameter.m_186829_((Climate.Parameter)this.riverContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
            }
        }
    }

    private ResourceKey<Biome> m_187163_(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.f_186814_() < 0L) {
            return this.commonBiomes[temperature][humidity];
        }
        ResourceKey<Biome> registryKey = this.uncommonBiomes[temperature][humidity];
        return registryKey == null ? this.commonBiomes[temperature][humidity] : registryKey;
    }

    private ResourceKey<Biome> m_187172_(int humidity, Climate.Parameter weirdness) {
        if (humidity < 2) {
            return weirdness.f_186814_() < 0L ? Biomes.f_48159_ : Biomes.f_48194_;
        }
        return humidity < 3 ? Biomes.f_48159_ : Biomes.f_186753_;
    }

    private ResourceKey<Biome> m_187191_(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 4 ? this.m_187172_(humidity, weirdness) : this.m_187163_(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> getWetlandType(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature == 0) {
            return this.m_187163_(temperature, humidity, weirdness);
        }
        if ((humidity <= 3 || temperature >= 3) && NSConfig.hasMarsh) {
            return NSBiomes.MARSH;
        }
        return Biomes.f_48207_;
    }

    private ResourceKey<Biome> getXericPlainsOrRegularBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 4 ? (NSConfig.hasXericPlains ? NSBiomes.XERIC_PLAINS : this.m_187172_(humidity, weirdness)) : this.m_187163_(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> m_187211_(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 0 ? this.m_187244_(temperature, humidity, weirdness) : this.m_187163_(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> m_201990_(int temperature, int humidity, Climate.Parameter weirdness, ResourceKey<Biome> biomeKey) {
        return temperature > 1 && humidity < 4 && weirdness.f_186814_() >= 0L ? (NSConfig.hasXericPlains ? NSBiomes.XERIC_PLAINS : Biomes.f_186768_) : biomeKey;
    }

    private ResourceKey<Biome> getBiomeOrChalkCliffs(int temperature, int humidity, Climate.Parameter weirdness, ResourceKey<Biome> biomeKey) {
        return temperature > 1 && temperature < 4 && humidity < 4 && humidity > 0 && weirdness.f_186814_() >= 0L ? NSBiomes.WHITE_CLIFFS : this.m_201990_(temperature, humidity, weirdness, biomeKey);
    }

    private ResourceKey<Biome> m_187222_(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey = weirdness.f_186814_() >= 0L ? this.m_187163_(temperature, humidity, weirdness) : this.m_187160_(temperature, humidity);
        return this.getBiomeOrChalkCliffs(temperature, humidity, weirdness, registryKey);
    }

    private ResourceKey<Biome> m_187160_(int temperature, int humidity) {
        if (temperature == 0) {
            return Biomes.f_48148_;
        }
        if (temperature == 3 && humidity > 2 && NSConfig.hasTropicalShores) {
            return NSBiomes.TROPICAL_SHORES;
        }
        return temperature == 4 ? (NSConfig.hasXericPlains ? NSBiomes.DRYLANDS : Biomes.f_48203_) : Biomes.f_48217_;
    }

    private ResourceKey<Biome> getShoreCliffBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature < 4 && temperature > 0 ? NSBiomes.WHITE_CLIFFS : Biomes.f_186760_;
    }

    private ResourceKey<Biome> m_187233_(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey;
        if (weirdness.f_186814_() >= 0L && (registryKey = this.specialNearMountainBiomes[temperature][humidity]) != null) {
            return registryKey;
        }
        return this.nearMountainBiomes[temperature][humidity];
    }

    private ResourceKey<Biome> m_187240_(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature <= 1 && (NSConfig.hasAlpineHighlands || NSConfig.hasAlpineClearings) && humidity <= 2 && weirdness.f_186814_() >= 0L) {
            return Biomes.f_186759_;
        }
        if (temperature <= 2) {
            return weirdness.f_186814_() < 0L ? Biomes.f_186758_ : Biomes.f_186757_;
        }
        return temperature == 3 ? (NSConfig.hasRedPeaks && humidity < 3 ? NSBiomes.RED_PEAKS : Biomes.f_186759_) : (NSConfig.hasRedPeaks ? NSBiomes.RED_PEAKS : this.m_187172_(humidity, weirdness));
    }

    private ResourceKey<Biome> m_187244_(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature == 4) {
            return NSConfig.hasDustySlopes ? NSBiomes.DUSTY_SLOPES : this.m_187233_(temperature, humidity, weirdness);
        }
        if (temperature >= 3) {
            return this.m_187233_(temperature, humidity, weirdness);
        }
        if (NSConfig.hasTundra && (NSConfig.hasAlpineClearings || NSConfig.hasAlpineHighlands)) {
            return humidity <= 2 && temperature <= 1 && weirdness.f_186814_() >= 0L ? NSBiomes.TUNDRA : Biomes.f_186755_;
        }
        return humidity <= 1 ? Biomes.f_186756_ : Biomes.f_186755_;
    }

    private ResourceKey<Biome> m_202001_(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> registryKey = this.windsweptBiomes[temperature][humidity];
        return registryKey == null ? this.m_187163_(temperature, humidity, weirdness) : registryKey;
    }

    private void m_187180_(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> parameters, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        parameters.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        parameters.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }
}

