/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.registration.sets;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.hibiscus.naturespirit.blocks.BranchingTrunkBlock;
import net.hibiscus.naturespirit.blocks.DownwardVineBlock;
import net.hibiscus.naturespirit.blocks.DownwardsVinePlantBlock;
import net.hibiscus.naturespirit.blocks.NSHangingSignBlock;
import net.hibiscus.naturespirit.blocks.NSStandingSignBlock;
import net.hibiscus.naturespirit.blocks.NSWallHangingSignBlock;
import net.hibiscus.naturespirit.blocks.NSWallSignBlock;
import net.hibiscus.naturespirit.blocks.ParticleLeavesBlock;
import net.hibiscus.naturespirit.blocks.ProjectileLeavesBlock;
import net.hibiscus.naturespirit.blocks.SandySaplingBlock;
import net.hibiscus.naturespirit.blocks.VinesLeavesBlock;
import net.hibiscus.naturespirit.entity.NSBoatEntity;
import net.hibiscus.naturespirit.items.NSBoatItem;
import net.hibiscus.naturespirit.registration.NSParticleTypes;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.hibiscus.naturespirit.world.tree.BlueWisteriaSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.OrangeMapleSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.PinkWisteriaSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.PurpleWisteriaSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.RedMapleSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.WhiteWisteriaSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.YellowMapleSaplingGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.RegistryObject;

public class WoodSet {
    private final List<RegistryObject<Block>> registeredBlocksList = new ArrayList<RegistryObject<Block>>();
    private final List<RegistryObject<Item>> registeredItemsList = new ArrayList<RegistryObject<Item>>();
    private final String name;
    private final MapColor sideColor;
    private final MapColor topColor;
    private final WoodPreset woodPreset;
    private com.google.common.base.Supplier<BlockSetType> blockSetType;
    private com.google.common.base.Supplier<WoodType> woodType;
    private RegistryObject<Block> log;
    private RegistryObject<Block> strippedLog;
    private RegistryObject<Block> bundle;
    private RegistryObject<Block> strippedBundle;
    private RegistryObject<Block> wood;
    private RegistryObject<Block> strippedWood;
    private RegistryObject<Block> leaves;
    private RegistryObject<Block> frostyLeaves;
    private RegistryObject<Block> sapling;
    private RegistryObject<Block> pottedSapling;
    private RegistryObject<Block> redLeaves;
    private RegistryObject<Block> redSapling;
    private RegistryObject<Block> pottedRedSapling;
    private RegistryObject<Block> orangeLeaves;
    private RegistryObject<Block> orangeSapling;
    private RegistryObject<Block> pottedOrangeSapling;
    private RegistryObject<Block> yellowLeaves;
    private RegistryObject<Block> yellowSapling;
    private RegistryObject<Block> pottedYellowSapling;
    private RegistryObject<Block> blueLeaves;
    private RegistryObject<Block> partBlueLeaves;
    private RegistryObject<Block> blueSapling;
    private RegistryObject<Block> pottedBlueSapling;
    private RegistryObject<Block> purpleLeaves;
    private RegistryObject<Block> partPurpleLeaves;
    private RegistryObject<Block> purpleSapling;
    private RegistryObject<Block> pottedPurpleSapling;
    private RegistryObject<Block> pinkLeaves;
    private RegistryObject<Block> partPinkLeaves;
    private RegistryObject<Block> pinkSapling;
    private RegistryObject<Block> pottedPinkSapling;
    private RegistryObject<Block> whiteLeaves;
    private RegistryObject<Block> partWhiteLeaves;
    private RegistryObject<Block> whiteSapling;
    private RegistryObject<Block> pottedWhiteSapling;
    private RegistryObject<Block> vines;
    private RegistryObject<Block> vinesPlant;
    private RegistryObject<Block> blueVines;
    private RegistryObject<Block> purpleVines;
    private RegistryObject<Block> pinkVines;
    private RegistryObject<Block> whiteVines;
    private RegistryObject<Block> blueVinesPlant;
    private RegistryObject<Block> purpleVinesPlant;
    private RegistryObject<Block> pinkVinesPlant;
    private RegistryObject<Block> whiteVinesPlant;
    private RegistryObject<Block> planks;
    private RegistryObject<Block> stairs;
    private RegistryObject<Block> slab;
    private RegistryObject<Block> mosaic;
    private RegistryObject<Block> mosaicStairs;
    private RegistryObject<Block> mosaicSlab;
    private RegistryObject<Block> fence;
    private RegistryObject<Block> fenceGate;
    private RegistryObject<Block> pressurePlate;
    private RegistryObject<Block> button;
    private RegistryObject<Block> door;
    private RegistryObject<Block> trapDoor;
    private RegistryObject<Block> sign;
    private RegistryObject<Block> wallSign;
    private RegistryObject<Block> hangingSign;
    private RegistryObject<Block> hangingWallSign;
    private RegistryObject<Item> signItem;
    private RegistryObject<Item> hangingSignItem;
    private RegistryObject<Item> boatItem;
    private RegistryObject<Item> chestBoatItem;
    private final com.google.common.base.Supplier<NSBoatEntity.Type> boatType;
    private final AbstractTreeGrower saplingGenerator;
    private final boolean hasMosaic;

    private void registerWood() {
        this.blockSetType = this.createBlockSetType();
        this.woodType = Suppliers.memoize(() -> WoodType.m_61844_((WoodType)new WoodType("natures_spirit:" + this.getName(), (BlockSetType)this.blockSetType.get())));
        this.log = this.woodPreset == WoodPreset.JOSHUA ? this.createJoshuaLog() : this.createLog();
        RegistryObject<Block> registryObject = this.strippedLog = this.woodPreset == WoodPreset.JOSHUA ? this.createStrippedJoshuaLog() : this.createStrippedLog();
        if (this.woodPreset == WoodPreset.JOSHUA) {
            this.bundle = this.createBundle();
            this.strippedBundle = this.createStrippedBundle();
        }
        if (this.woodPreset != WoodPreset.BAMBOO && this.woodPreset != WoodPreset.JOSHUA) {
            this.wood = this.createWood();
            this.strippedWood = this.createStrippedWood();
        }
        if (this.hasDefaultLeaves()) {
            this.leaves = this.createLeaves();
            if (this.hasDefaultSapling()) {
                this.sapling = this.isSandy() ? this.createSandySapling(this.saplingGenerator) : this.createSapling(this.saplingGenerator);
                this.pottedSapling = this.createPottedSapling(this.sapling);
            }
        }
        if (this.woodPreset == WoodPreset.FROSTABLE) {
            this.frostyLeaves = this.createLeaves("frosty_");
            this.leaves = this.createFrostableLeaves();
            this.sapling = this.createSapling(this.saplingGenerator);
            this.pottedSapling = this.createPottedSapling(this.sapling);
        }
        if (this.woodPreset == WoodPreset.WILLOW) {
            this.vines = this.createVines((com.google.common.base.Supplier<RegistryObject<Block>>)((com.google.common.base.Supplier)this::getVinesPlant));
            this.vinesPlant = this.createVinesPlant(this.vines);
            this.leaves = this.createVinesLeavesBlock(this.vinesPlant, this.vines);
            this.sapling = this.createSapling(this.saplingGenerator);
            this.pottedSapling = this.createPottedSapling(this.sapling);
        }
        if (this.woodPreset == WoodPreset.WISTERIA) {
            this.whiteVines = this.createVines("white_", (com.google.common.base.Supplier<RegistryObject<Block>>)((com.google.common.base.Supplier)this::getWhiteVinesPlant));
            this.blueVines = this.createVines("blue_", (com.google.common.base.Supplier<RegistryObject<Block>>)((com.google.common.base.Supplier)this::getBlueVinesPlant));
            this.pinkVines = this.createVines("pink_", (com.google.common.base.Supplier<RegistryObject<Block>>)((com.google.common.base.Supplier)this::getPinkVinesPlant));
            this.purpleVines = this.createVines("purple_", (com.google.common.base.Supplier<RegistryObject<Block>>)((com.google.common.base.Supplier)this::getPurpleVinesPlant));
            this.whiteVinesPlant = this.createVinesPlant("white_", this.whiteVines);
            this.blueVinesPlant = this.createVinesPlant("blue_", this.blueVines);
            this.pinkVinesPlant = this.createVinesPlant("pink_", this.pinkVines);
            this.purpleVinesPlant = this.createVinesPlant("purple_", this.purpleVines);
            this.whiteLeaves = this.createVinesLeavesBlock("white_", this.whiteVinesPlant, this.whiteVines);
            this.partWhiteLeaves = this.createVinesLeavesBlock("part_white_", this.whiteVinesPlant, this.whiteVines);
            this.blueLeaves = this.createVinesLeavesBlock("blue_", this.blueVinesPlant, this.blueVines);
            this.partBlueLeaves = this.createVinesLeavesBlock("part_blue_", this.blueVinesPlant, this.blueVines);
            this.pinkLeaves = this.createVinesLeavesBlock("pink_", this.pinkVinesPlant, this.pinkVines);
            this.partPinkLeaves = this.createVinesLeavesBlock("part_pink_", this.pinkVinesPlant, this.pinkVines);
            this.purpleLeaves = this.createVinesLeavesBlock("purple_", this.purpleVinesPlant, this.purpleVines);
            this.partPurpleLeaves = this.createVinesLeavesBlock("part_purple_", this.purpleVinesPlant, this.purpleVines);
            this.whiteSapling = this.createSapling("white_", new WhiteWisteriaSaplingGenerator());
            this.blueSapling = this.createSapling("blue_", new BlueWisteriaSaplingGenerator());
            this.pinkSapling = this.createSapling("pink_", new PinkWisteriaSaplingGenerator());
            this.purpleSapling = this.createSapling("purple_", new PurpleWisteriaSaplingGenerator());
            this.pottedWhiteSapling = this.createPottedSapling("white_", this.whiteSapling);
            this.pottedBlueSapling = this.createPottedSapling("blue_", this.blueSapling);
            this.pottedPinkSapling = this.createPottedSapling("pink_", this.pinkSapling);
            this.pottedPurpleSapling = this.createPottedSapling("purple_", this.purpleSapling);
        }
        if (this.woodPreset == WoodPreset.MAPLE) {
            this.redLeaves = this.createParticleLeaves("red_", NSParticleTypes.RED_MAPLE_LEAVES_PARTICLE, 100);
            this.orangeLeaves = this.createParticleLeaves("orange_", NSParticleTypes.ORANGE_MAPLE_LEAVES_PARTICLE, 100);
            this.yellowLeaves = this.createParticleLeaves("yellow_", NSParticleTypes.YELLOW_MAPLE_LEAVES_PARTICLE, 100);
            this.redSapling = this.createSapling("red_", new RedMapleSaplingGenerator());
            this.orangeSapling = this.createSapling("orange_", new OrangeMapleSaplingGenerator());
            this.yellowSapling = this.createSapling("yellow_", new YellowMapleSaplingGenerator());
            this.pottedRedSapling = this.createPottedSapling("red_", this.redSapling);
            this.pottedOrangeSapling = this.createPottedSapling("orange_", this.orangeSapling);
            this.pottedYellowSapling = this.createPottedSapling("yellow_", this.yellowSapling);
        }
        if (this.woodPreset == WoodPreset.ASPEN) {
            this.yellowLeaves = this.createLeaves("yellow_");
        }
        if (this.hasMosaic()) {
            this.mosaic = this.createMosaic();
            this.mosaicStairs = this.createMosaicStairs();
            this.mosaicSlab = this.createMosaicSlab();
        }
        this.planks = this.createPlanks();
        this.stairs = this.createStairs();
        this.slab = this.createSlab();
        this.fence = this.createFence();
        this.fenceGate = this.createFenceGate();
        this.pressurePlate = this.createPressurePlate();
        this.button = this.createButton();
        this.door = this.createDoor();
        this.trapDoor = this.createTrapDoor();
        this.sign = this.createSign();
        this.wallSign = this.createWallSign();
        this.hangingSign = this.createHangingSign();
        this.hangingWallSign = this.createWallHangingSign();
        this.signItem = this.createSignItem();
        this.hangingSignItem = this.createHangingSignItem();
        this.boatItem = this.createItem(this.getName() + "_boat", (com.google.common.base.Supplier<Item>)((com.google.common.base.Supplier)() -> new NSBoatItem(false, (NSBoatEntity.Type)((Object)((Object)this.boatType.get())), new Item.Properties().m_41487_(1))));
        this.chestBoatItem = this.createItem(this.getName() + "_chest_boat", (com.google.common.base.Supplier<Item>)((com.google.common.base.Supplier)() -> new NSBoatItem(true, (NSBoatEntity.Type)((Object)((Object)this.boatType.get())), new Item.Properties().m_41487_(1))));
    }

    public WoodSet(String name, MapColor sideColor, MapColor topColor, com.google.common.base.Supplier<NSBoatEntity.Type> boatType, WoodPreset woodPreset, boolean hasMosaic, AbstractTreeGrower saplingGenerator) {
        this.woodPreset = woodPreset;
        this.name = name;
        this.sideColor = sideColor;
        this.topColor = topColor;
        this.boatType = boatType;
        this.saplingGenerator = saplingGenerator;
        this.hasMosaic = hasMosaic;
        this.registerWood();
    }

    public String getName() {
        return this.name;
    }

    public com.google.common.base.Supplier<BlockSetType> getBlockSetType() {
        return this.blockSetType;
    }

    public WoodPreset getWoodPreset() {
        return this.woodPreset;
    }

    public MapColor getTopColor() {
        return this.topColor;
    }

    public com.google.common.base.Supplier<WoodType> getWoodType() {
        return this.woodType;
    }

    public RegistryObject<Block> getButton() {
        return this.button;
    }

    public RegistryObject<Block> getFence() {
        return this.fence;
    }

    public RegistryObject<Block> getPlanks() {
        return this.planks;
    }

    public RegistryObject<Block> getSlab() {
        return this.slab;
    }

    public RegistryObject<Block> getFenceGate() {
        return this.fenceGate;
    }

    public RegistryObject<Block> getStairs() {
        return this.stairs;
    }

    public RegistryObject<Block> getDoor() {
        return this.door;
    }

    public RegistryObject<Block> getHangingSign() {
        return this.hangingSign;
    }

    public RegistryObject<Block> getHangingWallSign() {
        return this.hangingWallSign;
    }

    public RegistryObject<Block> getPressurePlate() {
        return this.pressurePlate;
    }

    public RegistryObject<Block> getSign() {
        return this.sign;
    }

    public RegistryObject<Block> getTrapDoor() {
        return this.trapDoor;
    }

    public RegistryObject<Block> getWallSign() {
        return this.wallSign;
    }

    public RegistryObject<Item> getHangingSignItem() {
        return this.hangingSignItem;
    }

    public RegistryObject<Item> getSignItem() {
        return this.signItem;
    }

    public RegistryObject<Item> getBoatItem() {
        return this.boatItem;
    }

    public RegistryObject<Item> getChestBoatItem() {
        return this.chestBoatItem;
    }

    public RegistryObject<Block> getLog() {
        return this.log;
    }

    public RegistryObject<Block> getStrippedLog() {
        return this.strippedLog;
    }

    public RegistryObject<Block> getBundle() {
        return this.bundle;
    }

    public RegistryObject<Block> getStrippedBundle() {
        return this.strippedBundle;
    }

    public RegistryObject<Block> getWood() {
        return this.wood;
    }

    public RegistryObject<Block> getStrippedWood() {
        return this.strippedWood;
    }

    public RegistryObject<Block> getMosaic() {
        return this.mosaic;
    }

    public RegistryObject<Block> getMosaicStairs() {
        return this.mosaicStairs;
    }

    public RegistryObject<Block> getMosaicSlab() {
        return this.mosaicSlab;
    }

    public RegistryObject<Block> getLeaves() {
        return this.leaves;
    }

    public RegistryObject<Block> getFrostyLeaves() {
        return this.frostyLeaves;
    }

    public RegistryObject<Block> getSapling() {
        return this.sapling;
    }

    public RegistryObject<Block> getPottedSapling() {
        return this.pottedSapling;
    }

    public RegistryObject<Block> getVines() {
        return this.vines;
    }

    public RegistryObject<Block> getVinesPlant() {
        return this.vinesPlant;
    }

    public RegistryObject<Block> getRedLeaves() {
        return this.redLeaves;
    }

    public RegistryObject<Block> getOrangeLeaves() {
        return this.orangeLeaves;
    }

    public RegistryObject<Block> getYellowLeaves() {
        return this.yellowLeaves;
    }

    public RegistryObject<Block> getBlueLeaves() {
        return this.blueLeaves;
    }

    public RegistryObject<Block> getPurpleLeaves() {
        return this.purpleLeaves;
    }

    public RegistryObject<Block> getPinkLeaves() {
        return this.pinkLeaves;
    }

    public RegistryObject<Block> getWhiteLeaves() {
        return this.whiteLeaves;
    }

    public RegistryObject<Block> getPottedRedSapling() {
        return this.pottedRedSapling;
    }

    public RegistryObject<Block> getPottedOrangeSapling() {
        return this.pottedOrangeSapling;
    }

    public RegistryObject<Block> getPottedYellowSapling() {
        return this.pottedYellowSapling;
    }

    public RegistryObject<Block> getPottedBlueSapling() {
        return this.pottedBlueSapling;
    }

    public RegistryObject<Block> getPottedPurpleSapling() {
        return this.pottedPurpleSapling;
    }

    public RegistryObject<Block> getPottedPinkSapling() {
        return this.pottedPinkSapling;
    }

    public RegistryObject<Block> getPottedWhiteSapling() {
        return this.pottedWhiteSapling;
    }

    public RegistryObject<Block> getRedSapling() {
        return this.redSapling;
    }

    public RegistryObject<Block> getOrangeSapling() {
        return this.orangeSapling;
    }

    public RegistryObject<Block> getYellowSapling() {
        return this.yellowSapling;
    }

    public RegistryObject<Block> getBlueSapling() {
        return this.blueSapling;
    }

    public RegistryObject<Block> getPurpleSapling() {
        return this.purpleSapling;
    }

    public RegistryObject<Block> getPinkSapling() {
        return this.pinkSapling;
    }

    public RegistryObject<Block> getWhiteSapling() {
        return this.whiteSapling;
    }

    public RegistryObject<Block> getBlueVines() {
        return this.blueVines;
    }

    public RegistryObject<Block> getPurpleVines() {
        return this.purpleVines;
    }

    public RegistryObject<Block> getPinkVines() {
        return this.pinkVines;
    }

    public RegistryObject<Block> getWhiteVines() {
        return this.whiteVines;
    }

    public RegistryObject<Block> getBlueVinesPlant() {
        return this.blueVinesPlant;
    }

    public RegistryObject<Block> getPurpleVinesPlant() {
        return this.purpleVinesPlant;
    }

    public RegistryObject<Block> getPinkVinesPlant() {
        return this.pinkVinesPlant;
    }

    public RegistryObject<Block> getWhiteVinesPlant() {
        return this.whiteVinesPlant;
    }

    public RegistryObject<Block> getPartBlueLeaves() {
        return this.partBlueLeaves;
    }

    public RegistryObject<Block> getPartPurpleLeaves() {
        return this.partPurpleLeaves;
    }

    public RegistryObject<Block> getPartPinkLeaves() {
        return this.partPinkLeaves;
    }

    public RegistryObject<Block> getPartWhiteLeaves() {
        return this.partWhiteLeaves;
    }

    private String getWoodName() {
        String name = this.woodPreset == WoodPreset.NETHER ? this.getName() + "_hyphae" : this.getName() + "_wood";
        return name;
    }

    private String getLogName() {
        String name = this.woodPreset == WoodPreset.BAMBOO ? this.getName() + "_block" : (this.woodPreset == WoodPreset.NETHER ? this.getName() + "_stem" : this.getName() + "_log");
        return name;
    }

    private Block getBase() {
        Block base = this.woodPreset == WoodPreset.BAMBOO ? Blocks.f_244477_ : (this.woodPreset == WoodPreset.FANCY ? Blocks.f_271304_ : (this.woodPreset == WoodPreset.NETHER ? Blocks.f_50655_ : Blocks.f_50705_));
        return base;
    }

    private Block getSignBase() {
        Block base = this.woodPreset == WoodPreset.BAMBOO ? Blocks.f_244433_ : (this.woodPreset == WoodPreset.FANCY ? Blocks.f_271516_ : (this.woodPreset == WoodPreset.NETHER ? Blocks.f_50673_ : Blocks.f_50095_));
        return base;
    }

    private Block getHangingSignBase() {
        Block base = this.woodPreset == WoodPreset.BAMBOO ? Blocks.f_244091_ : (this.woodPreset == WoodPreset.FANCY ? Blocks.f_271116_ : (this.woodPreset == WoodPreset.NETHER ? Blocks.f_244147_ : Blocks.f_244319_));
        return base;
    }

    public com.google.common.base.Supplier<NSBoatEntity.Type> getBoatType() {
        return this.boatType;
    }

    public List<RegistryObject<Block>> getRegisteredBlocksList() {
        return ImmutableList.copyOf(this.registeredBlocksList);
    }

    public List<RegistryObject<Item>> getRegisteredItemsList() {
        return ImmutableList.copyOf(this.registeredItemsList);
    }

    private RegistryObject<Block> createBlockWithItem(String blockID, com.google.common.base.Supplier<Block> block) {
        RegistryObject<Block> listBlock = NSRegistryHelper.registerBlock(blockID, block);
        this.registeredBlocksList.add(listBlock);
        return listBlock;
    }

    private RegistryObject<Block> createBlockWithoutItem(String blockID, com.google.common.base.Supplier<Block> block) {
        RegistryObject<Block> listBlock = NSRegistryHelper.registerBlockWithoutItem(blockID, block);
        this.registeredBlocksList.add(listBlock);
        return listBlock;
    }

    public RegistryObject<Item> createItem(String blockID, com.google.common.base.Supplier<Item> item) {
        RegistryObject<Item> listItem = NSRegistryHelper.registerItem(blockID, item);
        this.registeredItemsList.add(listItem);
        return listItem;
    }

    private RegistryObject<Block> createLog() {
        return this.createBlockWithItem(this.getLogName(), (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> WoodSet.log(this.topColor, this.sideColor)));
    }

    private RegistryObject<Block> createStrippedLog() {
        return this.createBlockWithItem("stripped_" + this.getLogName(), (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> WoodSet.log(this.topColor, this.sideColor)));
    }

    private RegistryObject<Block> createBundle() {
        return this.createBlockWithItem(this.getName() + "_bundle", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> WoodSet.log(this.topColor, this.sideColor)));
    }

    private RegistryObject<Block> createStrippedBundle() {
        return this.createBlockWithItem("stripped_" + this.getName() + "_bundle", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> WoodSet.log(this.topColor, this.sideColor)));
    }

    private static RotatedPillarBlock log(MapColor p_285370_, MapColor p_285126_) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284495_(p_152624_ -> p_152624_.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? p_285370_ : p_285126_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_()){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        };
    }

    private RegistryObject<Block> createJoshuaLog() {
        return this.createBlockWithItem(this.getLogName(), (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new BranchingTrunkBlock(BlockBehaviour.Properties.m_284310_().m_278183_().m_284180_(MapColor.f_283818_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_))));
    }

    private RegistryObject<Block> createStrippedJoshuaLog() {
        return this.createBlockWithItem("stripped_" + this.getLogName(), (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new BranchingTrunkBlock(BlockBehaviour.Properties.m_284310_().m_278183_().m_284180_(MapColor.f_283818_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_))));
    }

    private RegistryObject<Block> createWood() {
        return this.createBlockWithItem(this.getWoodName(), (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> WoodSet.log(this.sideColor, this.sideColor)));
    }

    private RegistryObject<Block> createStrippedWood() {
        return this.createBlockWithItem("stripped_" + this.getWoodName(), (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> WoodSet.log(this.topColor, this.topColor)));
    }

    private RegistryObject<Block> createLeaves() {
        RegistryObject<Block> block = this.createBlockWithItem(this.getName() + "_leaves", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new LeavesBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(NSRegistryHelper::ocelotOrParrot).m_60960_(NSRegistryHelper::never).m_60971_(NSRegistryHelper::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(NSRegistryHelper::never)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        }));
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        return block;
    }

    private RegistryObject<Block> createLeaves(String prefix) {
        RegistryObject<Block> block = this.createBlockWithItem(prefix + this.getName() + "_leaves", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new LeavesBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(NSRegistryHelper::ocelotOrParrot).m_60960_(NSRegistryHelper::never).m_60971_(NSRegistryHelper::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(NSRegistryHelper::never)){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        }));
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        return block;
    }

    private RegistryObject<Block> createFrostableLeaves() {
        RegistryObject<Block> block = this.createBlockWithItem(this.getName() + "_leaves", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new ProjectileLeavesBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(NSRegistryHelper::ocelotOrParrot).m_60960_(NSRegistryHelper::never).m_60971_(NSRegistryHelper::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(NSRegistryHelper::never), this.frostyLeaves){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        }));
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        return block;
    }

    private RegistryObject<Block> createFrostableLeaves(String prefix) {
        RegistryObject<Block> block = this.createBlockWithItem(prefix + this.getName() + "_leaves", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new ProjectileLeavesBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(NSRegistryHelper::ocelotOrParrot).m_60960_(NSRegistryHelper::never).m_60971_(NSRegistryHelper::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(NSRegistryHelper::never), this.frostyLeaves){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        }));
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        return block;
    }

    private RegistryObject<Block> createParticleLeaves(RegistryObject<? extends ParticleOptions> particle, int chance) {
        RegistryObject<Block> block = this.createBlockWithItem(this.getName() + "_leaves", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new ParticleLeavesBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(NSRegistryHelper::ocelotOrParrot).m_60960_(NSRegistryHelper::never).m_60971_(NSRegistryHelper::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(NSRegistryHelper::never), particle, chance){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        }));
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        return block;
    }

    private RegistryObject<Block> createParticleLeaves(String prefix, RegistryObject<? extends ParticleOptions> particle, int chance) {
        RegistryObject<Block> block = this.createBlockWithItem(prefix + this.getName() + "_leaves", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new ParticleLeavesBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(NSRegistryHelper::ocelotOrParrot).m_60960_(NSRegistryHelper::never).m_60971_(NSRegistryHelper::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(NSRegistryHelper::never), particle, chance){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        }));
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        return block;
    }

    private RegistryObject<Block> createVinesLeavesBlock(RegistryObject<Block> vinesPlantBlock, RegistryObject<Block> vinesTipBlock) {
        RegistryObject<Block> block = this.createBlockWithItem(this.getName() + "_leaves", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new VinesLeavesBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(NSRegistryHelper::ocelotOrParrot).m_60960_(NSRegistryHelper::never).m_60971_(NSRegistryHelper::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(NSRegistryHelper::never), vinesPlantBlock, vinesTipBlock){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        }));
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        return block;
    }

    private RegistryObject<Block> createVinesLeavesBlock(String prefix, RegistryObject<Block> vinesPlantBlock, RegistryObject<Block> vinesTipBlock) {
        RegistryObject<Block> block = this.createBlockWithItem(prefix + this.getName() + "_leaves", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new VinesLeavesBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(NSRegistryHelper::ocelotOrParrot).m_60960_(NSRegistryHelper::never).m_60971_(NSRegistryHelper::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(NSRegistryHelper::never), vinesPlantBlock, vinesTipBlock){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 60;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 30;
            }
        }));
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        return block;
    }

    private RegistryObject<Block> createVines(com.google.common.base.Supplier<RegistryObject<Block>> vinesPlantBlock) {
        RegistryObject<Block> vinesBlock = this.createBlockWithItem(this.getName() + "_vines", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new DownwardVineBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.DESTROY).m_60977_().m_60910_().m_60955_().m_60966_().m_60918_(SoundType.f_56714_), (Supplier<RegistryObject<Block>>)vinesPlantBlock)));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_vines", vinesBlock);
        return vinesBlock;
    }

    private RegistryObject<Block> createVines(String prefix, com.google.common.base.Supplier<RegistryObject<Block>> vinesPlantBlock) {
        RegistryObject<Block> vinesBlock = this.createBlockWithItem(prefix + this.getName() + "_vines", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new DownwardVineBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.DESTROY).m_60977_().m_60910_().m_60955_().m_60966_().m_60918_(SoundType.f_56714_), (Supplier<RegistryObject<Block>>)vinesPlantBlock)));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_vines", vinesBlock);
        return vinesBlock;
    }

    private RegistryObject<Block> createVinesPlant(RegistryObject<Block> vines) {
        RegistryObject<Block> vinesPlant = NSRegistryHelper.registerBlockWithoutItem(this.getName() + "_vines_plant", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new DownwardsVinePlantBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.DESTROY).m_60910_().m_60955_().m_60966_().m_60918_(SoundType.f_56714_).m_60916_((Block)vines.get()), vines)));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_vines_plant", vinesPlant);
        return vinesPlant;
    }

    private RegistryObject<Block> createVinesPlant(String prefix, RegistryObject<Block> vines) {
        RegistryObject<Block> vinesPlant = NSRegistryHelper.registerBlockWithoutItem(prefix + this.getName() + "_vines_plant", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new DownwardsVinePlantBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.DESTROY).m_60910_().m_60955_().m_60966_().m_60918_(SoundType.f_56714_).m_60916_((Block)vines.get()), vines)));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_vines_plant", vinesPlant);
        return vinesPlant;
    }

    private RegistryObject<Block> createPlanks() {
        return this.createBlockWithItem(this.getName() + "_planks", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getBase()).m_60918_(((BlockSetType)this.getBlockSetType().get()).f_271136_()).m_284180_(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        }));
    }

    private RegistryObject<Block> createStairs() {
        return this.createBlockWithItem(this.getName() + "_stairs", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new StairBlock(() -> this.getBase().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getBase()).m_60918_(((BlockSetType)this.getBlockSetType().get()).f_271136_()).m_284180_(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        }));
    }

    private RegistryObject<Block> createSlab() {
        return this.createBlockWithItem(this.getName() + "_slab", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getBase()).m_60918_(((BlockSetType)this.getBlockSetType().get()).f_271136_()).m_284180_(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        }));
    }

    private RegistryObject<Block> createMosaic() {
        RegistryObject<Block> block = this.createBlockWithoutItem(this.getName() + "_mosaic", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getBase()).m_60918_(((BlockSetType)this.getBlockSetType().get()).f_271136_()).m_284180_(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        }));
        NSRegistryHelper.registerItem(this.getName() + "_mosaic", (com.google.common.base.Supplier<Item>)((com.google.common.base.Supplier)() -> new BlockItem((Block)block.get(), new Item.Properties()){

            public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return 300;
            }
        }));
        return block;
    }

    private RegistryObject<Block> createMosaicStairs() {
        RegistryObject<Block> block = this.createBlockWithoutItem(this.getName() + "_mosaic_stairs", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new StairBlock(() -> this.getBase().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getBase()).m_60918_(((BlockSetType)this.getBlockSetType().get()).f_271136_()).m_284180_(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        }));
        NSRegistryHelper.registerItem(this.getName() + "_mosaic_stairs", (com.google.common.base.Supplier<Item>)((com.google.common.base.Supplier)() -> new BlockItem((Block)block.get(), new Item.Properties()){

            public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return 300;
            }
        }));
        return block;
    }

    private RegistryObject<Block> createMosaicSlab() {
        RegistryObject<Block> block = this.createBlockWithoutItem(this.getName() + "_mosaic_slab", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getBase()).m_60918_(((BlockSetType)this.getBlockSetType().get()).f_271136_()).m_284180_(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        }));
        NSRegistryHelper.registerItem(this.getName() + "_mosaic_slab", (com.google.common.base.Supplier<Item>)((com.google.common.base.Supplier)() -> new BlockItem((Block)block.get(), new Item.Properties()){

            public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                return 150;
            }
        }));
        return block;
    }

    private RegistryObject<Block> createFence() {
        return this.createBlockWithItem(this.getName() + "_fence", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getBase()).m_60918_(((BlockSetType)this.getBlockSetType().get()).f_271136_()).m_284180_(this.getTopColor())){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        }));
    }

    private RegistryObject<Block> createFenceGate() {
        return this.createBlockWithItem(this.getName() + "_fence_gate", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new FenceGateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(this.getBase().m_284356_()).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_278183_(), (WoodType)this.getWoodType().get()){

            public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return true;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }
        }));
    }

    private RegistryObject<Block> createPressurePlate() {
        return this.createBlockWithItem(this.getName() + "_pressure_plate", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_284310_().m_284180_(this.getBase().m_284356_()).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(0.5f).m_278183_().m_278166_(PushReaction.DESTROY), (BlockSetType)this.getBlockSetType().get())));
    }

    private RegistryObject<Block> createButton() {
        return this.createBlockWithItem(this.getName() + "_button", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new ButtonBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY), (BlockSetType)this.getBlockSetType().get(), 30, true)));
    }

    private RegistryObject<Block> createDoor() {
        RegistryObject<Block> block = this.createBlockWithItem(this.getName() + "_door", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getBase()).m_60918_(((BlockSetType)this.getBlockSetType().get()).f_271136_()).m_60955_().m_284180_(this.getTopColor()), (BlockSetType)this.getBlockSetType().get())));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_door", block);
        return block;
    }

    private RegistryObject<Block> createTrapDoor() {
        RegistryObject<Block> block = this.createBlockWithItem(this.getName() + "_trapdoor", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getBase()).m_60918_(((BlockSetType)this.getBlockSetType().get()).f_271136_()).m_60955_().m_284180_(this.getTopColor()), (BlockSetType)this.getBlockSetType().get())));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_trapdoor", block);
        return block;
    }

    private RegistryObject<Block> createSign() {
        return NSRegistryHelper.registerBlockWithoutItem(this.getName() + "_sign", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new NSStandingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getSignBase()).m_284180_(this.getTopColor()), (WoodType)this.getWoodType().get())));
    }

    private RegistryObject<Block> createWallSign() {
        return NSRegistryHelper.registerBlockWithoutItem(this.getName() + "_wall_sign", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new NSWallSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getSignBase()).m_284180_(this.getTopColor()).m_60916_((Block)this.sign.get()), (WoodType)this.getWoodType().get())));
    }

    private RegistryObject<Block> createHangingSign() {
        return NSRegistryHelper.registerBlockWithoutItem(this.getName() + "_hanging_sign", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new NSHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getHangingSignBase()).m_284180_(this.getTopColor()), (WoodType)this.getWoodType().get())));
    }

    private RegistryObject<Block> createWallHangingSign() {
        return NSRegistryHelper.registerBlockWithoutItem(this.getName() + "_wall_hanging_sign", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new NSWallHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getHangingSignBase()).m_284180_(this.getTopColor()).m_60916_((Block)this.hangingSign.get()), (WoodType)this.getWoodType().get())));
    }

    public RegistryObject<Block> createSapling(AbstractTreeGrower saplingGenerator) {
        RegistryObject<Block> block = this.createBlockWithItem(this.getName() + "_sapling", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new SaplingBlock(saplingGenerator, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50747_))));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_sapling", block);
        return block;
    }

    public RegistryObject<Block> createSandySapling(AbstractTreeGrower saplingGenerator) {
        RegistryObject<Block> block = this.createBlockWithItem(this.getName() + "_sapling", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new SandySaplingBlock(saplingGenerator, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50747_))));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_sapling", block);
        return block;
    }

    public RegistryObject<Block> createPottedSapling(RegistryObject<Block> sapling) {
        return NSRegistryHelper.registerTransparentBlockWithoutItem("potted_" + this.getName() + "_sapling", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new FlowerPotBlock(() -> ((FlowerPotBlock)Blocks.f_50276_).getEmptyPot(), (Supplier)sapling, BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY))));
    }

    public RegistryObject<Block> createSapling(String prefix, AbstractTreeGrower saplingGenerator) {
        RegistryObject<Block> block = this.createBlockWithItem(prefix + this.getName() + "_sapling", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new SaplingBlock(saplingGenerator, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50747_))));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_sapling", block);
        return block;
    }

    public RegistryObject<Block> createSandySapling(String prefix, AbstractTreeGrower saplingGenerator) {
        RegistryObject<Block> block = this.createBlockWithItem(prefix + this.getName() + "_sapling", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new SandySaplingBlock(saplingGenerator, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50747_))));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_sapling", block);
        return block;
    }

    public RegistryObject<Block> createPottedSapling(String prefix, RegistryObject<Block> sapling) {
        return NSRegistryHelper.registerTransparentBlockWithoutItem("potted_" + prefix + this.getName() + "_sapling", (com.google.common.base.Supplier<Block>)((com.google.common.base.Supplier)() -> new FlowerPotBlock(() -> ((FlowerPotBlock)Blocks.f_50276_).getEmptyPot(), (Supplier)sapling, BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY))));
    }

    private RegistryObject<Item> createSignItem() {
        return this.createItem(this.getName() + "_sign", (com.google.common.base.Supplier<Item>)((com.google.common.base.Supplier)() -> new SignItem(new Item.Properties().m_41487_(16), (Block)this.sign.get(), (Block)this.wallSign.get())));
    }

    private RegistryObject<Item> createHangingSignItem() {
        return this.createItem(this.getName() + "_hanging_sign", (com.google.common.base.Supplier<Item>)((com.google.common.base.Supplier)() -> new HangingSignItem((Block)this.hangingSign.get(), (Block)this.hangingWallSign.get(), new Item.Properties().m_41487_(16))));
    }

    private com.google.common.base.Supplier<BlockSetType> createBlockSetType() {
        if (this.woodPreset == WoodPreset.BAMBOO) {
            return Suppliers.memoize(() -> BlockSetType.m_272115_((BlockSetType)new BlockSetType("natures_spirit:" + this.getName(), true, SoundType.f_243772_, SoundEvents.f_244543_, SoundEvents.f_243707_, SoundEvents.f_243699_, SoundEvents.f_243903_, SoundEvents.f_244533_, SoundEvents.f_244181_, SoundEvents.f_244603_, SoundEvents.f_244067_)));
        }
        if (this.woodPreset == WoodPreset.FANCY) {
            return Suppliers.memoize(() -> BlockSetType.m_272115_((BlockSetType)new BlockSetType("natures_spirit:" + this.getName(), true, SoundType.f_271497_, SoundEvents.f_271488_, SoundEvents.f_271095_, SoundEvents.f_271262_, SoundEvents.f_271395_, SoundEvents.f_271444_, SoundEvents.f_271406_, SoundEvents.f_271322_, SoundEvents.f_271171_)));
        }
        if (this.woodPreset == WoodPreset.NETHER) {
            return Suppliers.memoize(() -> BlockSetType.m_272115_((BlockSetType)new BlockSetType("natures_spirit:" + this.getName(), true, SoundType.f_244244_, SoundEvents.f_243719_, SoundEvents.f_244275_, SoundEvents.f_244033_, SoundEvents.f_244318_, SoundEvents.f_243893_, SoundEvents.f_244210_, SoundEvents.f_244344_, SoundEvents.f_244414_)));
        }
        return Suppliers.memoize(() -> BlockSetType.m_272115_((BlockSetType)new BlockSetType("natures_spirit:" + this.getName())));
    }

    public boolean isSandy() {
        return this.woodPreset == WoodPreset.JOSHUA || this.woodPreset == WoodPreset.SANDY;
    }

    public boolean hasDefaultLeaves() {
        return this.woodPreset == WoodPreset.DEFAULT || this.woodPreset == WoodPreset.WISTERIA || this.woodPreset == WoodPreset.FANCY || this.woodPreset == WoodPreset.JOSHUA || this.woodPreset == WoodPreset.NO_SAPLING || this.woodPreset == WoodPreset.SANDY || this.woodPreset == WoodPreset.ASPEN;
    }

    public boolean hasDefaultSapling() {
        return this.woodPreset != WoodPreset.NO_SAPLING && this.woodPreset != WoodPreset.WISTERIA;
    }

    public boolean hasBark() {
        return this.woodPreset != WoodPreset.JOSHUA && this.woodPreset != WoodPreset.BAMBOO;
    }

    public boolean hasMosaic() {
        return this.hasMosaic;
    }

    public static enum WoodPreset {
        DEFAULT,
        MAPLE,
        ASPEN,
        FROSTABLE,
        JOSHUA,
        SANDY,
        NO_SAPLING,
        WISTERIA,
        WILLOW,
        FANCY,
        NETHER,
        BAMBOO;

    }
}

