/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.registration.sets;

import com.google.common.base.Supplier;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.RegistryObject;

public class StoneSet {
    private RegistryObject<Block> cobbled;
    private RegistryObject<Block> cobbledStairs;
    private RegistryObject<Block> cobbledSlab;
    private RegistryObject<Block> cobbledWall;
    private RegistryObject<Block> mossyCobbled;
    private RegistryObject<Block> mossyCobbledStairs;
    private RegistryObject<Block> mossyCobbledSlab;
    private RegistryObject<Block> mossyCobbledWall;
    private RegistryObject<Block> base;
    private RegistryObject<Block> baseStairs;
    private RegistryObject<Block> baseSlab;
    private RegistryObject<Block> polished;
    private RegistryObject<Block> polishedStairs;
    private RegistryObject<Block> polishedSlab;
    private RegistryObject<Block> polishedWall;
    private RegistryObject<Block> tiles;
    private RegistryObject<Block> tilesStairs;
    private RegistryObject<Block> tilesSlab;
    private RegistryObject<Block> tilesWall;
    private RegistryObject<Block> bricks;
    private RegistryObject<Block> bricksStairs;
    private RegistryObject<Block> bricksSlab;
    private RegistryObject<Block> bricksWall;
    private RegistryObject<Block> chiseled;
    private RegistryObject<Block> crackedBricks;
    private RegistryObject<Block> crackedTiles;
    private RegistryObject<Block> mossyBricks;
    private RegistryObject<Block> mossyBricksStairs;
    private RegistryObject<Block> mossyBricksSlab;
    private RegistryObject<Block> mossyBricksWall;
    private final String name;
    private final MapColor mapColor;
    private final boolean hasTiles;
    private final boolean hasCobbled;
    private final boolean hasCracked;
    private final boolean hasMossy;
    private boolean isRotatable;
    private final float hardness;

    private void registerStone() {
        this.base = this.isRotatable ? this.createRotatable(this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.f_50334_)) : this.createBasic(this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.f_50334_));
        this.baseStairs = this.createStairs(this.getName(), this.base);
        this.baseSlab = this.createSlab(this.getName(), this.base);
        this.chiseled = this.createBasic("chiseled_" + this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.f_50225_));
        if (this.hasCobbled()) {
            this.cobbled = this.createBasic("cobbled_" + this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.f_50652_));
            this.cobbledStairs = this.createStairs("cobbled_" + this.getName(), this.cobbled);
            this.cobbledSlab = this.createSlab("cobbled_" + this.getName(), this.cobbled);
            this.cobbledWall = this.createWall("cobbled_" + this.getName(), this.cobbled);
        }
        if (this.hasMossy() && this.hasCobbled()) {
            this.mossyCobbled = this.createBasic("mossy_cobbled_" + this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.f_50079_));
            this.mossyCobbledStairs = this.createStairs("mossy_cobbled_" + this.getName(), this.mossyCobbled);
            this.mossyCobbledSlab = this.createSlab("mossy_cobbled_" + this.getName(), this.mossyCobbled);
            this.mossyCobbledWall = this.createWall("mossy_cobbled_" + this.getName(), this.mossyCobbled);
        }
        this.polished = this.createBasic("polished_" + this.getName(), (Supplier<Block>)((Supplier)() -> Blocks.f_50387_));
        this.polishedStairs = this.createStairs("polished_" + this.getName(), this.polished);
        this.polishedSlab = this.createSlab("polished_" + this.getName(), this.polished);
        this.polishedWall = this.createWall("polished_" + this.getName(), this.polished);
        this.bricks = this.createBasic(this.getName() + "_bricks", (Supplier<Block>)((Supplier)() -> Blocks.f_50222_));
        this.bricksStairs = this.createStairs(this.getName() + "_brick", this.bricks);
        this.bricksSlab = this.createSlab(this.getName() + "_brick", this.bricks);
        this.bricksWall = this.createWall(this.getName() + "_brick", this.bricks);
        if (this.hasMossy()) {
            this.mossyBricks = this.createBasic("mossy_" + this.getName() + "_bricks", (Supplier<Block>)((Supplier)() -> Blocks.f_50223_));
            this.mossyBricksStairs = this.createStairs("mossy_" + this.getName() + "_brick", this.bricks);
            this.mossyBricksSlab = this.createSlab("mossy_" + this.getName() + "_brick", this.bricks);
            this.mossyBricksWall = this.createWall("mossy_" + this.getName() + "_brick", this.bricks);
        }
        if (this.hasCracked()) {
            this.crackedBricks = this.createBasic("cracked_" + this.getName() + "_bricks", (Supplier<Block>)((Supplier)() -> Blocks.f_50224_));
        }
        if (this.hasTiles()) {
            this.tiles = this.createBasic(this.getName() + "_tiles", (Supplier<Block>)((Supplier)() -> Blocks.f_50652_));
            this.tilesStairs = this.createStairs(this.getName() + "_tile", this.polished);
            this.tilesSlab = this.createSlab(this.getName() + "_tile", this.polished);
            this.tilesWall = this.createWall(this.getName() + "_tile", this.polished);
            if (this.hasCracked()) {
                this.crackedTiles = this.createBasic("cracked_" + this.getName() + "_tiles", (Supplier<Block>)((Supplier)() -> Blocks.f_50224_));
            }
        }
    }

    public StoneSet(String name, MapColor mapColor, float hardness, boolean hasCobbled, boolean hasCracked, boolean hasMossy, boolean hasTiles) {
        this.name = name;
        this.mapColor = mapColor;
        this.hardness = hardness;
        this.hasTiles = hasTiles;
        this.hasCobbled = hasCobbled;
        this.hasCracked = hasCracked;
        this.hasMossy = hasMossy;
        this.registerStone();
    }

    public StoneSet(String name, MapColor mapColor, float hardness, boolean hasCobbled, boolean hasCracked, boolean hasMossy, boolean hasTiles, boolean isRotatable) {
        this.name = name;
        this.mapColor = mapColor;
        this.hardness = hardness;
        this.hasTiles = hasTiles;
        this.hasCobbled = hasCobbled;
        this.hasCracked = hasCracked;
        this.hasMossy = hasMossy;
        this.isRotatable = isRotatable;
        this.registerStone();
    }

    private RegistryObject<Block> createBlockWithItem(String blockID, Supplier<Block> block) {
        return NSRegistryHelper.registerBlock(blockID, block);
    }

    public String getName() {
        return this.name;
    }

    private RegistryObject<Block> createBasic(String name, Supplier<Block> template) {
        return this.createBlockWithItem(name, (Supplier<Block>)((Supplier)() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)template.get())).m_155954_(this.hardness).m_284180_(this.getMapColor()))));
    }

    private RegistryObject<Block> createRotatable(String name, Supplier<Block> template) {
        return this.createBlockWithItem(name, (Supplier<Block>)((Supplier)() -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)template.get())).m_155954_(this.hardness).m_284180_(this.getMapColor()))));
    }

    private RegistryObject<Block> createStairs(String name, RegistryObject<Block> template) {
        return this.createBlockWithItem(name + "_stairs", (Supplier<Block>)((Supplier)() -> new StairBlock(() -> ((Block)template.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)template.get())))));
    }

    private RegistryObject<Block> createSlab(String name, RegistryObject<Block> template) {
        return this.createBlockWithItem(name + "_slab", (Supplier<Block>)((Supplier)() -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)template.get())))));
    }

    private RegistryObject<Block> createWall(String name, RegistryObject<Block> template) {
        return this.createBlockWithItem(name + "_wall", (Supplier<Block>)((Supplier)() -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)template.get())).m_280606_())));
    }

    public boolean hasTiles() {
        return this.hasTiles;
    }

    public boolean hasCracked() {
        return this.hasCracked;
    }

    public boolean hasCobbled() {
        return this.hasCobbled;
    }

    public boolean hasMossy() {
        return this.hasMossy;
    }

    public boolean isRotatable() {
        return this.isRotatable;
    }

    public RegistryObject<Block> getCobbled() {
        return this.cobbled;
    }

    public RegistryObject<Block> getCobbledStairs() {
        return this.cobbledStairs;
    }

    public RegistryObject<Block> getCobbledSlab() {
        return this.cobbledSlab;
    }

    public RegistryObject<Block> getCobbledWall() {
        return this.cobbledWall;
    }

    public RegistryObject<Block> getBase() {
        return this.base;
    }

    public RegistryObject<Block> getBaseStairs() {
        return this.baseStairs;
    }

    public RegistryObject<Block> getBaseSlab() {
        return this.baseSlab;
    }

    public RegistryObject<Block> getPolished() {
        return this.polished;
    }

    public RegistryObject<Block> getPolishedStairs() {
        return this.polishedStairs;
    }

    public RegistryObject<Block> getPolishedSlab() {
        return this.polishedSlab;
    }

    public RegistryObject<Block> getPolishedWall() {
        return this.polishedWall;
    }

    public RegistryObject<Block> getTiles() {
        return this.tiles;
    }

    public RegistryObject<Block> getTilesStairs() {
        return this.tilesStairs;
    }

    public RegistryObject<Block> getTilesSlab() {
        return this.tilesSlab;
    }

    public RegistryObject<Block> getTilesWall() {
        return this.tilesWall;
    }

    public RegistryObject<Block> getBricks() {
        return this.bricks;
    }

    public RegistryObject<Block> getBricksStairs() {
        return this.bricksStairs;
    }

    public RegistryObject<Block> getBricksSlab() {
        return this.bricksSlab;
    }

    public RegistryObject<Block> getBricksWall() {
        return this.bricksWall;
    }

    public RegistryObject<Block> getChiseled() {
        return this.chiseled;
    }

    public RegistryObject<Block> getCrackedBricks() {
        return this.crackedBricks;
    }

    public RegistryObject<Block> getCrackedTiles() {
        return this.crackedTiles;
    }

    public RegistryObject<Block> getMossyBricks() {
        return this.mossyBricks;
    }

    public RegistryObject<Block> getMossyBricksStairs() {
        return this.mossyBricksStairs;
    }

    public RegistryObject<Block> getMossyBricksSlab() {
        return this.mossyBricksSlab;
    }

    public RegistryObject<Block> getMossyBricksWall() {
        return this.mossyBricksWall;
    }

    public RegistryObject<Block> getMossyCobbled() {
        return this.mossyCobbled;
    }

    public RegistryObject<Block> getMossyCobbledStairs() {
        return this.mossyCobbledStairs;
    }

    public RegistryObject<Block> getMossyCobbledSlab() {
        return this.mossyCobbledSlab;
    }

    public RegistryObject<Block> getMossyCobbledWall() {
        return this.mossyCobbledWall;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }
}

