/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.registration.sets;

import com.google.common.base.Supplier;
import net.hibiscus.naturespirit.blocks.LargeFlowerBlock;
import net.hibiscus.naturespirit.blocks.MidFlowerBlock;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.RegistryObject;

public class FlowerSet {
    private final String name;
    private final Item dyeColor;
    private final MobEffect statusEffect;
    private final FlowerPreset preset;
    private RegistryObject<Block> flowerBlock;
    private RegistryObject<Block> pottedFlowerBlock;

    public FlowerSet(String name, Item dyeColor, MobEffect statusEffect, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = dyeColor;
        this.statusEffect = statusEffect;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, Item dyeColor, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = dyeColor;
        this.statusEffect = null;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, MobEffect statusEffect, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = null;
        this.statusEffect = statusEffect;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = null;
        this.statusEffect = null;
        this.preset = preset;
        this.registerFlower();
    }

    private void registerFlower() {
        if (this.isTall()) {
            this.flowerBlock = NSRegistryHelper.registerTallPlantBlock(this.name, (Supplier<Block>)((Supplier)() -> new TallFlowerBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_278183_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY))));
        } else if (this.preset == FlowerPreset.BIG_SMALL) {
            this.flowerBlock = NSRegistryHelper.registerTransparentBlock(this.name, (Supplier<Block>)((Supplier)() -> new LargeFlowerBlock(this.statusEffect, 7, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY))));
        } else if (this.preset == FlowerPreset.SMALL) {
            this.flowerBlock = NSRegistryHelper.registerTransparentBlock(this.name, (Supplier<Block>)((Supplier)() -> new FlowerBlock(this.statusEffect, 7, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY))));
        } else if (this.preset == FlowerPreset.MID_SMALL) {
            this.flowerBlock = NSRegistryHelper.registerTransparentBlock(this.name, (Supplier<Block>)((Supplier)() -> new MidFlowerBlock(this.statusEffect, 7, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY))));
        }
        if (this.hasFlowerPot()) {
            this.pottedFlowerBlock = NSRegistryHelper.registerTransparentBlockWithoutItem("potted_" + this.name, (Supplier<Block>)((Supplier)() -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, this.flowerBlock, BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY))));
        }
    }

    public int getDyeNumber() {
        switch (this.preset) {
            case TALL: 
            case BIG_SMALL: {
                return 2;
            }
            case BIG_TALL: {
                return 4;
            }
        }
        return 1;
    }

    public FlowerPreset getPreset() {
        return this.preset;
    }

    public boolean hasFlowerPot() {
        return this.getPreset() == FlowerPreset.SMALL || this.getPreset() == FlowerPreset.BIG_SMALL || this.getPreset() == FlowerPreset.MID_SMALL;
    }

    public boolean isTall() {
        return this.getPreset() == FlowerPreset.TALL || this.getPreset() == FlowerPreset.BIG_TALL;
    }

    public Item getDyeColor() {
        return this.dyeColor;
    }

    public RegistryObject<Block> getFlowerBlock() {
        return this.flowerBlock;
    }

    public RegistryObject<Block> getPottedFlowerBlock() {
        return this.pottedFlowerBlock;
    }

    public String getName() {
        return this.name;
    }

    public static enum FlowerPreset {
        SMALL,
        MID_SMALL,
        TALL,
        BIG_SMALL,
        BIG_TALL;

    }
}

