/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.client.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.hibiscus.naturespirit.entity.NSBoatEntity;
import net.hibiscus.naturespirit.entity.NSChestBoatEntity;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class NSBoatRenderer
extends BoatRenderer {
    private final Map<NSBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(NSBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("natures_spirit", NSBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, (NSBoatEntity.Type)((Object)type), pChestBoat))));

    public NSBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(NSBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, NSBoatEntity.Type pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? NSBoatRenderer.createChestBoatModelName(pType) : NSBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.m_174023_(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(NSBoatEntity.Type pType) {
        return NSBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(NSBoatEntity.Type pType) {
        return NSBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main");
    }

    private static ModelLayerLocation createLocation(String pPath, String pModel) {
        return new ModelLayerLocation(new ResourceLocation("natures_spirit", pPath), pModel);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof NSBoatEntity) {
            NSBoatEntity modBoat = (NSBoatEntity)boat;
            return this.boatResources.get((Object)modBoat.getNSVariant());
        }
        if (boat instanceof NSChestBoatEntity) {
            NSChestBoatEntity NSChestBoatEntity2 = (NSChestBoatEntity)boat;
            return this.boatResources.get((Object)NSChestBoatEntity2.getNSVariant());
        }
        return null;
    }
}

