/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.hibiscus.naturespirit.registration.NSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PolyporeBlock
extends MushroomBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> FACING_TO_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)6.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)10.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)16.0)));

    public PolyporeBlock(BlockBehaviour.Properties settings, ResourceKey<ConfiguredFeature<?, ?>> featureKey) {
        super(settings, featureKey);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60659_((BlockGetter)world, blockPos, direction, SupportType.CENTER) || blockState.m_204336_(NSTags.Blocks.SUCCULENT_HORIZONTAL_PLACEMENT_OVERRIDE);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return FACING_TO_SHAPE.get(state.m_61143_((Property)FACING));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = super.m_5573_(ctx);
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        for (Direction direction : ctx.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }
}

