/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import java.util.Optional;
import net.hibiscus.naturespirit.blocks.block_entities.PizzaBlockEntity;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSStatTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PizzaBlock
extends Block
implements EntityBlock {
    public static final int DEFAULT_COMPARATOR_OUTPUT;
    protected static final VoxelShape[] BITES_TO_SHAPE;
    public static final IntegerProperty BITES;

    public PizzaBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    protected static InteractionResult tryEat(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        Optional optionalPizzaBlockEntity;
        if (player.m_36391_(false) && (optionalPizzaBlockEntity = world.m_141902_(pos, (BlockEntityType)NSBlocks.PIZZA_BLOCK_ENTITY_TYPE.get())).isPresent()) {
            PizzaBlockEntity pizzaBlockEntity = (PizzaBlockEntity)((Object)optionalPizzaBlockEntity.get());
            player.m_36220_((ResourceLocation)NSStatTypes.EAT_PIZZA_SLICE.get());
            int foodAmount = 2;
            float saturationModifier = 0.2f;
            for (String string : pizzaBlockEntity.toppings) {
                ++foodAmount;
                saturationModifier += 0.1f;
            }
            player.m_36324_().m_38707_(foodAmount, saturationModifier);
            int i = pizzaBlockEntity.bites++;
            world.m_142346_((Entity)player, GameEvent.f_157806_, pos);
            world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            if (i < 3) {
                if (!world.m_5776_()) {
                    world.m_7654_().m_129783_().m_7260_(pos, state, state, 2);
                }
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)BITES) + 1)), 2);
            } else {
                world.m_7471_(pos, false);
                world.m_142346_((Entity)player, GameEvent.f_157794_, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static int getComparatorOutput(int bites) {
        return (7 - bites) * 2;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        Optional optionalPizzaBlockEntity = world.m_141902_(pos, (BlockEntityType)NSBlocks.PIZZA_BLOCK_ENTITY_TYPE.get());
        if (optionalPizzaBlockEntity.isPresent()) {
            PizzaBlockEntity pizzaBlockEntity = (PizzaBlockEntity)((Object)optionalPizzaBlockEntity.get());
            int BITE_STATE = pizzaBlockEntity.bites;
            Item item = BITE_STATE == 0 ? (Item)NSBlocks.WHOLE_PIZZA.get() : (BITE_STATE == 1 ? (Item)NSBlocks.THREE_QUARTERS_PIZZA.get() : (BITE_STATE == 2 ? (Item)NSBlocks.HALF_PIZZA.get() : (Item)NSBlocks.QUARTER_PIZZA.get()));
            ItemStack itemStack = new ItemStack((ItemLike)item);
            CompoundTag nbtCompound = itemStack.m_41698_("BlockEntityTag");
            assert (nbtCompound != null);
            pizzaBlockEntity.m_183515_(nbtCompound);
            pizzaBlockEntity.m_6596_();
            return itemStack;
        }
        return super.m_7397_(world, pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Optional optionalPizzaBlockEntity = world.m_141902_(pos, (BlockEntityType)NSBlocks.PIZZA_BLOCK_ENTITY_TYPE.get());
        if (optionalPizzaBlockEntity.isPresent()) {
            PizzaBlockEntity pizzaBlockEntity = (PizzaBlockEntity)((Object)optionalPizzaBlockEntity.get());
            int BITE_STATE = pizzaBlockEntity.bites;
            return BITES_TO_SHAPE[BITE_STATE];
        }
        return BITES_TO_SHAPE[0];
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Optional optionalPizzaBlockEntity = world.m_141902_(pos, (BlockEntityType)NSBlocks.PIZZA_BLOCK_ENTITY_TYPE.get());
        if (optionalPizzaBlockEntity.isPresent()) {
            PizzaBlockEntity pizzaBlockEntity = (PizzaBlockEntity)((Object)optionalPizzaBlockEntity.get());
            ItemStack itemStack = player.m_21120_(hand);
            Item item = itemStack.m_41720_();
            if (pizzaBlockEntity.canPlaceTopping(itemStack, pizzaBlockEntity)) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                if (!world.m_5776_()) {
                    world.m_7260_(pos, state, state, 2);
                }
                world.m_5594_(null, pos, SoundEvents.f_144190_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ++pizzaBlockEntity.topping_number;
                world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                return InteractionResult.SUCCESS;
            }
            if (world.f_46443_) {
                if (PizzaBlock.tryEat((LevelAccessor)world, pos, state, player).m_19077_()) {
                    return InteractionResult.SUCCESS;
                }
                if (itemStack.m_41619_()) {
                    return InteractionResult.CONSUME;
                }
            }
            return PizzaBlock.tryEat((LevelAccessor)world, pos, state, player);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES});
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos pos1 = pos.m_7495_();
        return world.m_8055_(pos1).m_60796_((BlockGetter)world, pos1);
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        Optional optionalPizzaBlockEntity = world.m_141902_(pos, (BlockEntityType)NSBlocks.PIZZA_BLOCK_ENTITY_TYPE.get());
        if (optionalPizzaBlockEntity.isPresent()) {
            PizzaBlockEntity pizzaBlockEntity = (PizzaBlockEntity)((Object)optionalPizzaBlockEntity.get());
            int BITE_STATE = pizzaBlockEntity.bites;
            return PizzaBlock.getComparatorOutput(BITE_STATE);
        }
        return PizzaBlock.getComparatorOutput(0);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PizzaBlockEntity(pos, state);
    }

    static {
        BITES = IntegerProperty.m_61631_((String)"pizza_bites", (int)0, (int)3);
        DEFAULT_COMPARATOR_OUTPUT = PizzaBlock.getComparatorOutput(0);
        BITES_TO_SHAPE = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)8.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)3.0, (double)15.0)), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)3.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)15.0)};
    }
}

