/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import java.util.Optional;
import net.hibiscus.naturespirit.blocks.LotusFlowerBlock;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LotusStemBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty AGE;
    public static final BooleanProperty WATERLOGGED;
    public static final VoxelShape SHAPE;
    public static final Direction GROWTH_DIRECTION;
    public final Block headBlock;

    public LotusStemBlock(BlockBehaviour.Properties properties, Block headBlock) {
        super(properties);
        this.headBlock = headBlock;
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_().m_121945_(GROWTH_DIRECTION));
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        boolean waterlogged = fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() == 8;
        return !blockState.m_60713_(this.m_7374_()) && !blockState.m_60713_(this.headBlock) ? (BlockState)this.getRandomGrowthState((LevelAccessor)ctx.m_43725_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)) : (BlockState)this.m_7374_().m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockPos = pos.m_121945_(GROWTH_DIRECTION.m_122424_());
        BlockState blockState = levelReader.m_8055_(blockPos);
        if (levelReader.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            return (blockState.m_60783_((BlockGetter)levelReader, pos, Direction.UP) || blockState.m_60713_(this.m_7374_())) && !blockState.m_60713_(Blocks.f_50450_);
        }
        return blockState.m_60713_(this.m_7374_()) || blockState.m_204336_(BlockTags.f_144274_) || blockState.m_60713_(Blocks.f_50129_) || blockState.m_60713_(Blocks.f_50093_);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        double growthChance = 0.1;
        if ((Integer)state.m_61143_((Property)AGE) < 3 && random.m_188500_() < growthChance && this.isFertilizable((LevelReader)world, pos, state, world.m_5776_())) {
            BlockPos blockPos = pos.m_121945_(GROWTH_DIRECTION);
            if (world.m_8055_(blockPos).m_60795_()) {
                world.m_46597_(blockPos, this.headBlock.m_49966_());
            } else if (world.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) {
                world.m_46597_(blockPos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(2)));
                if (world.m_8055_(blockPos.m_7494_()).m_60795_()) {
                    world.m_46597_(blockPos.m_7494_(), this.headBlock.m_49966_());
                }
            } else if (world.m_8055_(blockPos).m_60713_(this.headBlock)) {
                if (!world.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
                    world.m_46597_(blockPos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min((Integer)state.m_61143_((Property)AGE) + 1, 3))));
                    world.m_46597_(blockPos.m_7494_(), this.headBlock.m_49966_());
                } else {
                    world.m_46597_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_205070_(FluidTags.f_13131_)))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(3)));
                }
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == GROWTH_DIRECTION.m_122424_() && !state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, this.m_7374_(), 1);
        }
        if (direction == GROWTH_DIRECTION && neighborState.m_60795_()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
        }
        return state;
    }

    public BlockState getRandomGrowthState(LevelAccessor world) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(world.m_213780_().m_188503_(3)));
    }

    protected BlockState age(BlockState state, RandomSource random) {
        return (BlockState)state.m_61122_((Property)AGE);
    }

    public boolean isFertilizable(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        Optional<BlockPos> optional = this.getFlowerHeadPos((BlockGetter)world, pos, this.m_7374_());
        Optional<BlockPos> optional2 = this.getStemHeadPos((BlockGetter)world, pos, this.m_7374_());
        Optional<BlockPos> optional3 = this.getWaterPos((BlockGetter)world, pos, this.m_7374_());
        BlockPos blockPos = optional2.isPresent() ? optional2.get().m_7495_() : (optional3.isPresent() ? optional3.get().m_7495_() : optional.orElse(pos));
        boolean lotusPowered = false;
        if (optional.isPresent()) {
            BlockPos blockPos2 = optional.get();
            LotusFlowerBlock lotusFlowerBlock = (LotusFlowerBlock)world.m_8055_(blockPos2).m_60734_();
            lotusPowered = lotusFlowerBlock.isPowered(world, blockPos2);
        }
        return (world.m_8055_(blockPos.m_121945_(GROWTH_DIRECTION)).m_60795_() || world.m_6425_(blockPos.m_121945_(GROWTH_DIRECTION)).m_205070_(FluidTags.f_13131_)) && !lotusPowered;
    }

    public boolean canGrow(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void grow(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        Optional<BlockPos> optional = this.getFlowerHeadPos((BlockGetter)world, pos, this.m_7374_());
        Optional<BlockPos> optional2 = this.getStemHeadPos((BlockGetter)world, pos, this.m_7374_());
        Optional<BlockPos> optional3 = this.getWaterPos((BlockGetter)world, pos, this.m_7374_());
        BlockPos blockPos = optional2.isPresent() ? optional2.get().m_7495_() : (optional3.isPresent() ? optional3.get().m_7495_() : optional.orElse(pos));
        int i = Math.min((Integer)state.m_61143_((Property)AGE) + 1, 3);
        if (world.m_8055_(blockPos).m_60795_() || world.m_8055_(blockPos).m_60713_(this.headBlock) || world.m_8055_(blockPos).m_60713_(this.m_7374_()) || world.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) {
            BlockPos blockPos2;
            Player player;
            world.m_46597_(blockPos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(blockPos).m_205070_(FluidTags.f_13131_))));
            if (world.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50016_)) {
                world.m_46597_(blockPos.m_5484_(GROWTH_DIRECTION, 1), this.headBlock.m_49966_());
            }
            if (world.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_)) {
                world.m_46597_(blockPos.m_5484_(GROWTH_DIRECTION, 1), (BlockState)((BlockState)this.m_7374_().m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(i))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(blockPos.m_5484_(GROWTH_DIRECTION, 1)).m_205070_(FluidTags.f_13131_))));
            }
            if (optional.isPresent() && (player = world.m_45924_((double)(blockPos2 = optional.get()).m_123341_(), (double)blockPos2.m_123342_(), (double)blockPos2.m_123343_(), 1.25, false)) != null) {
                player.m_6478_(MoverType.SHULKER_BOX, new Vec3(0.0, 1.01, 0.0));
            }
        }
    }

    private Optional<BlockPos> getFlowerHeadPos(BlockGetter world, BlockPos pos, Block block) {
        return BlockUtil.m_177845_((BlockGetter)world, (BlockPos)pos, (Block)block, (Direction)GROWTH_DIRECTION, (Block)this.headBlock);
    }

    private Optional<BlockPos> getStemHeadPos(BlockGetter world, BlockPos pos, Block block) {
        return BlockUtil.m_177845_((BlockGetter)world, (BlockPos)pos, (Block)block, (Direction)GROWTH_DIRECTION, (Block)Blocks.f_50016_);
    }

    public static Optional<BlockPos> getStemHeadWaterPos(BlockGetter world, BlockPos pos, Block block) {
        return BlockUtil.m_177845_((BlockGetter)world, (BlockPos)pos, (Block)Blocks.f_49990_, (Direction)GROWTH_DIRECTION, (Block)block);
    }

    private Optional<BlockPos> getWaterPos(BlockGetter world, BlockPos pos, Block block) {
        return BlockUtil.m_177845_((BlockGetter)world, (BlockPos)pos, (Block)block, (Direction)GROWTH_DIRECTION, (Block)Blocks.f_49990_);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE}).m_61104_(new Property[]{WATERLOGGED});
    }

    static {
        SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        GROWTH_DIRECTION = Direction.UP;
        AGE = BlockStateProperties.f_61407_;
        WATERLOGGED = BlockStateProperties.f_61362_;
    }
}

