/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import net.hibiscus.naturespirit.blocks.LotusStemBlock;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LotusFlowerBlock
extends BushBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.5, (double)14.0);

    public LotusFlowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(state, world, pos, entity);
        if (!world.f_46443_) {
            BlockState blockstate;
            if (entity instanceof Boat) {
                world.m_46953_(new BlockPos((Vec3i)pos), true, entity);
            }
            if ((blockstate = world.m_8055_(pos.m_7495_())).m_60713_((Block)NSBlocks.LOTUS_STEM.get()) && LotusFlowerBlock.isEntityAbove(pos, entity) && !this.isPowered((LevelReader)world, pos)) {
                world.m_186460_(pos, (Block)this, 4);
            }
        }
    }

    private int getRedstonePower(LevelReader world, BlockPos pos) {
        BlockState blockState;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        do {
            mutable.m_122173_(Direction.DOWN);
            blockState = world.m_8055_((BlockPos)mutable);
            if (!world.m_276867_((BlockPos)mutable)) continue;
            return world.m_277086_((BlockPos)mutable);
        } while (blockState.m_60713_((Block)NSBlocks.LOTUS_STEM.get()));
        return 0;
    }

    public boolean isPowered(LevelReader world, BlockPos pos) {
        return this.getRedstonePower(world, pos) > 0;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return this.getRedstonePower((LevelReader)world, pos);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        BlockState blockstate = world.m_8055_(pos.m_7495_());
        if (blockstate.m_60713_((Block)NSBlocks.LOTUS_STEM.get()) && LotusFlowerBlock.isEntityAbove(pos, (Entity)world.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.25, false)) && !this.isPowered((LevelReader)world, pos)) {
            world.m_46961_(pos, false);
            world.m_46597_(pos.m_7495_(), this.m_49966_());
        }
    }

    private static boolean isEntityAbove(BlockPos pos, @Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.m_20096_() && entity.m_20182_().f_82480_ > (double)pos.m_123342_() && entity.m_6144_();
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NSBlocks.LOTUS_FLOWER_ITEM.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean m_6266_(BlockState floor, BlockGetter world, BlockPos pos) {
        FluidState fluidState = world.m_6425_(pos);
        FluidState fluidState2 = world.m_6425_(pos.m_7494_());
        return (fluidState.m_76152_() == Fluids.f_76193_ || floor.m_60659_(world, pos, Direction.UP, SupportType.CENTER)) && fluidState2.m_76152_() == Fluids.f_76191_ || floor.m_60713_((Block)NSBlocks.LOTUS_STEM.get());
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean bl) {
        return world.m_8055_(pos.m_7494_()).m_60795_() && !world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49990_) && !this.isPowered(world, pos);
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        Player player = world.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.25, false);
        if (player != null) {
            player.m_6478_(MoverType.SHULKER_BOX, new Vec3(0.0, 1.01, 0.0));
        }
        if (world.m_8055_(pos.m_7495_()).m_60713_((Block)NSBlocks.LOTUS_STEM.get())) {
            LotusStemBlock lotusStemBlock = (LotusStemBlock)world.m_8055_(pos.m_7495_()).m_60734_();
            lotusStemBlock.grow(world, random, pos.m_7495_(), world.m_8055_(pos.m_7495_()));
        } else {
            world.m_46597_(pos, (BlockState)((Block)NSBlocks.LOTUS_STEM.get()).m_49966_().m_61124_((Property)LotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            world.m_46597_(pos.m_7494_(), this.m_49966_());
        }
    }
}

