/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import java.util.function.Supplier;
import net.hibiscus.naturespirit.blocks.DesertTurnipBlock;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DesertTurnipStemBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    protected static final VoxelShape[] AGE_TO_SHAPE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final Block rootBlock;
    private final DesertTurnipBlock vegetableBlock;
    private final Supplier<Item> pickBlockItem;

    public DesertTurnipStemBlock(DesertTurnipBlock vegetableBlock, Block rootBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.rootBlock = rootBlock;
        this.vegetableBlock = vegetableBlock;
        this.pickBlockItem = NSBlocks.DESERT_TURNIP;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected static float getAvailableMoisture(Block block, BlockGetter world, BlockPos pos) {
        boolean bl2;
        float f = 1.0f;
        BlockPos blockPos = pos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float g = 0.0f;
                BlockState blockState = world.m_8055_(blockPos.m_7918_(i, 0, j));
                if (blockState.m_60713_(Blocks.f_50093_)) {
                    g = 1.0f;
                    if ((Integer)blockState.m_61143_((Property)FarmBlock.f_53243_) > 0) {
                        g = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    g /= 4.0f;
                }
                f += g;
            }
        }
        BlockPos blockPos2 = pos.m_122012_();
        BlockPos blockPos3 = pos.m_122019_();
        BlockPos blockPos4 = pos.m_122024_();
        BlockPos blockPos5 = pos.m_122029_();
        boolean bl = world.m_8055_(blockPos4).m_60713_(block) || world.m_8055_(blockPos5).m_60713_(block);
        boolean bl3 = bl2 = world.m_8055_(blockPos2).m_60713_(block) || world.m_8055_(blockPos3).m_60713_(block);
        if (bl && bl2) {
            f /= 2.0f;
        } else {
            boolean bl32;
            boolean bl4 = bl32 = world.m_8055_(blockPos4.m_122012_()).m_60713_(block) || world.m_8055_(blockPos5.m_122012_()).m_60713_(block) || world.m_8055_(blockPos5.m_122019_()).m_60713_(block) || world.m_8055_(blockPos4.m_122019_()).m_60713_(block);
            if (bl32) {
                f /= 2.0f;
            }
        }
        return f;
    }

    protected boolean m_6266_(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.m_60713_(Blocks.f_50093_) || floor.m_204336_(NSTags.Blocks.TURNIP_STEM_GROWS_ON);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return AGE_TO_SHAPE[(Integer)state.m_61143_((Property)AGE)];
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        float f;
        if (world.m_45524_(pos, 0) >= 9 && random.m_188503_((int)(25.0f / (f = DesertTurnipStemBlock.getAvailableMoisture((Block)this, (BlockGetter)world, pos))) + 1) == 0) {
            int i = (Integer)state.m_61143_((Property)AGE);
            if (i < 7) {
                state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
                world.m_7731_(pos, state, 2);
            } else {
                Direction direction = Direction.DOWN;
                BlockPos blockPos = pos.m_5484_(direction, 2);
                BlockPos blockPos2 = pos.m_5484_(direction, 3);
                BlockState blockState = world.m_8055_(blockPos);
                BlockState blockState2 = world.m_8055_(blockPos2);
                boolean bl = blockState.m_204336_(NSTags.Blocks.TURNIP_ROOT_REPLACEABLE);
                boolean bl2 = blockState2.m_204336_(NSTags.Blocks.TURNIP_ROOT_REPLACEABLE);
                if (bl) {
                    if (bl2 || blockState2.m_60713_((Block)this.vegetableBlock)) {
                        world.m_46597_(blockPos, this.rootBlock.m_49966_());
                    } else {
                        world.m_46597_(blockPos, this.vegetableBlock.m_49966_());
                    }
                }
                if (!blockState.m_60713_(this.rootBlock) && !blockState.m_60713_((Block)this.vegetableBlock) && blockState2.m_60713_((Block)this.vegetableBlock)) {
                    state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(7));
                    world.m_7731_(pos, state, 2);
                }
                if (blockState.m_60713_(this.rootBlock) && !blockState2.m_60713_((Block)this.vegetableBlock) && bl2) {
                    world.m_46597_(blockPos2, this.vegetableBlock.m_49966_());
                }
            }
        }
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.pickBlockItem.get());
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean bl) {
        return (Integer)state.m_61143_((Property)AGE) < 7;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(7, (Integer)state.m_61143_((Property)AGE) + Mth.m_216271_((RandomSource)world.f_46441_, (int)2, (int)5));
        BlockState blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i));
        world.m_7731_(pos, blockState, 2);
        if (i == 7) {
            blockState.m_222972_(world, pos, world.f_46441_);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

