/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.blocks;

import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSCriteria;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoconutBlock
extends FallingBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING;
    public static final BooleanProperty FILLED;
    public static final VoxelShape SHAPE;
    public static final VoxelShape NORTH_SHAPE;
    public static final VoxelShape SOUTH_SHAPE;
    public static final BooleanProperty WATERLOGGED;
    public static final VoxelShape WEST_SHAPE;
    public static final VoxelShape EAST_SHAPE;
    public static final VoxelShape CEILING_SHAPE;
    private static final float FALLING_BLOCK_ENTITY_DAMAGE_MULTIPLIER = 1.2f;
    private static final int FALLING_BLOCK_ENTITY_MAX_DAMAGE = 20;

    public CoconutBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(true)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_43719_();
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() == 8));
    }

    protected void m_6788_(FallingBlockEntity entity) {
        entity.m_149656_(1.2f, 20);
    }

    public static boolean m_53241_(BlockState state) {
        return state.m_60795_() || state.m_204336_(BlockTags.f_13076_) || state.m_278721_() || state.m_247087_();
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60783_((BlockGetter)world, pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()), (Direction)state.m_61143_((Property)FACING));
    }

    public void m_5581_(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        Entity entity = projectile.m_19749_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            NSCriteria.COCONUT_HIT_CRITERION.trigger(serverPlayerEntity, (Entity)projectile);
        }
        if (CoconutBlock.m_53241_(world.m_8055_(hit.m_82425_().m_7495_())) && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_46597_(hit.m_82425_(), (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.UP));
        } else {
            world.m_46961_(hit.m_82425_(), true);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        boolean bl = (Boolean)state.m_61143_((Property)FILLED);
        Item item = itemStack.m_41720_();
        if (itemStack.m_150930_(Items.f_42446_) && bl) {
            itemStack.m_41774_(1);
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11833_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (itemStack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42455_));
            } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42455_))) {
                player.m_36176_(new ItemStack((ItemLike)Items.f_42455_), false);
            }
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)));
            world.m_142346_((Entity)player, GameEvent.f_157816_, pos);
        }
        if (!world.m_5776_() && bl) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (CoconutBlock.m_53241_(world.m_8055_(pos.m_7495_())) && pos.m_123342_() >= world.m_141937_() && world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60795_()) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.UP);
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)world, (BlockPos)pos, (BlockState)state);
            this.m_6788_(fallingBlockEntity);
        }
        if (!CoconutBlock.m_53241_(world.m_8055_(pos.m_7495_())) && world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60795_()) {
            state.m_61124_((Property)FACING, (Comparable)Direction.UP);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> CEILING_SHAPE;
            case Direction.UP -> SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
        };
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FILLED, WATERLOGGED});
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean bl) {
        return state.m_61143_((Property)FACING) == Direction.UP;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        world.m_46597_(pos, ((Block)NSBlocks.COCONUT_SPROUT.get()).m_49966_());
    }

    static {
        WATERLOGGED = BlockStateProperties.f_61362_;
        FACING = BlockStateProperties.f_61372_;
        FILLED = BooleanProperty.m_61465_((String)"filled");
        SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
        EAST_SHAPE = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0);
        WEST_SHAPE = Block.m_49796_((double)6.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
        NORTH_SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)6.0, (double)13.0, (double)13.0, (double)16.0);
        SOUTH_SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)10.0);
        CEILING_SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    }
}

