/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.hibiscus.naturespirit.blocks.NSCauldronBehavior;
import net.hibiscus.naturespirit.config.NSConfig;
import net.hibiscus.naturespirit.registration.NSBiomes;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSCriteria;
import net.hibiscus.naturespirit.registration.NSEntityTypes;
import net.hibiscus.naturespirit.registration.NSItemGroups;
import net.hibiscus.naturespirit.registration.NSParticleTypes;
import net.hibiscus.naturespirit.registration.NSSounds;
import net.hibiscus.naturespirit.registration.NSStatTypes;
import net.hibiscus.naturespirit.registration.NSVillagers;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.hibiscus.naturespirit.registration.compat.NSArtsAndCraftsCompat;
import net.hibiscus.naturespirit.registration.sets.WoodSet;
import net.hibiscus.naturespirit.terrablender.TerraFeraxRegion;
import net.hibiscus.naturespirit.terrablender.TerraFlavaRegion;
import net.hibiscus.naturespirit.terrablender.TerraLaetaRegion;
import net.hibiscus.naturespirit.terrablender.TerraMaterRegion;
import net.hibiscus.naturespirit.terrablender.TerraSolarisRegion;
import net.hibiscus.naturespirit.world.NSSurfaceRules;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.PathPackResources;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

@Mod(value="natures_spirit")
public class NatureSpirit {
    public static final String MOD_ID = "natures_spirit";

    public NatureSpirit() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        NSBlocks.BLOCKS.register(modEventBus);
        NSBlocks.ITEMS.register(modEventBus);
        NSBlocks.BLOCK_ENTITIES.register(modEventBus);
        NSEntityTypes.ENTITIES.register(modEventBus);
        NSItemGroups.CREATIVE_MODE_TABS.register(modEventBus);
        NSParticleTypes.PARTICLES.register(modEventBus);
        NSStatTypes.CUSTOM_STATS.register(modEventBus);
        NSSounds.SOUND_EVENTS.register(modEventBus);
        NSWorldGen.FOLIAGE_PLACERS.register(modEventBus);
        NSWorldGen.TREE_DECORATORS.register(modEventBus);
        NSWorldGen.TRUNK_PLACERS.register(modEventBus);
        NSWorldGen.CARVERS.register(modEventBus);
        NSWorldGen.FEATURES.register(modEventBus);
        NSVillagers.VILLAGER_TYPES.register(modEventBus);
        modEventBus.addListener(this::creativeInventory);
        NSCriteria.registerCriteria();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::wandererTrades);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NSConfig.SPEC);
        modEventBus.addListener(this::addPackFinders);
        if (ModList.get().isLoaded("arts_and_crafts")) {
            NSArtsAndCraftsCompat.ANC_BLOCKS.register(modEventBus);
            NSArtsAndCraftsCompat.ANC_ITEMS.register(modEventBus);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Regions.register((Region)new TerraFeraxRegion(new ResourceLocation(MOD_ID, "terra_ferax"), NSConfig.terraFeraxWeight));
        Regions.register((Region)new TerraSolarisRegion(new ResourceLocation(MOD_ID, "terra_solaris"), NSConfig.terraSolarisWeight));
        Regions.register((Region)new TerraFlavaRegion(new ResourceLocation(MOD_ID, "terra_flava"), NSConfig.terraFlavaWeight));
        Regions.register((Region)new TerraMaterRegion(new ResourceLocation(MOD_ID, "terra_mater"), NSConfig.terraMaterWeight));
        Regions.register((Region)new TerraLaetaRegion(new ResourceLocation(MOD_ID, "terra_laeta"), NSConfig.terraLaetaWeight));
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)MOD_ID, (SurfaceRules.RuleSource)NSSurfaceRules.makeRules());
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.SCORCHED_GRASS.getId(), NSBlocks.POTTED_SCORCHED_GRASS);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.BEACH_GRASS.getId(), NSBlocks.POTTED_BEACH_GRASS);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.SEDGE_GRASS.getId(), NSBlocks.POTTED_SEDGE_GRASS);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.FLAXEN_FERN.getId(), NSBlocks.POTTED_FLAXEN_FERN);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.OAT_GRASS.getId(), NSBlocks.POTTED_OAT_GRASS);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.MELIC_GRASS.getId(), NSBlocks.POTTED_MELIC_GRASS);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.LUSH_FERN.getId(), NSBlocks.POTTED_LUSH_FERN);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.FRIGID_GRASS.getId(), NSBlocks.POTTED_FRIGID_GRASS);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.GREEN_BEARBERRIES.getId(), NSBlocks.POTTED_GREEN_BEARBERRIES);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.RED_BEARBERRIES.getId(), NSBlocks.POTTED_RED_BEARBERRIES);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.PURPLE_BEARBERRIES.getId(), NSBlocks.POTTED_PURPLE_BEARBERRIES);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.ORNATE_SUCCULENT.getId(), NSBlocks.POTTED_ORNATE_SUCCULENT);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.DROWSY_SUCCULENT.getId(), NSBlocks.POTTED_DROWSY_SUCCULENT);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.AUREATE_SUCCULENT.getId(), NSBlocks.POTTED_AUREATE_SUCCULENT);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.SAGE_SUCCULENT.getId(), NSBlocks.POTTED_SAGE_SUCCULENT);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.FOAMY_SUCCULENT.getId(), NSBlocks.POTTED_FOAMY_SUCCULENT);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.IMPERIAL_SUCCULENT.getId(), NSBlocks.POTTED_IMPERIAL_SUCCULENT);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.REGAL_SUCCULENT.getId(), NSBlocks.POTTED_REGAL_SUCCULENT);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.SHIITAKE_MUSHROOM.getId(), NSBlocks.POTTED_SHIITAKE_MUSHROOM);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.MARIGOLD.getFlowerBlock().getId(), NSBlocks.MARIGOLD.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.BLUEBELL.getFlowerBlock().getId(), NSBlocks.BLUEBELL.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.TIGER_LILY.getFlowerBlock().getId(), NSBlocks.TIGER_LILY.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.PURPLE_WILDFLOWER.getFlowerBlock().getId(), NSBlocks.PURPLE_WILDFLOWER.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.YELLOW_WILDFLOWER.getFlowerBlock().getId(), NSBlocks.YELLOW_WILDFLOWER.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.RED_HEATHER.getFlowerBlock().getId(), NSBlocks.RED_HEATHER.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.WHITE_HEATHER.getFlowerBlock().getId(), NSBlocks.WHITE_HEATHER.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.PURPLE_HEATHER.getFlowerBlock().getId(), NSBlocks.PURPLE_HEATHER.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.ANEMONE.getFlowerBlock().getId(), NSBlocks.ANEMONE.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.DWARF_BLOSSOMS.getFlowerBlock().getId(), NSBlocks.DWARF_BLOSSOMS.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.PROTEA.getFlowerBlock().getId(), NSBlocks.PROTEA.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.HIBISCUS.getFlowerBlock().getId(), NSBlocks.HIBISCUS.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.BLUE_IRIS.getFlowerBlock().getId(), NSBlocks.BLUE_IRIS.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.BLACK_IRIS.getFlowerBlock().getId(), NSBlocks.BLACK_IRIS.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.RUBY_BLOSSOMS.getFlowerBlock().getId(), NSBlocks.RUBY_BLOSSOMS.getPottedFlowerBlock());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.REDWOOD.getSapling().getId(), NSBlocks.REDWOOD.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.SUGI.getSapling().getId(), NSBlocks.SUGI.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.WISTERIA.getPurpleSapling().getId(), NSBlocks.WISTERIA.getPottedPurpleSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.WISTERIA.getWhiteSapling().getId(), NSBlocks.WISTERIA.getPottedWhiteSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.WISTERIA.getBlueSapling().getId(), NSBlocks.WISTERIA.getPottedBlueSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.WISTERIA.getPinkSapling().getId(), NSBlocks.WISTERIA.getPottedPinkSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.FIR.getSapling().getId(), NSBlocks.FIR.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.WILLOW.getSapling().getId(), NSBlocks.WILLOW.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.ASPEN.getSapling().getId(), NSBlocks.ASPEN.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.MAPLE.getRedSapling().getId(), NSBlocks.MAPLE.getPottedRedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.MAPLE.getOrangeSapling().getId(), NSBlocks.MAPLE.getPottedOrangeSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.MAPLE.getYellowSapling().getId(), NSBlocks.MAPLE.getPottedYellowSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.CYPRESS.getSapling().getId(), NSBlocks.CYPRESS.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.OLIVE.getSapling().getId(), NSBlocks.OLIVE.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.JOSHUA.getSapling().getId(), NSBlocks.JOSHUA.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.GHAF.getSapling().getId(), NSBlocks.GHAF.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.PALO_VERDE.getSapling().getId(), NSBlocks.PALO_VERDE.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.CEDAR.getSapling().getId(), NSBlocks.CEDAR.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.LARCH.getSapling().getId(), NSBlocks.LARCH.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.MAHOGANY.getSapling().getId(), NSBlocks.MAHOGANY.getPottedSapling());
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(NSBlocks.SAXAUL.getSapling().getId(), NSBlocks.SAXAUL.getPottedSapling());
            VillagerType.registerBiomeType(NSBiomes.WISTERIA_FOREST, (VillagerType)((VillagerType)NSVillagers.WISTERIA.get()));
            VillagerType.registerBiomeType(NSBiomes.CYPRESS_FIELDS, (VillagerType)((VillagerType)NSVillagers.CYPRESS.get()));
            VillagerType.registerBiomeType(NSBiomes.CARNATION_FIELDS, (VillagerType)((VillagerType)NSVillagers.CYPRESS.get()));
            VillagerType.registerBiomeType(NSBiomes.LAVENDER_FIELDS, (VillagerType)((VillagerType)NSVillagers.CYPRESS.get()));
            VillagerType.registerBiomeType(NSBiomes.STRATIFIED_DESERT, (VillagerType)((VillagerType)NSVillagers.ADOBE.get()));
            VillagerType.registerBiomeType(NSBiomes.LIVELY_DUNES, (VillagerType)((VillagerType)NSVillagers.ADOBE.get()));
            VillagerType.registerBiomeType(NSBiomes.BLOOMING_DUNES, (VillagerType)((VillagerType)NSVillagers.ADOBE.get()));
            VillagerType.registerBiomeType(NSBiomes.DRYLANDS, (VillagerType)VillagerType.f_35819_);
            VillagerType.registerBiomeType(NSBiomes.WOODED_DRYLANDS, (VillagerType)VillagerType.f_35819_);
            VillagerType.registerBiomeType(NSBiomes.TROPICAL_SHORES, (VillagerType)((VillagerType)NSVillagers.COCONUT.get()));
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.RED_MOSS_BLOCK.get()).m_5456_(), 0.65f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.RED_MOSS_CARPET.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.LOTUS_FLOWER_ITEM.get()), 0.65f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.LOTUS_STEM.get()).m_5456_(), 0.2f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.AZOLLA_ITEM.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.HELVOLA_FLOWER_ITEM.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.HELVOLA_PAD_ITEM.get()), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)NSBlocks.DESERT_TURNIP.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.DESERT_TURNIP_BLOCK.get()).m_5456_(), 0.65f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.DESERT_TURNIP_ROOT_BLOCK.get()).m_5456_(), 0.5f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.WHOLE_PIZZA.get()), 1.0f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.THREE_QUARTERS_PIZZA.get()), 0.85f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.HALF_PIZZA.get()), 0.5f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.QUARTER_PIZZA.get()), 0.35f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.AUREATE_SUCCULENT_ITEM.get()), 0.65f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.DROWSY_SUCCULENT_ITEM.get()), 0.65f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.FOAMY_SUCCULENT_ITEM.get()), 0.65f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.SAGE_SUCCULENT_ITEM.get()), 0.65f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.IMPERIAL_SUCCULENT_ITEM.get()), 0.65f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.ORNATE_SUCCULENT_ITEM.get()), 0.65f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)NSBlocks.REGAL_SUCCULENT_ITEM.get()), 0.65f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.COCONUT_THATCH.get()).m_5456_(), 0.65f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.COCONUT_THATCH_CARPET.get()).m_5456_(), 0.1f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.COCONUT_THATCH_STAIRS.get()).m_5456_(), 0.5f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.COCONUT_THATCH_SLAB.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.XERIC_THATCH.get()).m_5456_(), 0.65f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.XERIC_THATCH_CARPET.get()).m_5456_(), 0.1f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.XERIC_THATCH_STAIRS.get()).m_5456_(), 0.5f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.XERIC_THATCH_SLAB.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.EVERGREEN_THATCH.get()).m_5456_(), 0.65f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.EVERGREEN_THATCH_CARPET.get()).m_5456_(), 0.1f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.EVERGREEN_THATCH_STAIRS.get()).m_5456_(), 0.5f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.EVERGREEN_THATCH_SLAB.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.REDWOOD.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.SUGI.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getPurpleSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getWhiteSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getBlueSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getPinkSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.FIR.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WILLOW.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.ASPEN.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.MAPLE.getRedSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.MAPLE.getOrangeSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.MAPLE.getYellowSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.CYPRESS.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.OLIVE.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.JOSHUA.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.GHAF.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.PALO_VERDE.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.CEDAR.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.LARCH.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.MAHOGANY.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.SAXAUL.getSapling().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.REDWOOD.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.REDWOOD.getFrostyLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.SUGI.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getPurpleLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getWhiteLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getBlueLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getPinkLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getPartPurpleLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getPartWhiteLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getPartBlueLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getPartPinkLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.FIR.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.FIR.getFrostyLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WILLOW.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.ASPEN.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.ASPEN.getYellowLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.MAPLE.getRedLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.MAPLE.getOrangeLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.MAPLE.getYellowLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.CYPRESS.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.OLIVE.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.JOSHUA.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.GHAF.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.PALO_VERDE.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.CEDAR.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.COCONUT.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.LARCH.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.MAHOGANY.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.SAXAUL.getLeaves().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getPurpleVines().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getWhiteVines().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getBlueVines().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WISTERIA.getPinkVines().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WILLOW.getVines().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.LAVENDER.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.BLEEDING_HEART.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.BLUE_BULBS.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.CARNATION.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.GARDENIA.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.SNAPDRAGON.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.FOXGLOVE.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.BEGONIA.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.MARIGOLD.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.BLUEBELL.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.TIGER_LILY.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.PURPLE_WILDFLOWER.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.YELLOW_WILDFLOWER.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.RED_HEATHER.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.WHITE_HEATHER.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.PURPLE_HEATHER.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.ANEMONE.getFlowerBlock().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.DWARF_BLOSSOMS.getFlowerBlock().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.PROTEA.getFlowerBlock().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.HIBISCUS.getFlowerBlock().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.BLUE_IRIS.getFlowerBlock().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.BLACK_IRIS.getFlowerBlock().get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.RUBY_BLOSSOMS.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.SILVERBUSH.getFlowerBlock().get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.CATTAIL.get()).m_5456_(), 0.4f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.TALL_FRIGID_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.FRIGID_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.TALL_SCORCHED_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.SCORCHED_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.TALL_BEACH_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.BEACH_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.TALL_SEDGE_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.SEDGE_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.LARGE_FLAXEN_FERN.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.FLAXEN_FERN.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.TALL_OAT_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.OAT_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.LARGE_LUSH_FERN.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.LUSH_FERN.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.TALL_MELIC_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.MELIC_GRASS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.GREEN_BEARBERRIES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.RED_BEARBERRIES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.PURPLE_BEARBERRIES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.GREEN_BITTER_SPROUTS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.RED_BITTER_SPROUTS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.PURPLE_BITTER_SPROUTS.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Item)NSBlocks.OLIVES.get()).m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.OLIVE_BRANCH.get()).m_5456_(), 0.5f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.COCONUT_BLOCK.get()).m_5456_(), 0.2f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.COCONUT_SPROUT.get()).m_5456_(), 0.2f);
            ComposterBlock.f_51914_.put((Object)((Item)NSBlocks.COCONUT_SHELL.get()).m_5456_(), 0.1f);
            ComposterBlock.f_51914_.put((Object)((Item)NSBlocks.COCONUT_HALF.get()).m_5456_(), 0.1f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.SHIITAKE_MUSHROOM.get()).m_5456_(), 0.1f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.GRAY_POLYPORE.get()).m_5456_(), 0.1f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.ALLUAUDIA.get()).m_5456_(), 0.2f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.ALLUAUDIA_BUNDLE.get()).m_5456_(), 0.2f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.STRIPPED_ALLUAUDIA.get()).m_5456_(), 0.2f);
            ComposterBlock.f_51914_.put((Object)((Block)NSBlocks.STRIPPED_ALLUAUDIA_BUNDLE.get()).m_5456_(), 0.2f);
            HashMap<Block, Block> strippables = new HashMap<Block, Block>(AxeItem.f_150683_);
            strippables.put((Block)NSBlocks.REDWOOD.getLog().get(), (Block)NSBlocks.REDWOOD.getStrippedLog().get());
            strippables.put((Block)NSBlocks.SUGI.getLog().get(), (Block)NSBlocks.SUGI.getStrippedLog().get());
            strippables.put((Block)NSBlocks.WISTERIA.getLog().get(), (Block)NSBlocks.WISTERIA.getStrippedLog().get());
            strippables.put((Block)NSBlocks.FIR.getLog().get(), (Block)NSBlocks.FIR.getStrippedLog().get());
            strippables.put((Block)NSBlocks.WILLOW.getLog().get(), (Block)NSBlocks.WILLOW.getStrippedLog().get());
            strippables.put((Block)NSBlocks.ASPEN.getLog().get(), (Block)NSBlocks.ASPEN.getStrippedLog().get());
            strippables.put((Block)NSBlocks.MAPLE.getLog().get(), (Block)NSBlocks.MAPLE.getStrippedLog().get());
            strippables.put((Block)NSBlocks.CYPRESS.getLog().get(), (Block)NSBlocks.CYPRESS.getStrippedLog().get());
            strippables.put((Block)NSBlocks.OLIVE.getLog().get(), (Block)NSBlocks.OLIVE.getStrippedLog().get());
            strippables.put((Block)NSBlocks.GHAF.getLog().get(), (Block)NSBlocks.GHAF.getStrippedLog().get());
            strippables.put((Block)NSBlocks.PALO_VERDE.getLog().get(), (Block)NSBlocks.PALO_VERDE.getStrippedLog().get());
            strippables.put((Block)NSBlocks.CEDAR.getLog().get(), (Block)NSBlocks.CEDAR.getStrippedLog().get());
            strippables.put((Block)NSBlocks.COCONUT.getLog().get(), (Block)NSBlocks.COCONUT.getStrippedLog().get());
            strippables.put((Block)NSBlocks.LARCH.getLog().get(), (Block)NSBlocks.LARCH.getStrippedLog().get());
            strippables.put((Block)NSBlocks.MAHOGANY.getLog().get(), (Block)NSBlocks.MAHOGANY.getStrippedLog().get());
            strippables.put((Block)NSBlocks.SAXAUL.getLog().get(), (Block)NSBlocks.SAXAUL.getStrippedLog().get());
            strippables.put((Block)NSBlocks.REDWOOD.getWood().get(), (Block)NSBlocks.REDWOOD.getStrippedWood().get());
            strippables.put((Block)NSBlocks.SUGI.getWood().get(), (Block)NSBlocks.SUGI.getStrippedWood().get());
            strippables.put((Block)NSBlocks.WISTERIA.getWood().get(), (Block)NSBlocks.WISTERIA.getStrippedWood().get());
            strippables.put((Block)NSBlocks.FIR.getWood().get(), (Block)NSBlocks.FIR.getStrippedWood().get());
            strippables.put((Block)NSBlocks.WILLOW.getWood().get(), (Block)NSBlocks.WILLOW.getStrippedWood().get());
            strippables.put((Block)NSBlocks.ASPEN.getWood().get(), (Block)NSBlocks.ASPEN.getStrippedWood().get());
            strippables.put((Block)NSBlocks.MAPLE.getWood().get(), (Block)NSBlocks.MAPLE.getStrippedWood().get());
            strippables.put((Block)NSBlocks.CYPRESS.getWood().get(), (Block)NSBlocks.CYPRESS.getStrippedWood().get());
            strippables.put((Block)NSBlocks.OLIVE.getWood().get(), (Block)NSBlocks.OLIVE.getStrippedWood().get());
            strippables.put((Block)NSBlocks.GHAF.getWood().get(), (Block)NSBlocks.GHAF.getStrippedWood().get());
            strippables.put((Block)NSBlocks.PALO_VERDE.getWood().get(), (Block)NSBlocks.PALO_VERDE.getStrippedWood().get());
            strippables.put((Block)NSBlocks.CEDAR.getWood().get(), (Block)NSBlocks.CEDAR.getStrippedWood().get());
            strippables.put((Block)NSBlocks.COCONUT.getWood().get(), (Block)NSBlocks.COCONUT.getStrippedWood().get());
            strippables.put((Block)NSBlocks.LARCH.getWood().get(), (Block)NSBlocks.LARCH.getStrippedWood().get());
            strippables.put((Block)NSBlocks.MAHOGANY.getWood().get(), (Block)NSBlocks.MAHOGANY.getStrippedWood().get());
            strippables.put((Block)NSBlocks.SAXAUL.getWood().get(), (Block)NSBlocks.SAXAUL.getStrippedWood().get());
            strippables.put((Block)NSBlocks.ALLUAUDIA_BUNDLE.get(), (Block)NSBlocks.STRIPPED_ALLUAUDIA_BUNDLE.get());
            strippables.put((Block)NSBlocks.JOSHUA.getBundle().get(), (Block)NSBlocks.JOSHUA.getStrippedBundle().get());
            AxeItem.f_150683_ = strippables;
            NSCauldronBehavior.registerBehavior();
        });
    }

    @SubscribeEvent
    public void wandererTrades(WandererTradesEvent event) {
        List genericTrades = event.getGenericTrades();
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)NSBlocks.RED_MOSS_BLOCK.get(), 2), 5, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)NSBlocks.HIBISCUS.getFlowerBlock().get(), 2), 12, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)NSBlocks.BLUE_IRIS.getFlowerBlock().get(), 2), 12, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)NSBlocks.BLACK_IRIS.getFlowerBlock().get(), 2), 12, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)NSBlocks.ANEMONE.getFlowerBlock().get(), 2), 12, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)NSBlocks.LOTUS_FLOWER_ITEM.get(), 2), 12, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.REDWOOD.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.SUGI.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.WISTERIA.getPurpleSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.WISTERIA.getWhiteSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.WISTERIA.getBlueSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.WISTERIA.getPinkSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.FIR.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.WILLOW.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.ASPEN.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.MAPLE.getRedSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.MAPLE.getOrangeSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.MAPLE.getYellowSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.CYPRESS.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.OLIVE.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.JOSHUA.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.GHAF.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.PALO_VERDE.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.CEDAR.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.LARCH.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.MAHOGANY.getSapling().get(), 5), 8, 1, 0.5f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)NSBlocks.SAXAUL.getSapling().get(), 5), 8, 1, 0.5f));
    }

    public void creativeInventory(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            ArrayList<ItemLike> wood = new ArrayList<ItemLike>();
            wood.add((ItemLike)Items.f_244424_);
            for (WoodSet woodset : NSBlocks.getWoodSets()) {
                wood.add((ItemLike)woodset.getLog().get());
                if (woodset.getWoodPreset() == WoodSet.WoodPreset.JOSHUA) {
                    wood.addAll(List.of((Block)woodset.getBundle().get(), (Block)woodset.getStrippedLog().get(), (Block)woodset.getStrippedBundle().get(), (Block)woodset.getPlanks().get()));
                } else if (!woodset.hasBark()) {
                    wood.addAll(List.of((Block)woodset.getStrippedLog().get(), (Block)woodset.getPlanks().get()));
                } else {
                    wood.addAll(List.of((Block)woodset.getWood().get(), (Block)woodset.getStrippedLog().get(), (Block)woodset.getStrippedWood().get(), (Block)woodset.getPlanks().get()));
                }
                if (woodset.hasMosaic()) {
                    wood.addAll(List.of((Block)woodset.getMosaic().get(), (Block)woodset.getStairs().get(), (Block)woodset.getMosaicStairs().get(), (Block)woodset.getSlab().get(), (Block)woodset.getMosaicSlab().get(), (Block)woodset.getFence().get(), (Block)woodset.getFenceGate().get(), (Block)woodset.getDoor().get(), (Block)woodset.getTrapDoor().get(), (Block)woodset.getPressurePlate().get(), (Block)woodset.getButton().get()));
                    continue;
                }
                wood.addAll(List.of((Block)woodset.getStairs().get(), (Block)woodset.getSlab().get(), (Block)woodset.getFence().get(), (Block)woodset.getFenceGate().get(), (Block)woodset.getDoor().get(), (Block)woodset.getTrapDoor().get(), (Block)woodset.getPressurePlate().get(), (Block)woodset.getButton().get()));
            }
            NatureSpirit.addAllAfterFirst((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)event.getEntries(), wood, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42338_.m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getBase().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getBase().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getBaseStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getBaseStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getBaseSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getBaseSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getCobbled().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getCobbled().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getCobbledStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getCobbledStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getCobbledSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getCobbledSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getCobbledWall().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getCobbledWall().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getMossyCobbled().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getMossyCobbled().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getMossyCobbledStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getMossyCobbledStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getMossyCobbledSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getMossyCobbledSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getMossyCobbledWall().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getMossyCobbledWall().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getChiseled().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getChiseled().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getPolished().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getPolished().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getPolishedStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getPolishedStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getPolishedSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getPolishedSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getPolishedWall().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getPolishedWall().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getBricks().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getBricks().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getCrackedBricks().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getCrackedBricks().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getBricksStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getBricksStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getBricksSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getBricksSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getBricksWall().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getBricksWall().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getMossyBricks().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getMossyBricks().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getMossyBricksStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getMossyBricksStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getMossyBricksSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getMossyBricksSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getMossyBricksWall().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getMossyBricksWall().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getTiles().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getTiles().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getCrackedTiles().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getCrackedTiles().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getTilesStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getTilesStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getTilesSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getTilesSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getTilesWall().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getTilesWall().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getBase().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getBase().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getBaseStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getBaseStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getBaseSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getBaseSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getChiseled().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getChiseled().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getPolished().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getPolished().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getPolishedStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getPolishedStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getPolishedSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getPolishedSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getPolishedWall().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getPolishedWall().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getBricks().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getBricks().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getCrackedBricks().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getCrackedBricks().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getBricksStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getBricksStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getBricksSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getBricksSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getBricksWall().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getBricksWall().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getTiles().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getTiles().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getCrackedTiles().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getCrackedTiles().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getTilesStairs().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getTilesStairs().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getTilesSlab().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHERT.getTilesSlab().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getTilesWall().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_41986_.m_7968_(), (Object)((Block)NSBlocks.PINK_SANDSTONE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_SANDSTONE.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_SANDSTONE_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_SANDSTONE_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_SANDSTONE_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_SANDSTONE_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_SANDSTONE_WALL.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_SANDSTONE_WALL.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHISELED_PINK_SANDSTONE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CHISELED_PINK_SANDSTONE.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SMOOTH_PINK_SANDSTONE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SMOOTH_PINK_SANDSTONE.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SMOOTH_PINK_SANDSTONE_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SMOOTH_PINK_SANDSTONE_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SMOOTH_PINK_SANDSTONE_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SMOOTH_PINK_SANDSTONE_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CUT_PINK_SANDSTONE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CUT_PINK_SANDSTONE.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CUT_PINK_SANDSTONE_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256776_) {
            event.getEntries().putAfter((Object)Items.f_271090_.m_7968_(), (Object)((Block)NSBlocks.REDWOOD.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.REDWOOD.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SUGI.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SUGI.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.FIR.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.FIR.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WILLOW.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WILLOW.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ASPEN.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ASPEN.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAPLE.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAPLE.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYPRESS.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYPRESS.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.OLIVE.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.OLIVE.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.JOSHUA.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.JOSHUA.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GHAF.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GHAF.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PALO_VERDE.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PALO_VERDE.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.COCONUT.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.COCONUT.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CEDAR.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CEDAR.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LARCH.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LARCH.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAHOGANY.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAHOGANY.getLog().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SAXAUL.getLog().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)Items.f_41833_.m_7968_(), (Object)((Block)NSBlocks.CHERT_GOLD_ORE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_41834_.m_7968_(), (Object)((Block)NSBlocks.CHERT_IRON_ORE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_41835_.m_7968_(), (Object)((Block)NSBlocks.CHERT_COAL_ORE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_41853_.m_7968_(), (Object)((Block)NSBlocks.CHERT_LAPIS_ORE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42010_.m_7968_(), (Object)((Block)NSBlocks.CHERT_DIAMOND_ORE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_41977_.m_7968_(), (Object)((Block)NSBlocks.CHERT_REDSTONE_ORE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42107_.m_7968_(), (Object)((Block)NSBlocks.CHERT_EMERALD_ORE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_150965_.m_7968_(), (Object)((Block)NSBlocks.CHERT_COPPER_ORE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42170_.m_7968_(), (Object)((Block)NSBlocks.TRAVERTINE.getBase().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TRAVERTINE.getBase().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CHERT.getBase().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)Items.f_42252_.m_7968_(), (Object)((Block)NSBlocks.PINK_SAND.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_SAND.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_SANDSTONE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)Items.f_41911_.m_7968_(), (Object)((Block)NSBlocks.OLIVE_BRANCH.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42780_.m_7968_(), (Object)((Block)NSBlocks.COCONUT_BLOCK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_41953_.m_7968_(), (Object)((Block)NSBlocks.SHIITAKE_MUSHROOM.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SHIITAKE_MUSHROOM.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_POLYPORE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42023_.m_7968_(), (Object)((Block)NSBlocks.SHIITAKE_MUSHROOM_BLOCK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SHIITAKE_MUSHROOM_BLOCK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_POLYPORE_BLOCK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42783_.m_7968_(), (Object)((Block)NSBlocks.DESERT_TURNIP_ROOT_BLOCK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.DESERT_TURNIP_ROOT_BLOCK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.DESERT_TURNIP_BLOCK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42029_.m_7968_(), (Object)((Block)NSBlocks.WILLOW.getVines().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WILLOW.getVines().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getWhiteVines().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getWhiteVines().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getBlueVines().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getBlueVines().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getPinkVines().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getPinkVines().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getPurpleVines().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_41982_.m_7968_(), (Object)((Block)NSBlocks.ALLUAUDIA.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ALLUAUDIA.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ALLUAUDIA_BUNDLE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ALLUAUDIA_BUNDLE.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.STRIPPED_ALLUAUDIA.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.STRIPPED_ALLUAUDIA.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.STRIPPED_ALLUAUDIA_BUNDLE.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42094_.m_7968_(), (Object)((Item)NSBlocks.HELVOLA_PAD_ITEM.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.HELVOLA_PAD_ITEM.get()).m_5456_().m_7968_(), (Object)((Item)NSBlocks.HELVOLA_FLOWER_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.HELVOLA_FLOWER_ITEM.get()).m_5456_().m_7968_(), (Object)((Item)NSBlocks.LOTUS_FLOWER_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.LOTUS_FLOWER_ITEM.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LOTUS_STEM.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LOTUS_STEM.get()).m_5456_().m_7968_(), (Object)((Item)NSBlocks.AZOLLA_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_41961_.m_7968_(), (Object)((Block)NSBlocks.SANDY_SOIL.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_151016_.m_7968_(), (Object)((Block)NSBlocks.RED_MOSS_BLOCK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_151015_.m_7968_(), (Object)((Block)NSBlocks.RED_MOSS_CARPET.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_276698_.m_7968_(), (Object)((Item)NSBlocks.ORNATE_SUCCULENT_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.ORNATE_SUCCULENT_ITEM.get()).m_7968_(), (Object)((Item)NSBlocks.DROWSY_SUCCULENT_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.DROWSY_SUCCULENT_ITEM.get()).m_7968_(), (Object)((Item)NSBlocks.AUREATE_SUCCULENT_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.AUREATE_SUCCULENT_ITEM.get()).m_7968_(), (Object)((Item)NSBlocks.SAGE_SUCCULENT_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.SAGE_SUCCULENT_ITEM.get()).m_7968_(), (Object)((Item)NSBlocks.FOAMY_SUCCULENT_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.FOAMY_SUCCULENT_ITEM.get()).m_7968_(), (Object)((Item)NSBlocks.IMPERIAL_SUCCULENT_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.IMPERIAL_SUCCULENT_ITEM.get()).m_7968_(), (Object)((Item)NSBlocks.REGAL_SUCCULENT_ITEM.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42209_.m_7968_(), (Object)((Block)NSBlocks.LAVENDER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LAVENDER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLEEDING_HEART.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLEEDING_HEART.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_BULBS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_BULBS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CARNATION.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CARNATION.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GARDENIA.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GARDENIA.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SNAPDRAGON.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SNAPDRAGON.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.FOXGLOVE.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.FOXGLOVE.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BEGONIA.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_41950_.m_7968_(), (Object)((Block)NSBlocks.MARIGOLD.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MARIGOLD.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUEBELL.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUEBELL.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TIGER_LILY.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TIGER_LILY.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_WILDFLOWER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_WILDFLOWER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_WILDFLOWER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_WILDFLOWER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_HEATHER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_HEATHER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WHITE_HEATHER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_HEATHER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_HEATHER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_HEATHER.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ANEMONE.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ANEMONE.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.DWARF_BLOSSOMS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.DWARF_BLOSSOMS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PROTEA.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PROTEA.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.HIBISCUS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.HIBISCUS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_IRIS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_IRIS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_IRIS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_IRIS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RUBY_BLOSSOMS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RUBY_BLOSSOMS.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SILVERBUSH.getFlowerBlock().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42211_.m_7968_(), (Object)((Block)NSBlocks.CATTAIL.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CATTAIL.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TALL_FRIGID_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TALL_FRIGID_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TALL_SCORCHED_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TALL_SCORCHED_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TALL_BEACH_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TALL_BEACH_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TALL_SEDGE_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TALL_SEDGE_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LARGE_FLAXEN_FERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LARGE_FLAXEN_FERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TALL_OAT_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TALL_OAT_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LARGE_LUSH_FERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LARGE_LUSH_FERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.TALL_MELIC_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.TALL_MELIC_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_BEARBERRIES.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_BEARBERRIES.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_BEARBERRIES.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_BEARBERRIES.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_BEARBERRIES.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_BEARBERRIES.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_BITTER_SPROUTS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_BITTER_SPROUTS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_BITTER_SPROUTS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_BITTER_SPROUTS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_BITTER_SPROUTS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_41865_.m_7968_(), (Object)((Block)NSBlocks.BEACH_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BEACH_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SCORCHED_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SCORCHED_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SEDGE_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SEDGE_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.FLAXEN_FERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.FLAXEN_FERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.OAT_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.OAT_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LUSH_FERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LUSH_FERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MELIC_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MELIC_GRASS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.FRIGID_GRASS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_271517_.m_7968_(), (Object)((Block)NSBlocks.REDWOOD.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.REDWOOD.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.REDWOOD.getFrostyLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.REDWOOD.getFrostyLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SUGI.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SUGI.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getPurpleLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getPurpleLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getWhiteLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getWhiteLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getBlueLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getBlueLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getPinkLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getPinkLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getPartPurpleLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getPartPurpleLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getPartWhiteLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getPartWhiteLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getPartBlueLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getPartBlueLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getPartPinkLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getPartPinkLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.FIR.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.FIR.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.FIR.getFrostyLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.FIR.getFrostyLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WILLOW.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WILLOW.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ASPEN.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ASPEN.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ASPEN.getYellowLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ASPEN.getYellowLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAPLE.getRedLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAPLE.getRedLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAPLE.getOrangeLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAPLE.getOrangeLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAPLE.getYellowLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAPLE.getYellowLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYPRESS.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYPRESS.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.OLIVE.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.OLIVE.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.JOSHUA.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.JOSHUA.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GHAF.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GHAF.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PALO_VERDE.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PALO_VERDE.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CEDAR.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CEDAR.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.COCONUT.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.COCONUT.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LARCH.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LARCH.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAHOGANY.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAHOGANY.getLeaves().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SAXAUL.getLeaves().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_271375_.m_7968_(), (Object)((Block)NSBlocks.REDWOOD.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.REDWOOD.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SUGI.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.SUGI.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getPurpleSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getPurpleSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getWhiteSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getWhiteSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getBlueSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getBlueSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WISTERIA.getPinkSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WISTERIA.getPinkSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.FIR.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.FIR.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WILLOW.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WILLOW.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ASPEN.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ASPEN.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAPLE.getRedSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAPLE.getRedSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAPLE.getOrangeSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAPLE.getOrangeSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAPLE.getYellowSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAPLE.getYellowSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYPRESS.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYPRESS.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.OLIVE.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.OLIVE.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.JOSHUA.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.JOSHUA.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GHAF.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GHAF.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PALO_VERDE.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PALO_VERDE.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CEDAR.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CEDAR.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LARCH.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LARCH.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAHOGANY.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAHOGANY.getSapling().get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.SAXAUL.getSapling().get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.getEntries().putAfter((Object)Items.f_243999_.m_7968_(), (Object)((Item)NSBlocks.REDWOOD.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.REDWOOD.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.REDWOOD.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.REDWOOD.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.SUGI.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.SUGI.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.SUGI.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.SUGI.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.WISTERIA.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.WISTERIA.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.WISTERIA.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.WISTERIA.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.FIR.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.FIR.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.FIR.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.FIR.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.WILLOW.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.WILLOW.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.WILLOW.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.WILLOW.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.ASPEN.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.ASPEN.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.ASPEN.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.ASPEN.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.MAPLE.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.MAPLE.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.MAPLE.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.MAPLE.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.CYPRESS.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.CYPRESS.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.CYPRESS.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.CYPRESS.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.OLIVE.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.OLIVE.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.OLIVE.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.OLIVE.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.JOSHUA.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.JOSHUA.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.JOSHUA.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.JOSHUA.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.GHAF.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.GHAF.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.GHAF.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.GHAF.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.PALO_VERDE.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.PALO_VERDE.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.PALO_VERDE.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.PALO_VERDE.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.COCONUT.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.COCONUT.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.COCONUT.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.COCONUT.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.CEDAR.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.CEDAR.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.CEDAR.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.CEDAR.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.LARCH.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.LARCH.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.LARCH.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.LARCH.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.MAHOGANY.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.MAHOGANY.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.MAHOGANY.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.MAHOGANY.getHangingSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.SAXAUL.getSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.SAXAUL.getSignItem().get()).m_7968_(), (Object)((Item)NSBlocks.SAXAUL.getHangingSignItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42779_.m_7968_(), (Object)((Block)NSBlocks.WHITE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.getEntries().putAfter((Object)Items.f_244260_.m_7968_(), (Object)((Item)NSBlocks.REDWOOD.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.REDWOOD.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.REDWOOD.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.REDWOOD.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.SUGI.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.SUGI.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.SUGI.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.SUGI.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.WISTERIA.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.WISTERIA.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.WISTERIA.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.WISTERIA.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.FIR.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.FIR.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.FIR.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.FIR.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.WILLOW.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.WILLOW.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.WILLOW.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.WILLOW.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.ASPEN.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.ASPEN.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.ASPEN.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.ASPEN.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.MAPLE.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.MAPLE.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.MAPLE.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.MAPLE.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.CYPRESS.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.CYPRESS.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.CYPRESS.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.CYPRESS.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.OLIVE.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.OLIVE.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.OLIVE.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.OLIVE.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.JOSHUA.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.JOSHUA.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.JOSHUA.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.JOSHUA.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.GHAF.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.GHAF.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.GHAF.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.GHAF.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.PALO_VERDE.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.PALO_VERDE.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.PALO_VERDE.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.PALO_VERDE.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.COCONUT.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.COCONUT.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.COCONUT.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.COCONUT.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.CEDAR.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.CEDAR.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.CEDAR.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.CEDAR.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.LARCH.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.LARCH.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.LARCH.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.LARCH.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.MAHOGANY.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.MAHOGANY.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.MAHOGANY.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.MAHOGANY.getChestBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.SAXAUL.getBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.SAXAUL.getBoatItem().get()).m_7968_(), (Object)((Item)NSBlocks.SAXAUL.getChestBoatItem().get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256725_) {
            event.getEntries().putAfter((Object)Items.f_42169_.m_7968_(), (Object)((Block)NSBlocks.KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WHITE_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_KAOLIN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_KAOLIN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WHITE_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_KAOLIN_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WHITE_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_KAOLIN_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WHITE_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_KAOLIN_BRICKS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WHITE_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_KAOLIN_BRICK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WHITE_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_KAOLIN_BRICK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WHITE_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WHITE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PINK_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.WHITE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_151072_.m_7968_(), (Object)((Block)NSBlocks.WHITE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.WHITE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_GRAY_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_GRAY_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GRAY_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GRAY_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLACK_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLACK_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BROWN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BROWN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.RED_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.RED_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.ORANGE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.ORANGE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.YELLOW_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.YELLOW_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIME_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIME_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.GREEN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.GREEN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.CYAN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.CYAN_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.LIGHT_BLUE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.LIGHT_BLUE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.BLUE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.BLUE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PURPLE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.PURPLE_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.MAGENTA_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Block)NSBlocks.MAGENTA_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)((Block)NSBlocks.PINK_PAPER_LANTERN.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            if (ModList.get().isLoaded("arts_and_crafts")) {
                event.getEntries().putBefore((Object)((Block)NSBlocks.WHITE_CHALK.get()).m_5456_().m_7968_(), (Object)((Block)NSArtsAndCraftsCompat.BLEACHED_CHALK.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.getEntries().putBefore((Object)((Block)NSBlocks.WHITE_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)((Block)NSArtsAndCraftsCompat.BLEACHED_CHALK_STAIRS.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.getEntries().putBefore((Object)((Block)NSBlocks.WHITE_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)((Block)NSArtsAndCraftsCompat.BLEACHED_CHALK_SLAB.get()).m_5456_().m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
        if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            event.getEntries().putAfter((Object)Items.f_151049_.m_7968_(), (Object)((Item)NSBlocks.CALCITE_SHARD.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42784_.m_7968_(), (Object)((Item)NSBlocks.CHALK_POWDER.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42399_.m_7968_(), (Object)((Item)NSBlocks.COCONUT_SHELL.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256839_) {
            event.getEntries().putAfter((Object)Items.f_42732_.m_7968_(), (Object)((Item)NSBlocks.COCONUT_HALF.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.COCONUT_HALF.get()).m_7968_(), (Object)((Item)NSBlocks.DESERT_TURNIP.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)((Item)NSBlocks.DESERT_TURNIP.get()).m_7968_(), (Object)((Item)NSBlocks.OLIVES.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42406_.m_7968_(), (Object)((Item)NSBlocks.WHOLE_PIZZA.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42455_.m_7968_(), (Object)((Item)NSBlocks.CHEESE_BUCKET.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static void addAllAfterFirst(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, ArrayList<ItemLike> itemStacks, CreativeModeTab.TabVisibility tabVisibility) {
        for (int i = 1; i < itemStacks.size(); ++i) {
            entries.putAfter((Object)itemStacks.get(i - 1).m_5456_().m_7968_(), (Object)itemStacks.get(i).m_5456_().m_7968_(), (Object)tabVisibility);
        }
    }

    public void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            event.addRepositorySource(packConsumer -> {
                if (ModList.get().isLoaded("arts_and_crafts")) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/arts_and_crafts_res", (Component)Component.m_237115_((String)"pack.natures_spirit.arts_and_crafts"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/arts_and_crafts_res"})), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                packConsumer.accept(Pack.m_245429_((String)"builtin/plank_consistency", (Component)Component.m_237115_((String)"pack.natures_spirit.plank_consistency"), (boolean)false, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/plank_consistency"})), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                packConsumer.accept(Pack.m_245429_((String)"builtin/emissive_ores_compatibility", (Component)Component.m_237115_((String)"pack.natures_spirit.emissive_ores_compatibility"), (boolean)false, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/emissive_ores_compatibility"})), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
            });
        }
        if (event.getPackType() == PackType.SERVER_DATA) {
            event.addRepositorySource(packConsumer -> {
                if (ModList.get().isLoaded("arts_and_crafts")) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/arts_and_crafts_dat", (Component)Component.m_237115_((String)"pack.natures_spirit.arts_and_crafts"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/arts_and_crafts_dat"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.badlandsToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_badlands", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_badlands"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_badlands"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.birchForestToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_birch_forest", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_birch_forest"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_birch_forest"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.darkForestToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_dark_forest", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_dark_forest"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_dark_forest"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.desertToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_desert", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_desert"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_desert"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.flowerForestToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_flower_forest", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_flower_forest"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_flower_forest"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.jungleToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_jungle", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_jungle"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_jungle"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.mountainBiomesToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_mountain_biomes", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_mountain_biomes"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_mountain_biomes"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.savannaToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_savannas", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_savannas"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_savannas"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.swampToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_swamp", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_swamp"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_swamp"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.vanillaTreesToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_vanilla_trees", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_vanilla_trees"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_vanilla_trees"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
                if (NSConfig.windsweptHillsToggle) {
                    packConsumer.accept(Pack.m_245429_((String)"builtin/modified_windswept_hills", (Component)Component.m_237115_((String)"pack.natures_spirit.modified_windswept_hills"), (boolean)true, path -> new PathPackResources(path, false, ModList.get().getModFileById(MOD_ID).getFile().findResource(new String[]{"resourcepacks/modified_windswept_hills"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_));
                }
            });
        }
    }
}

