/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.skill;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import com.p1nero.invincible.InvincibleConfig;
import com.p1nero.invincible.api.events.BaseEvent;
import com.p1nero.invincible.api.events.HitEvent;
import com.p1nero.invincible.api.events.Side;
import com.p1nero.invincible.api.events.TimeStampedEvent;
import com.p1nero.invincible.api.skill.ComboNode;
import com.p1nero.invincible.api.skill.ComboType;
import com.p1nero.invincible.capability.InvinciblePlayer;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import com.p1nero.invincible.conditions.PressIntervalCondition;
import com.p1nero.invincible.conditions.PressedTimeCondition;
import com.p1nero.invincible.gameassets.InvincibleSkillDataKeys;
import com.p1nero.invincible.item.InvincibleItems;
import com.p1nero.invincible.skill.AbstractInvincibleInnateSkill;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.DealDamageEvent;
import yesman.epicfight.world.entity.eventlistener.DodgeSuccessEvent;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillCastEvent;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;

public class ComboBasicAttack
extends AbstractInvincibleInnateSkill {
    protected static final UUID EVENT_UUID = UUID.fromString("d1d114cc-f11f-11ed-a05b-0242ac114514");
    public static final Logger LOGGER = LogUtils.getLogger();
    @OnlyIn(value=Dist.CLIENT)
    protected boolean isWalking;
    protected boolean shouldDrawGui;
    protected ResourceLocation skillTextureLocation;
    protected List<String> translationKeys;
    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> walkBegin;
    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> walkEnd;
    protected ComboNode root;
    protected final int maxPressTime;
    protected final int maxReserveTime;
    protected final int maxProtectTime;
    private static final Vec2f[] CLOCK_POS = new Vec2f[]{new Vec2f(0.5f, 0.5f), new Vec2f(0.5f, 0.0f), new Vec2f(0.0f, 0.0f), new Vec2f(0.0f, 1.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 0.0f)};

    public ComboBasicAttack(Builder builder) {
        super(builder);
        this.shouldDrawGui = builder.shouldDrawGui;
        this.skillTextureLocation = builder.skillTextureLocation;
        this.root = builder.root;
        this.walkBegin = builder.walkBegin;
        this.walkEnd = builder.walkEnd;
        this.translationKeys = builder.translationKeys;
        this.maxPressTime = builder.maxPressTime;
        this.maxReserveTime = builder.maxReserveTime;
        this.maxProtectTime = builder.maxProtectTime;
    }

    public static Builder createComboBasicAttack() {
        return new Builder().setCategory((SkillCategory)SkillCategories.WEAPON_INNATE).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public boolean canExecute(SkillContainer container) {
        if (container.getExecutor().isLogicalClient()) {
            return super.canExecute(container);
        }
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).m_21205_();
        return super.canExecute(container) && EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(container.getExecutor(), itemstack) == this && ((Player)container.getExecutor().getOriginal()).m_20202_() == null;
    }

    public boolean isExecutableState(PlayerPatch<?> executor) {
        return executor.getEntityState().canBasicAttack() && !((Player)executor.getOriginal()).m_5833_();
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        ComboType type = (ComboType)ComboType.ENUM_MANAGER.get(args.readInt());
        if (type == null) {
            return;
        }
        int pressedTime = args.readInt();
        long pressInterval = args.readLong();
        this.executeOnServer(container, type, pressedTime, pressInterval);
    }

    public void executeOnServer(SkillContainer container, ComboType type, int pressedTime, long inputInterval) {
        boolean debugMode;
        if (pressedTime > this.getMaxProtectTime()) {
            return;
        }
        boolean bl = debugMode = ((Player)container.getExecutor().getOriginal()).m_21205_().m_150930_((Item)InvincibleItems.DEBUG.get()) || ((Player)container.getExecutor().getOriginal()).m_21205_().m_150930_((Item)InvincibleItems.CUSTOM_COMBO_DEMO.get());
        if (debugMode) {
            LOGGER.debug("{} {} : pressed {} ticks. Interval: {} ms.", new Object[]{((Player)container.getExecutor().getOriginal()).m_21205_().m_41778_(), type, pressedTime, inputInterval});
        }
        ((Player)container.getExecutor().getOriginal()).getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(invinciblePlayer -> {
            ComboNode current;
            ComboNode last = invinciblePlayer.getCurrentNode();
            boolean hasPressedTimeCondition = false;
            if (last == null) {
                return;
            }
            ComboNode next = current = last.getNext(type);
            if (current == null) {
                ComboType subType;
                Iterator<Object> iterator = type.getSubTypes().iterator();
                while (iterator.hasNext() && (current = last.getNext(subType = iterator.next())) == null) {
                }
            }
            if (current != null) {
                AnimationManager.AnimationAccessor<? extends StaticAnimation> animationAccessor;
                if (current.getAnimationAccessor() == null || !current.getConditionAnimations().isEmpty()) {
                    if (current.getConditionAnimations().isEmpty()) {
                        return;
                    }
                    current.getConditionAnimations().sort(Comparator.comparingInt(ComboNode::getPriority).reversed());
                    for (ComboNode conditionAnimation : current.getConditionAnimations()) {
                        boolean canExecute = true;
                        for (Condition condition : conditionAnimation.getConditions(Side.SERVER, Side.BOTH)) {
                            if (condition instanceof PressedTimeCondition) {
                                PressedTimeCondition pressedTimeCondition = (PressedTimeCondition)condition;
                                if (pressedTime >= pressedTimeCondition.getMin() && pressedTime <= pressedTimeCondition.getMax()) continue;
                                canExecute = false;
                                break;
                            }
                            if (condition instanceof PressIntervalCondition) {
                                PressIntervalCondition pressIntervalCondition = (PressIntervalCondition)condition;
                                if (inputInterval >= pressIntervalCondition.getMin() && inputInterval <= pressIntervalCondition.getMax()) continue;
                                canExecute = false;
                                break;
                            }
                            if (condition.predicate((Object)container.getExecutor())) continue;
                            canExecute = false;
                            break;
                        }
                        if (!canExecute) continue;
                        current = conditionAnimation;
                        if (conditionAnimation.hasNext()) {
                            next = conditionAnimation;
                        }
                        break;
                    }
                } else {
                    for (Condition condition : current.getConditions(Side.SERVER, Side.BOTH)) {
                        PressIntervalCondition pressIntervalCondition;
                        if (condition instanceof PressedTimeCondition) {
                            PressedTimeCondition pressedTimeCondition = (PressedTimeCondition)condition;
                            hasPressedTimeCondition = true;
                            if (pressedTime >= pressedTimeCondition.getMin() && pressedTime <= pressedTimeCondition.getMax()) continue;
                            return;
                        }
                        if (!(condition instanceof PressIntervalCondition ? inputInterval < (pressIntervalCondition = (PressIntervalCondition)condition).getMin() || inputInterval > pressIntervalCondition.getMax() : !condition.predicate((Object)container.getExecutor()))) continue;
                        return;
                    }
                    if (!hasPressedTimeCondition && pressedTime > 20) {
                        return;
                    }
                }
                if ((animationAccessor = current.getAnimationAccessor()) == null) {
                    return;
                }
                float convertTime = current.getConvertTime();
                if (debugMode) {
                    LOGGER.debug("animationAccessor: {}", animationAccessor);
                }
                container.getExecutor().playAnimationSynchronized(animationAccessor, convertTime);
                current.getOnBeginEvents().forEach(event -> event.testAndExecute((PlayerPatch<?>)container.getExecutor(), (Entity)container.getExecutor().getTarget(), (InvinciblePlayer)invinciblePlayer));
                this.initPlayer(container, (InvinciblePlayer)invinciblePlayer, current);
                if (current.isRepeatNode()) {
                    next = current.getParentNode();
                }
                invinciblePlayer.setCurrentNode(next);
                ComboBasicAttack.sendFeedback(next, container, invinciblePlayer);
                return;
            }
            invinciblePlayer.setCurrentNode(this.root);
            ComboBasicAttack.sendFeedback(this.root, container, invinciblePlayer);
            if (debugMode) {
                LOGGER.debug("Bad node, return.");
            }
        });
    }

    public static void sendFeedback(ComboNode node, SkillContainer container, InvinciblePlayer invinciblePlayer) {
        if (node == null) {
            return;
        }
        SPSkillExecutionFeedback feedbackPacket = SPSkillExecutionFeedback.executed((int)container.getSlotId());
        feedbackPacket.getBuffer().m_130079_(invinciblePlayer.saveNBTData(new CompoundTag()));
        EpicFightNetworkManager.sendToPlayer((Object)feedbackPacket, (ServerPlayer)((ServerPlayer)container.getServerExecutor().getOriginal()), (Object[])new Object[0]);
    }

    public static void executeOnServer(ServerPlayer serverPlayer, ComboType type) {
        ComboBasicAttack.executeOnServer(serverPlayer, type, 1, 0L);
    }

    public static void executeOnServer(ServerPlayer serverPlayer, ComboType type, int pressTime, long inputInterval) {
        ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class);
        Skill skill = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill();
        if (skill instanceof ComboBasicAttack) {
            ComboBasicAttack comboBasicAttack = (ComboBasicAttack)skill;
            comboBasicAttack.executeOnServer(serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE), type, pressTime, inputInterval);
        }
    }

    private void initPlayer(SkillContainer container, InvinciblePlayer invinciblePlayer, ComboNode next) {
        invinciblePlayer.resetTimeEvents();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TimeStampedEvent event : next.getTimeEvents()) {
            event.resetExecuted();
            builder.add((Object)event);
        }
        invinciblePlayer.setTimeStampedEvents((ImmutableList<TimeStampedEvent>)builder.build());
        invinciblePlayer.setHurtEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(next.getHurtEvents()));
        invinciblePlayer.setHitSuccessEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(next.getHitEvents()));
        invinciblePlayer.setDodgeSuccessEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(next.getDodgeSuccessEvents()));
        invinciblePlayer.setCanBeInterrupt(next.isCanBeInterrupt());
        invinciblePlayer.setPlaySpeedMultiplier(next.getPlaySpeed());
        invinciblePlayer.setNotCharge(next.isNotCharge());
        invinciblePlayer.setPhase(next.getNewPhase());
        if (next.getCooldown() > 0) {
            container.getDataManager().setDataSync((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get(), (Object)next.getCooldown());
            invinciblePlayer.setItemCooldown(((Player)container.getExecutor().getOriginal()).m_21205_(), next.getCooldown());
        }
        invinciblePlayer.setArmorNegation(next.getArmorNegation());
        invinciblePlayer.setHurtDamageMultiplier(next.getHurtDamageMultiplier());
        invinciblePlayer.setDamageMultiplier(next.getDamageMultiplier());
        invinciblePlayer.setImpactMultiplier(next.getImpactMultiplier());
        invinciblePlayer.setStunTypeModifier(next.getStunTypeModifier());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void executeOnClient(SkillContainer container, FriendlyByteBuf args) {
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal());
        CompoundTag tag = args.m_130260_();
        if (tag != null) {
            invinciblePlayer.loadNBTData(tag);
            ComboNode current = invinciblePlayer.getCurrentNode();
            if (current != null) {
                invinciblePlayer.getCurrentNode().getOnBeginEvents().forEach(event -> event.testAndExecute(container.getExecutor(), (Entity)container.getExecutor().getTarget(), invinciblePlayer));
            }
        }
    }

    protected void onDodgeSuccess(DodgeSuccessEvent event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal());
        ImmutableList<BaseEvent> dodgeSuccessEvents = InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getDodgeSuccessEvents();
        if (dodgeSuccessEvents != null) {
            dodgeSuccessEvents.forEach(dodgeEvent -> dodgeEvent.testAndExecute(event.getPlayerPatch(), (Entity)((ServerPlayerPatch)event.getPlayerPatch()).getTarget(), invinciblePlayer));
        }
        container.getDataManager().setDataSync((SkillDataKey)InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER.get(), (Object)((Integer)InvincibleConfig.EFFECT_TICK.get()));
    }

    protected void onTakeDamageEventAttack(TakeDamageEvent.Attack event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
        DamageSource damageSource = event.getDamageSource();
        if (damageSource instanceof EpicFightDamageSource) {
            EpicFightDamageSource epicFightDamageSource = (EpicFightDamageSource)damageSource;
            if (!invinciblePlayer.isCanBeInterrupt()) {
                epicFightDamageSource.setStunType(StunType.NONE);
            }
        }
        if (event.isParried()) {
            container.getDataManager().setDataSync((SkillDataKey)InvincibleSkillDataKeys.PARRY_TIMER.get(), (Object)((Integer)InvincibleConfig.EFFECT_TICK.get()));
        }
    }

    protected void onTakeDamageEventHurt(TakeDamageEvent.Hurt event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal());
        ImmutableList<BaseEvent> hurtEvents = InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getHurtEvents();
        if (hurtEvents != null) {
            hurtEvents.forEach(hurtEvent -> hurtEvent.testAndExecute(event.getPlayerPatch(), (Entity)((ServerPlayerPatch)event.getPlayerPatch()).getTarget(), invinciblePlayer));
        }
        if (invinciblePlayer.getHurtDamageMultiplier() != 0.0f) {
            event.attachValueModifier(ValueModifier.multiplier((float)invinciblePlayer.getHurtDamageMultiplier()));
        }
    }

    protected void onDealDamageEventAttack(DealDamageEvent.Attack event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
        if (invinciblePlayer.getStunTypeModifier() != null) {
            event.getDamageSource().setStunType(invinciblePlayer.getStunTypeModifier());
        }
        if (invinciblePlayer.getImpactMultiplier() != 1.0f) {
            event.getDamageSource().setBaseImpact(event.getDamageSource().getBaseImpact() * invinciblePlayer.getImpactMultiplier());
        }
        if (invinciblePlayer.getArmorNegation() != 0.0f) {
            event.getDamageSource().setBaseArmorNegation(invinciblePlayer.getArmorNegation());
        }
        if (invinciblePlayer.getDamageMultiplier() != null) {
            event.getDamageSource().attachDamageModifier(invinciblePlayer.getDamageMultiplier());
        }
    }

    protected void onDealDamageEventDamage(DealDamageEvent.Damage event, SkillContainer container) {
        ImmutableList<BaseEvent> hitEvents;
        float value;
        PlayerPatch playerPatch = event.getPlayerPatch();
        ItemStack mainHandItem = ((Player)playerPatch.getOriginal()).m_21205_();
        CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)mainHandItem);
        if (capabilityItem == null || !(capabilityItem.getInnateSkill(playerPatch, mainHandItem) instanceof ComboBasicAttack)) {
            return;
        }
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal());
        if (!invinciblePlayer.isNotCharge() && !container.isFull() && (value = container.getResource() + event.getAttackDamage()) > 0.0f) {
            this.setConsumptionSynchronize(container, value);
        }
        if ((hitEvents = InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getHitSuccessEvents()) != null) {
            LivingEntity target = event.getTarget() == null ? ((ServerPlayerPatch)event.getPlayerPatch()).getTarget() : event.getTarget();
            AnimationPlayer animationPlayer = playerPatch.getAnimator().getPlayerFor(null);
            hitEvents.forEach(arg_0 -> ComboBasicAttack.lambda$onDealDamageEventDamage$5(animationPlayer, event, (Entity)target, invinciblePlayer, arg_0));
        }
    }

    protected void onSkillCastEvent(SkillCastEvent event, SkillContainer container) {
        ItemStack mainHandItem = ((Player)event.getPlayerPatch().getOriginal()).m_21205_();
        if (mainHandItem.m_41619_() || !mainHandItem.getCapability(EpicFightCapabilities.CAPABILITY_ITEM).isPresent()) {
            return;
        }
        if (EpicFightCapabilities.getItemStackCapability((ItemStack)mainHandItem).getInnateSkill(event.getPlayerPatch(), mainHandItem) == null) {
            return;
        }
        SkillCategory skillCategory = event.getSkillContainer().getSkill().getCategory();
        if (skillCategory.equals(SkillCategories.BASIC_ATTACK) && !((Player)event.getPlayerPatch().getOriginal()).m_20159_()) {
            event.setCanceled(true);
        }
    }

    protected void onClientInput(MovementInputEvent event, SkillContainer container) {
        Input input = event.getMovementInput();
        boolean isUp = input.f_108568_;
        if (isUp && !this.isWalking) {
            if (this.walkBegin != null) {
                container.getExecutor().playAnimationSynchronized(this.walkBegin, 0.15f);
            }
            this.isWalking = true;
        }
        if (!isUp && this.isWalking) {
            if (this.walkEnd != null) {
                container.getExecutor().playAnimationSynchronized(this.walkEnd, 0.15f);
            }
            this.isWalking = false;
        }
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        this.resetCombo(container, container.getExecutor(), this.root);
        InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal()).resetPhase();
        container.getDataManager().setData((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get(), (Object)0);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, event -> this.onDodgeSuccess((DodgeSuccessEvent)event, container));
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> this.onTakeDamageEventAttack((TakeDamageEvent.Attack)event, container));
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, event -> this.onTakeDamageEventHurt((TakeDamageEvent.Hurt)event, container));
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> this.onDealDamageEventAttack((DealDamageEvent.Attack)event, container));
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> this.onDealDamageEventDamage((DealDamageEvent.Damage)event, container));
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID, event -> this.onSkillCastEvent((SkillCastEvent)event, container));
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> this.onClientInput((MovementInputEvent)event, container));
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch playerPatch;
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && container.getExecutor().getTickSinceLastAction() > (Integer)InvincibleConfig.RESET_TICK.get()) {
            this.resetCombo(container, (PlayerPatch<?>)container.getServerExecutor(), this.root);
        }
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal());
        SkillDataManager manager = container.getDataManager();
        if (manager.hasData((SkillDataKey)InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER.get())) {
            manager.setData((SkillDataKey)InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER.get(), (Object)Math.max((Integer)manager.getDataValue((SkillDataKey)InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER.get()) - 1, 0));
        }
        if (manager.hasData((SkillDataKey)InvincibleSkillDataKeys.PARRY_TIMER.get())) {
            manager.setData((SkillDataKey)InvincibleSkillDataKeys.PARRY_TIMER.get(), (Object)Math.max((Integer)manager.getDataValue((SkillDataKey)InvincibleSkillDataKeys.PARRY_TIMER.get()) - 1, 0));
        }
        if ((playerPatch = container.getExecutor()) instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            ItemStack itemStack = ((ServerPlayer)serverPlayerPatch.getOriginal()).m_21205_();
            int currentCooldown = invinciblePlayer.getItemCooldown(itemStack);
            if (currentCooldown > 0) {
                invinciblePlayer.setItemCooldown(itemStack, --currentCooldown);
            }
            if (currentCooldown != (Integer)manager.getDataValue((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get())) {
                manager.setDataSync((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get(), (Object)currentCooldown);
            }
        }
    }

    public void resetCombo(SkillContainer container, PlayerPatch<?> playerPatch, ComboNode root) {
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)playerPatch.getOriginal());
        invinciblePlayer.setCurrentNode(root);
        invinciblePlayer.clear();
        if (!playerPatch.isLogicalClient()) {
            ComboBasicAttack.sendFeedback(root, container, invinciblePlayer);
        }
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        if (this.translationKeys.isEmpty()) {
            return super.getTooltipOnItem(itemStack, cap, playerpatch);
        }
        ArrayList list = Lists.newArrayList();
        for (String translationKey : this.translationKeys) {
            list.add(Component.m_237115_((String)translationKey));
        }
        return list;
    }

    public boolean shouldDraw(SkillContainer container) {
        return this.shouldDrawGui;
    }

    public ResourceLocation getSkillTexture() {
        return this.skillTextureLocation == null ? super.getSkillTexture() : this.skillTextureLocation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        SkillDataManager manager;
        int stringWidth;
        int j;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        boolean creative = ((Player)container.getExecutor().getOriginal()).m_7500_();
        boolean fullstack = creative || container.isFull();
        boolean canUse = !container.isDisabled() && container.getSkill().checkExecuteCondition(container);
        float cooldownRatio = fullstack || container.isActivated() ? 1.0f : container.getResource(partialTick);
        int vertexNum = 0;
        float iconSize = 32.0f;
        float bottom = y + iconSize;
        float right = x + iconSize;
        float middle = x + iconSize * 0.5f;
        float lastVertexX = 0.0f;
        float lastVertexY = 0.0f;
        float lastTexX = 0.0f;
        float lastTexY = 0.0f;
        if (cooldownRatio < 0.125f) {
            vertexNum = 6;
            lastTexX = cooldownRatio / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = middle + iconSize * lastTexX;
            lastVertexY = y;
            lastTexX += 0.5f;
        } else if (cooldownRatio < 0.375f) {
            vertexNum = 5;
            lastTexX = 1.0f;
            lastTexY = (cooldownRatio - 0.125f) / 0.25f;
            lastVertexX = right;
            lastVertexY = y + iconSize * lastTexY;
        } else if (cooldownRatio < 0.625f) {
            vertexNum = 4;
            lastTexX = (cooldownRatio - 0.375f) / 0.25f;
            lastTexY = 1.0f;
            lastVertexX = right - iconSize * lastTexX;
            lastVertexY = bottom;
            lastTexX = 1.0f - lastTexX;
        } else if (cooldownRatio < 0.875f) {
            vertexNum = 3;
            lastTexX = 0.0f;
            lastTexY = (cooldownRatio - 0.625f) / 0.25f;
            lastVertexX = x;
            lastVertexY = bottom - iconSize * lastTexY;
            lastTexY = 1.0f - lastTexY;
        } else {
            vertexNum = 2;
            lastTexX = (cooldownRatio - 0.875f) / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = x + iconSize * lastTexX;
            lastVertexY = y;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)container.getSkill().getSkillTexture());
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (canUse) {
            if (container.getStack() > 0) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.64f, (float)0.72f, (float)0.8f);
            } else {
                RenderSystem.setShaderColor((float)0.0f, (float)0.5f, (float)0.5f, (float)0.6f);
            }
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.6f);
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        for (j = 0; j < vertexNum; ++j) {
            bufferbuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), x + iconSize * ComboBasicAttack.CLOCK_POS[j].x, y + iconSize * ComboBasicAttack.CLOCK_POS[j].y, 0.0f).m_7421_(ComboBasicAttack.CLOCK_POS[j].x, ComboBasicAttack.CLOCK_POS[j].y).m_5752_();
        }
        bufferbuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), lastVertexX, lastVertexY, 0.0f).m_7421_(lastTexX, lastTexY).m_5752_();
        tessellator.m_85914_();
        if (canUse) {
            RenderSystem.setShaderColor((float)0.08f, (float)0.79f, (float)0.95f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glCullFace((int)1028);
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        for (j = 0; j < 2; ++j) {
            bufferbuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), x + iconSize * ComboBasicAttack.CLOCK_POS[j].x, y + iconSize * ComboBasicAttack.CLOCK_POS[j].y, 0.0f).m_7421_(ComboBasicAttack.CLOCK_POS[j].x, ComboBasicAttack.CLOCK_POS[j].y).m_5752_();
        }
        for (j = CLOCK_POS.length - 1; j >= vertexNum; --j) {
            bufferbuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), x + iconSize * ComboBasicAttack.CLOCK_POS[j].x, y + iconSize * ComboBasicAttack.CLOCK_POS[j].y, 0.0f).m_7421_(ComboBasicAttack.CLOCK_POS[j].x, ComboBasicAttack.CLOCK_POS[j].y).m_5752_();
        }
        bufferbuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), lastVertexX, lastVertexY, 0.0f).m_7421_(lastTexX, lastTexY).m_5752_();
        tessellator.m_85914_();
        GL11.glCullFace((int)1029);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (container.isActivated() && (container.getSkill().getActivateType() == Skill.ActivateType.DURATION || container.getSkill().getActivateType() == Skill.ActivateType.DURATION_INFINITE)) {
            String s = String.format("%.0f", Float.valueOf((float)container.getRemainDuration() / 20.0f));
            stringWidth = (gui.getFont().m_92895_(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 13.0f - (float)stringWidth, y + 13.0f, 0xFFFFFF, true);
        } else if (!fullstack) {
            String s = String.valueOf((int)(cooldownRatio * 100.0f));
            stringWidth = (gui.getFont().m_92895_(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 13.0f - (float)stringWidth, y + 13.0f, 0xFFFFFF, true);
        }
        if (container.getSkill().getMaxStack() > 1) {
            String s = String.valueOf(container.getStack());
            stringWidth = (gui.getFont().m_92895_(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 25.0f - (float)stringWidth, y + 22.0f, 0xFFFFFF, true);
        }
        if (!(manager = container.getDataManager()).hasData((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get())) {
            return;
        }
        int cooldown = (Integer)manager.getDataValue((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get());
        if (cooldown > 0) {
            Font font = gui.getFont();
            String s = String.format("%.1fs", (double)cooldown / 20.0);
            int stringWidth2 = (font.m_92895_(s) - 6) / 3;
            guiGraphics.drawString(font, s, x - (float)stringWidth2, y + 22.0f, 0xFFFFFF, true);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public int getMaxPressTime() {
        return this.maxPressTime == 0 ? (Integer)InvincibleConfig.MAX_PRESS_TICK.get() : this.maxPressTime;
    }

    public int getMaxProtectTime() {
        return this.maxProtectTime == 0 ? (Integer)InvincibleConfig.PRESS_PROTECT_TICK.get() : this.maxProtectTime;
    }

    public int getMaxReserveTime() {
        return this.maxReserveTime == 0 ? (Integer)InvincibleConfig.RESERVE_TICK.get() : this.maxReserveTime;
    }

    private static /* synthetic */ void lambda$onDealDamageEventDamage$5(AnimationPlayer animationPlayer, DealDamageEvent.Damage event, Entity target, InvinciblePlayer invinciblePlayer, BaseEvent baseEvent) {
        if (animationPlayer != null && baseEvent instanceof HitEvent) {
            HitEvent hitEvent = (HitEvent)baseEvent;
            Object patt19513$temp = animationPlayer.getRealAnimation().get();
            if (patt19513$temp instanceof AttackAnimation) {
                AttackAnimation attackAnimation = (AttackAnimation)patt19513$temp;
                if (hitEvent.phaseIndex >= 0 && attackAnimation.getPhaseOrderByTime(animationPlayer.getElapsedTime()) != hitEvent.phaseIndex) {
                    return;
                }
            }
        }
        baseEvent.testAndExecute(event.getPlayerPatch(), target, invinciblePlayer);
    }

    public static class Builder
    extends SkillBuilder<ComboBasicAttack> {
        protected ComboNode root;
        protected List<String> translationKeys = List.of();
        protected int maxPressTime;
        protected int maxReserveTime;
        protected int maxProtectTime;
        @Nullable
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation> walkBegin;
        @Nullable
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation> walkEnd;
        protected boolean shouldDrawGui;
        protected ResourceLocation skillTextureLocation;

        public Builder setMaxPressTime(int maxPressTime) {
            this.maxPressTime = maxPressTime;
            return this;
        }

        public Builder setMaxProtectTime(int maxProtectTime) {
            this.maxProtectTime = maxProtectTime;
            return this;
        }

        public Builder setReserveTime(int maxReserveTime) {
            this.maxReserveTime = maxReserveTime;
            return this;
        }

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCombo(ComboNode root) {
            this.root = root;
            return this;
        }

        public Builder setShouldDrawGui(boolean shouldDrawGui) {
            this.shouldDrawGui = shouldDrawGui;
            return this;
        }

        public Builder setWalkBeginAnim(AnimationManager.AnimationAccessor<? extends StaticAnimation> walkBegin) {
            this.walkBegin = walkBegin;
            return this;
        }

        public Builder setWalkEndAnim(AnimationManager.AnimationAccessor<? extends StaticAnimation> walkEnd) {
            this.walkEnd = walkEnd;
            return this;
        }

        public Builder addToolTipOnItem(List<String> translationKeys) {
            this.translationKeys = translationKeys;
            return this;
        }

        public Builder setSkillTextureLocation(ResourceLocation skillTextureLocation) {
            this.skillTextureLocation = skillTextureLocation;
            return this;
        }
    }
}

