/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.api.skill;

import com.mojang.datafixers.util.Pair;
import com.p1nero.invincible.api.events.BaseEvent;
import com.p1nero.invincible.api.events.Side;
import com.p1nero.invincible.api.events.TimeStampedEvent;
import com.p1nero.invincible.api.skill.ComboNodeManager;
import com.p1nero.invincible.api.skill.ComboType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.ExtendableEnum;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.StunType;

public class ComboNode {
    private int id;
    @NotNull
    protected ComboNode root;
    @Nullable
    protected ComboNode parentNode;
    protected final Map<ComboType, ComboNode> children = new HashMap<ComboType, ComboNode>();
    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> animationAccessor;
    protected String animationName = "";
    private int priority;
    protected float playSpeed;
    protected float convertTime;
    private ValueModifier damageMultiplier = null;
    private float impactMultiplier = 1.0f;
    private float hurtDamageMultiplier;
    private float armorNegation;
    private StunType stunTypeModifier = null;
    private boolean canBeInterrupt = true;
    protected boolean notCharge;
    protected boolean repeatNode;
    protected int newPhase;
    protected int cooldown;
    protected List<Pair<Condition, Side>> conditions = new ArrayList<Pair<Condition, Side>>();
    protected List<ComboNode> conditionAnimations = new ArrayList<ComboNode>();
    protected final List<TimeStampedEvent> events = new ArrayList<TimeStampedEvent>();
    protected final List<BaseEvent> dodgeSuccessEvents = new ArrayList<BaseEvent>();
    protected final List<BaseEvent> hitEvents = new ArrayList<BaseEvent>();
    protected final List<BaseEvent> hurtEvents = new ArrayList<BaseEvent>();
    protected final List<BaseEvent> onBeginEvents = new ArrayList<BaseEvent>();

    protected ComboNode() {
        this.root = this;
        ComboNodeManager.assignId(this);
    }

    public boolean isAssigned() {
        return this.id != 0;
    }

    public int getId() {
        return this.id;
    }

    public void assign(int id) {
        this.id = id;
    }

    public boolean isRepeatNode() {
        return this.repeatNode;
    }

    public ComboNode setRepeatNode(boolean repeatNode) {
        this.repeatNode = repeatNode;
        return this;
    }

    public ComboNode setArmorNegation(float armorNegation) {
        this.armorNegation = armorNegation;
        return this;
    }

    public float getArmorNegation() {
        return this.armorNegation;
    }

    public float getHurtDamageMultiplier() {
        return this.hurtDamageMultiplier;
    }

    public ComboNode setHurtDamageMultiplier(float hurtDamageMultiplier) {
        this.hurtDamageMultiplier = hurtDamageMultiplier;
        return this;
    }

    public ValueModifier getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public ComboNode setDamageMultiplier(ValueModifier damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
        return this;
    }

    public float getImpactMultiplier() {
        return this.impactMultiplier;
    }

    public ComboNode setImpactMultiplier(float impactMultiplier) {
        this.impactMultiplier = impactMultiplier;
        return this;
    }

    public StunType getStunTypeModifier() {
        return this.stunTypeModifier;
    }

    public ComboNode setStunTypeModifier(StunType stunTypeModifier) {
        this.stunTypeModifier = stunTypeModifier;
        return this;
    }

    public boolean isCanBeInterrupt() {
        return this.canBeInterrupt;
    }

    public ComboNode setCanBeInterrupt(boolean canBeInterrupt) {
        this.canBeInterrupt = canBeInterrupt;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public ComboNode setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public ComboNode setCooldown(int cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public ComboNode setNewPhase(int newPhase) {
        this.newPhase = newPhase;
        return this;
    }

    public int getNewPhase() {
        return this.newPhase;
    }

    public ComboNode setNotCharge(boolean notCharge) {
        this.notCharge = notCharge;
        return this;
    }

    public boolean isNotCharge() {
        return this.notCharge;
    }

    public ComboNode setPlaySpeed(float playSpeed) {
        this.playSpeed = playSpeed;
        return this;
    }

    public float getPlaySpeed() {
        return this.playSpeed;
    }

    public ComboNode setConvertTime(float convertTime) {
        this.convertTime = convertTime;
        return this;
    }

    public float getConvertTime() {
        return this.convertTime;
    }

    public ComboNode addTimeEvent(TimeStampedEvent event) {
        this.events.add(event);
        return this;
    }

    public ComboNode addTimeEvent(BaseEvent event) {
        this.events.add(new TimeStampedEvent(0.01f, event.consumer));
        return this;
    }

    public ComboNode addDodgeSuccessEvent(BaseEvent event) {
        this.dodgeSuccessEvents.add(event);
        return this;
    }

    public ComboNode addHurtEvent(BaseEvent event) {
        this.hurtEvents.add(event);
        return this;
    }

    public ComboNode addHitEvent(BaseEvent event) {
        this.hitEvents.add(event);
        return this;
    }

    public ComboNode addBeginEvent(BaseEvent event) {
        this.onBeginEvents.add(event);
        return this;
    }

    public List<TimeStampedEvent> getTimeEvents() {
        return this.events;
    }

    public List<BaseEvent> getHitEvents() {
        return this.hitEvents;
    }

    public List<BaseEvent> getHurtEvents() {
        return this.hurtEvents;
    }

    public List<BaseEvent> getDodgeSuccessEvents() {
        return this.dodgeSuccessEvents;
    }

    public List<BaseEvent> getOnBeginEvents() {
        return this.onBeginEvents;
    }

    public boolean isRoot() {
        return this.equals(this.root);
    }

    public boolean isEnd() {
        return this.children.isEmpty();
    }

    public Collection<ComboNode> getChildren() {
        return this.children.values();
    }

    public ComboNode getRootNode() {
        return this.root;
    }

    @Nullable
    public ComboNode getParentNode() {
        return this.parentNode;
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getAnimationAccessor() {
        if (this.animationAccessor == null) {
            this.animationAccessor = AnimationManager.byKey((String)this.animationName);
        }
        return this.animationAccessor;
    }

    public void setAnimationProvider(@Nullable AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        this.animationAccessor = animation;
    }

    public void setAnimationName(String animationName) {
        this.animationName = animationName;
    }

    @Nullable
    public ComboNode getNext(ComboType type) {
        return this.children.get(type);
    }

    public boolean hasNext() {
        return !this.children.isEmpty();
    }

    public static ComboNode create() {
        ComboNode root;
        root.root = root = new ComboNode();
        return root;
    }

    public static ComboNode createNode(@Nullable AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        ComboNode node;
        node.root = node = new ComboNode();
        node.animationAccessor = animation;
        return node;
    }

    public ComboNode addLeaf(ComboType type, @Nullable AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        ComboNode child = new ComboNode();
        child.animationAccessor = animation;
        child.root = this.root;
        child.parentNode = this;
        this.children.put(type, child);
        return child;
    }

    public ComboNode addChild(ComboType type, ComboNode child) {
        child.root = this.root;
        child.parentNode = this;
        this.children.put(type, child);
        return this;
    }

    public boolean hasConditionAnimations() {
        return this.conditions.isEmpty();
    }

    public <T extends LivingEntityPatch<?>> ComboNode addCondition(@Nullable Condition<T> condition) {
        this.conditions.add((Pair<Condition, Side>)Pair.of(condition, (Object)((Object)Side.SERVER)));
        return this;
    }

    public <T extends LivingEntityPatch<?>> ComboNode addClientCondition(@Nullable Condition<T> condition) {
        this.conditions.add((Pair<Condition, Side>)Pair.of(condition, (Object)((Object)Side.CLIENT)));
        return this;
    }

    public <T extends LivingEntityPatch<?>> ComboNode addCondition(@Nullable Condition<T> condition, Side side) {
        this.conditions.add((Pair<Condition, Side>)Pair.of(condition, (Object)((Object)side)));
        return this;
    }

    @NotNull
    public List<Condition> getConditions(Side ... sides) {
        return this.conditions.stream().filter(pair -> Arrays.stream(sides).anyMatch(side -> side == pair.getSecond())).map(Pair::getFirst).collect(Collectors.toList());
    }

    public ComboNode addConditionNode(ComboNode conditionAnimation) {
        this.conditionAnimations.add(conditionAnimation);
        return this;
    }

    public List<ComboNode> getConditionAnimations() {
        return this.conditionAnimations;
    }

    public ComboNode key1(ComboNode child) {
        return this.addChild(ComboTypes.KEY_1, child);
    }

    public ComboNode key2(ComboNode child) {
        return this.addChild(ComboTypes.KEY_2, child);
    }

    public ComboNode key3(ComboNode child) {
        return this.addChild(ComboTypes.KEY_3, child);
    }

    public ComboNode key4(ComboNode child) {
        return this.addChild(ComboTypes.KEY_4, child);
    }

    public ComboNode keyWeaponInnate(ComboNode child) {
        return this.addChild(ComboTypes.WEAPON_INNATE, child);
    }

    public ComboNode keyDodge(ComboNode child) {
        return this.addChild(ComboTypes.DODGE, child);
    }

    public ComboNode key1_2(ComboNode child) {
        return this.addChild(ComboTypes.KEY_1_2, child);
    }

    public ComboNode key1_3(ComboNode child) {
        return this.addChild(ComboTypes.KEY_1_3, child);
    }

    public ComboNode key1_4(ComboNode child) {
        return this.addChild(ComboTypes.KEY_1_4, child);
    }

    public ComboNode key2_3(ComboNode child) {
        return this.addChild(ComboTypes.KEY_2_3, child);
    }

    public ComboNode key2_4(ComboNode child) {
        return this.addChild(ComboTypes.KEY_2_4, child);
    }

    public ComboNode key3_4(ComboNode child) {
        return this.addChild(ComboTypes.KEY_3_4, child);
    }

    public ComboNode key1(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.KEY_1, animation);
    }

    public ComboNode key2(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.KEY_2, animation);
    }

    public ComboNode key3(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.KEY_3, animation);
    }

    public ComboNode key4(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.KEY_4, animation);
    }

    public ComboNode keyWeaponInnate(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.WEAPON_INNATE, animation);
    }

    public ComboNode keyDodge(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.DODGE, animation);
    }

    public ComboNode key1_2(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.KEY_1_2, animation);
    }

    public ComboNode key1_3(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.KEY_1_3, animation);
    }

    public ComboNode key1_4(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.KEY_1_4, animation);
    }

    public ComboNode key2_3(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.KEY_2_3, animation);
    }

    public ComboNode key2_4(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.KEY_2_4, animation);
    }

    public ComboNode key3_4(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        return this.addLeaf(ComboTypes.KEY_3_4, animation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (super.equals(obj)) return true;
        if (!(obj instanceof ComboNode)) return false;
        ComboNode comboNode = (ComboNode)obj;
        if (comboNode.id != this.id) return false;
        return true;
    }

    public static enum ComboTypes implements ComboType
    {
        KEY_1,
        KEY_2,
        KEY_3,
        KEY_4,
        KEY_1_2(KEY_1, KEY_2),
        KEY_1_3(KEY_1, KEY_3),
        KEY_1_4(KEY_1, KEY_4),
        KEY_2_3(KEY_2, KEY_3),
        KEY_2_4(KEY_2, KEY_4),
        KEY_3_4(KEY_3, KEY_4),
        DODGE,
        WEAPON_INNATE;

        final int id;
        final List<ComboType> subTypes;

        private ComboTypes(ComboTypes ... subTypes) {
            this.subTypes = List.of(subTypes);
            this.id = ComboType.ENUM_MANAGER.assign((ExtendableEnum)this);
        }

        private ComboTypes() {
            this.subTypes = new ArrayList<ComboType>();
            this.id = ComboType.ENUM_MANAGER.assign((ExtendableEnum)this);
        }

        @Override
        public List<ComboType> getSubTypes() {
            return this.subTypes;
        }

        public int universalOrdinal() {
            return this.id;
        }
    }
}

