/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.util;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.soulsweaponry.api.trickweapon.TrickWeaponUtil;
import net.soulsweaponry.client.registry.KeyBindRegistry;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.IDragonBonus;
import net.soulsweaponry.items.ILifeGuard;
import net.soulsweaponry.items.IPostureLossItem;
import net.soulsweaponry.items.ITooltipInfo;
import net.soulsweaponry.items.IUltraHeavy;
import net.soulsweaponry.items.IUndeadBonus;
import net.soulsweaponry.items.armor.SetBonusArmor;
import net.soulsweaponry.items.gun.GunItem;
import net.soulsweaponry.items.katana.IBleed;
import net.soulsweaponry.items.scythe.DarkinScythePre;
import net.soulsweaponry.items.scythe.ShadowAssassinScythe;
import net.soulsweaponry.items.spear.GlaiveOfHodir;
import net.soulsweaponry.items.sword.BluemoonGreatsword;
import net.soulsweaponry.items.sword.Skofnung;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class TooltipUtil {
    public static void addTooltip(List<Component> tooltip, String id, ChatFormatting formatting, int lines) {
        tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons." + id)).m_130940_(formatting));
        for (int i = 1; i <= lines; ++i) {
            tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons." + id + "_description_" + i)).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static void addAbilityTooltip(TooltipAbilities ability, ItemStack stack, List<Component> tooltip) {
        switch (ability) {
            case SCENT_OF_BLOOD: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.scent_of_blood").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.scent_of_blood.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.scent_of_blood.2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case BLOODLUST: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bloodlust").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bloodlust.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bloodlust.2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bloodlust.3").m_130940_(ChatFormatting.GRAY));
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case BLEED: {
                int n;
                Item item = stack.m_41720_();
                if (item instanceof IBleed) {
                    IBleed bleed = (IBleed)item;
                    n = bleed.getBleedAmount();
                } else {
                    n = 0;
                }
                int amount = n;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bleed").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.bleed.1", (Object[])new Object[]{amount}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bleed.2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bleed.3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case STORMVEIL: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.stormveil").m_130940_(ChatFormatting.AQUA));
                for (int i = 1; i <= 8; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.stormveil." + i)).m_130940_(ChatFormatting.GRAY));
                }
                break;
            }
            case LIGHTBRINGER: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightbringer").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightbringer.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightbringer.2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightbringer.3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightbringer.4").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightbringer.5").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case FINAL_WOUNDS: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.final_wounds").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.final_wounds.1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(ConfigConstructor.mehrunes_razor_missing_health_chance_under_health_cap * 100.0f)) + "%"}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.final_wounds.2", (Object[])new Object[]{Float.valueOf(ConfigConstructor.mehrunes_razor_missing_health_max_bonus_damage)}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.final_wounds.3", (Object[])new Object[]{String.format("%.1f", Float.valueOf(ConfigConstructor.mehrunes_razor_missing_health_chance_over_health_cap * 100.0f)) + "%", Float.valueOf(ConfigConstructor.mehrunes_razor_missing_health_trigger_cap)}).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.final_wounds.4", (Object[])new Object[]{String.format("%.2f", Float.valueOf(ConfigConstructor.mehrunes_razor_kill_chance_under_health_cap * 100.0f)) + "%"}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.final_wounds.5", (Object[])new Object[]{String.format("%.2f", Float.valueOf(ConfigConstructor.mehrunes_razor_kill_chance_over_health_cap * 100.0f)) + "%", Float.valueOf(ConfigConstructor.mehrunes_razor_kill_trigger_cap)}).m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case ARMOR_BREAKER: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.armor_breaker").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.armor_breaker.1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case MOLTEN_EDGE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.molten_edge").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.molten_edge.1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case FLAMEBURST: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.flameburst").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.flameburst.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.flameburst.2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.flameburst.3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case FIRETHORNS: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.firethorns").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.firethorns.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.firethorns.2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case CHAIN_LIGHTNING: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chain_lightning").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chain_lightning.1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SET_BONUS: {
                MobEffectInstance[] bleed = stack.m_41720_();
                if (!(bleed instanceof SetBonusArmor)) break;
                SetBonusArmor armor = (SetBonusArmor)bleed;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.armor.set_bonus").m_130940_(ChatFormatting.AQUA));
                for (MobEffectInstance effect : armor.getFullSetEffects()) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.armor.set_bonus.gain_effects").m_7220_(effect.m_19544_().m_19482_()).m_130940_(ChatFormatting.GRAY));
                }
                tooltip.addAll(Arrays.asList(armor.getFullSetAbilities()));
                break;
            }
            case EXALT: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.exalt").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.exalt.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.exalt.2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.exalt.3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.exalt.4").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case UNBURNABLE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.fire_immune").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.fire_immune.1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case INFECTIOUS: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.infectious").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.infectious.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.infectious.2").m_130940_(ChatFormatting.GRAY));
                if (!stack.m_150930_((Item)ArmorRegistry.ENHANCED_WITHERED_CHEST.get())) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.infectious.3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case UNCEASING: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.withered_armor.unceasing").m_130940_(ChatFormatting.DARK_PURPLE));
                for (int i = 1; i <= 4; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.withered_armor.unceasing." + i)).m_130940_(ChatFormatting.GRAY));
                }
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case CORRUPT_GROUND: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_description_4").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case MIRROR: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.mirror").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.mirror.1").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)((int)(ConfigConstructor.arkenplate_mirror_trigger_percent * 100.0f) + "%")).m_130940_(ChatFormatting.RED)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.mirror.2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case AFTERSHOCK: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.aftershock").m_130940_(ChatFormatting.DARK_GREEN));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.aftershock.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.aftershock.2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.aftershock.3").m_130940_(ChatFormatting.GRAY));
                if (!stack.m_150930_((Item)ArmorRegistry.ENHANCED_ARKENPLATE.get())) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate.aftershock.4").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case UNBREAKABLE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arkenplate_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case EMPEROR: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.chaos_crown_description_3", (Object[])new Object[]{Float.valueOf(ConfigConstructor.chaos_crown_luck_given)}).m_130940_(ChatFormatting.GRAY));
                break;
            }
            case EFFECT_REVERSAL: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.reversal").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.reversal_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.reversal_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.reversal_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.reversal_4").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case TRICK_WEAPON: {
                ItemStack mappedStack = TrickWeaponUtil.getMappedStack(stack);
                if (mappedStack == null) break;
                Item item = stack.m_41720_();
                if (ITooltipInfo.shouldShowInfo()) {
                    Component text = TrickWeaponUtil.getMappedItemName(stack);
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.trick_weapon").m_130940_(ChatFormatting.WHITE));
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.trick_weapon_description_1", (Object[])new Object[]{ITooltipInfo.formatKeybindText(KeyBindRegistry.switchWeapon.m_90863_())}).m_130940_(ChatFormatting.GRAY));
                    if (text == null) break;
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.trick_weapon_description_2").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(text).m_130940_(ChatFormatting.WHITE));
                    break;
                }
                if (item instanceof ITooltipInfo) break;
                ITooltipInfo.addShowInfoText(tooltip);
                break;
            }
            case CHARGE: {
                IChargeNeeded item = (IChargeNeeded)stack.m_41720_();
                String current = Mth.m_14143_((float)((float)item.getCharge(stack) / (float)item.getMaxCharge() * 100.0f)) + "%";
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.charge").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.charge_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.charge_description_2").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)(current + " | " + item.getAddedCharge(stack))).m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case CHARGE_BONUS_DAMAGE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.charge_bonus_damage").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.charge_bonus_damage_1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case NEED_CHARGE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.need_charge").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.need_charge_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.need_charge_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case LUNAR_HERALD_NO_CHARGE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lunar_herald_no_charge_1").m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lunar_herald_no_charge_2").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case RIGHTEOUS: {
                Item current = stack.m_41720_();
                if (!(current instanceof IUndeadBonus)) break;
                IUndeadBonus undeadBonus = (IUndeadBonus)current;
                int amount = Mth.m_14143_((float)((float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack) + undeadBonus.getUndeadBonus(stack)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.righteous").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.righteous_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.righteous_description_2").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(amount))));
                break;
            }
            case MOONFALL: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonfall").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
                for (int i = 1; i <= 3; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.moonfall_description_" + i)).m_130940_(ChatFormatting.GRAY));
                }
                break;
            }
            case HEAVY: {
                Item amount = stack.m_41720_();
                if (!(amount instanceof IUltraHeavy)) break;
                IUltraHeavy heavy = (IUltraHeavy)amount;
                int postureLoss = Mth.m_14143_((float)(ConfigConstructor.stagger_enchant_posture_loss_on_player_modifier * ConfigConstructor.stagger_enchant_posture_loss_applied_per_level));
                postureLoss = Mth.m_14143_((float)((float)postureLoss * ConfigConstructor.ultra_heavy_posture_loss_modifier_when_stagger_enchant));
                postureLoss *= EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.STAGGER, (ItemStack)stack);
                postureLoss += heavy.getPostureLoss();
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.heavy_weapon_description_4", (Object[])new Object[]{postureLoss}).m_130940_(ChatFormatting.GRAY));
                if (!ConfigConstructor.ultra_heavy_disables_shields) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon_description_5").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case LIFE_STEAL: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.life_steal").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.life_steal_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case OMNIVAMP: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.omnivamp").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.omnivamp_description").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.life_steal_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case OVERHEAL: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.overheal").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.overheal_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SWORD_SLAM: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sword_slam").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sword_slam_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SKYFALL: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.grand_skyfall").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.grand_skyfall_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.grand_skyfall_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.grand_skyfall_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case INFINITY: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.infinity").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.infinity_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case CRIT: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.crit").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.crit_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.crit_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case DOOM: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.doom").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.doom_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.doom_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.doom_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case BLAZING_BLADE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.blazing_blade").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.blazing_blade_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.blazing_blade_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case TRANSFORMATION: {
                if (!stack.m_150930_((Item)WeaponRegistry.DARKIN_SCYTHE_PRE.get())) break;
                DarkinScythePre scythe = (DarkinScythePre)stack.m_41720_();
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transformation").m_130940_(ChatFormatting.LIGHT_PURPLE));
                for (int i = 1; i <= 7; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.transformation_description_" + i)).m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transformation_description_8").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(Mth.m_14143_((float)((float)scythe.getSouls(stack) / (float)scythe.MAX_SOULS * 100.0f)) + "%")).m_130940_(scythe.getDominantType(stack).equals((Object)DarkinScythePre.SoulType.BLUE) ? ChatFormatting.AQUA : ChatFormatting.RED)));
                break;
            }
            case UMBRAL_TRESPASS: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_4").m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_5").m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_6").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case DAWNBREAKER: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.meridias_retribution").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.meridias_retribution_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.meridias_retribution_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case RAGE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.rage").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.rage_description").m_130940_(ChatFormatting.GRAY));
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case LIGHTNING_CALL: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightning").m_130940_(ChatFormatting.YELLOW));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightning_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightning_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case STORM_STOMP: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.storm_stomp").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.storm_stomp_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case WEATHERBORN: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.weatherborn").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.weatherborn_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case DRAGON_STAFF: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.dragon_staff").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.dragon_staff_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.dragon_staff_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case VENGEFUL_FOG: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.vengeful_fog").m_130940_(ChatFormatting.LIGHT_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.vengeful_fog_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.vengeful_fog_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.vengeful_fog_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case NIGHT_PROWLER: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.night_prowler").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.night_prowler_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case DETONATE_SPEARS: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.detonate_spears").m_130940_(ChatFormatting.RED));
                for (int i = 1; i <= 5; ++i) {
                    if (i == 3) {
                        tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.detonate_spears_description_" + i)).m_7220_((Component)Component.m_237113_((String)String.valueOf(ConfigConstructor.draupnir_spear_detonate_power + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)stack) / 2.5f)).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.GRAY));
                        continue;
                    }
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.detonate_spears_description_" + i)).m_130940_(ChatFormatting.GRAY));
                }
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.detonate_spears_description_6").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.detonate_spears_description_7").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case FEATHERLIGHT: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.featherlight").m_130940_(ChatFormatting.LIGHT_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.featherlight_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.featherlight_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SOUL_TRAP: {
                String kills = "0";
                if (stack.m_41782_() && stack.m_41783_().m_128441_("kills")) {
                    kills = String.valueOf(stack.m_41783_().m_128451_("kills"));
                }
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_trap").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_trap_description").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_trap_kills").m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)Component.m_237113_((String)kills).m_130940_(ChatFormatting.WHITE)));
                break;
            }
            case SOUL_RELEASE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release").m_130940_(ChatFormatting.DARK_BLUE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SOUL_RELEASE_WITHER: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_wither").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_wither_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_wither_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_wither_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case COLLECT: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.collect_1").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.collect_2").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.collect_3").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case SUMMON_WEAPON: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.freyr_sword_description_2", (Object[])new Object[]{ITooltipInfo.formatKeybindText(KeyBindRegistry.returnFreyrSword.m_90863_())}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.freyr_sword_description_4", (Object[])new Object[]{ITooltipInfo.formatKeybindText(KeyBindRegistry.stationaryFreyrSword.m_90863_())}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_note_1").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_note_2").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_note_3").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                break;
            }
            case GALEFORCE: {
                TooltipUtil.addTooltip(tooltip, "galeforce", ChatFormatting.AQUA, 6);
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case FURY: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.fury").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.fury_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case HASTE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.haste").m_130940_(ChatFormatting.YELLOW));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.haste_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case FLAME_ENRAGED: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.flame_enraged").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.flame_enraged_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case RETURNING: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.returning").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.returning_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.returning_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.returning_description_3").m_7220_(KeyBindRegistry.returnThrownWeapon.m_90863_()).m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case HEAVY_THROW: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_throw").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_throw_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case PERMAFROST: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.permafrost").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.permafrost_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.permafrost_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case FREEZE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freeze").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freeze_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case MAGIC_DAMAGE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.magic_damage").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.magic_damage_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.magic_damage_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.magic_damage_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.magic_damage_description_4").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(ConfigConstructor.lich_bane_bonus_magic_damage + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack))).m_130940_(ChatFormatting.DARK_AQUA)));
                break;
            }
            case MJOLNIR_LIGHTNING: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightning").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_lightning_call_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_lightning_call_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_lightning_call_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case OFF_HAND_FLIGHT: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.off_hand_flight").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.off_hand_flight_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case THROW_LIGHTNING: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_throw").m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_throw_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_throw_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case MOONLIGHT: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_description").m_130940_(ChatFormatting.GRAY));
                if (!(stack.m_41720_() instanceof BluemoonGreatsword)) break;
                TooltipUtil.addAbilityTooltip(TooltipAbilities.LUNAR_HERALD_NO_CHARGE, stack, tooltip);
                break;
            }
            case MOONLIGHT_ATTACK: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_attack_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_attack_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_attack_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case LUNAR_HERALD: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lunar_herald").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lunar_herald_description_1").m_130940_(ChatFormatting.GRAY).m_7220_(KeyBindRegistry.effectShootMoonlight.m_90863_()));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lunar_herald_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SUMMON_GHOST: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.ghost_summoner").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.ghost_summoner_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SHIELD: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shield").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shield_description").m_130940_(ChatFormatting.GRAY));
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case OBLITERATE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.obliterate").m_130940_(ChatFormatting.DARK_BLUE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.obliterate_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case TRIPLE_MOONLIGHT: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.pure_moonlight_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SHADOW_STEP: {
                String seconds = String.valueOf(Mth.m_14143_((float)((float)ShadowAssassinScythe.TICKS_FOR_BONUS / 20.0f)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.early_combat").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.early_combat_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.early_combat_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.early_combat_description_3").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)Component.m_237113_((String)seconds).m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case DISABLE_HEAL: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.disable_heal").m_130940_(ChatFormatting.BOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.disable_heal_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.disable_heal_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SHARPEN: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sharpen").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sharpen_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sharpen_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sharpen_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case IS_SHARPENED: {
                if (!Skofnung.isEmpowered(stack)) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.empowered").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)(Skofnung.empAttacksLeft(stack) + "/8")).m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case DISABLE_DEBUFS: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skofnung_stone").m_130940_(ChatFormatting.LIGHT_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skofnung_stone_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skofnung_stone_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case LUMINATE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.luminate").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.luminate_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SPIDERS_BANE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bane_of_arthropods").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bane_of_arthropods_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bane_of_arthropods_description_2").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(ConfigConstructor.sting_bonus_arthropod_damage)).m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case SAWBLADE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sawblade").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sawblade_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sawblade_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case WABBAJACK: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.wabbajack").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.OBFUSCATED}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.wabbajack_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case LUCK_BASED: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lucky").m_130940_(ChatFormatting.DARK_GREEN));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lucky_description_1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case PARRY: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.parry").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.parry_description_1", (Object[])new Object[]{ITooltipInfo.formatKeybindText(KeyBindRegistry.parry.m_90863_())}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.parry_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.parry_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SKYWARD_STRIKES: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skyward_strikes").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skyward_strikes_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skyward_strikes_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case KEYBIND_ABILITY: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.keybind_ability").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(KeyBindRegistry.keybindAbility.m_90863_()));
                break;
            }
            case NIGHTS_EDGE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.nights_edge").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.nights_edge_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.nights_edge_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.nights_edge_description_3").m_130940_(ChatFormatting.GRAY));
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case CHAOS_STORM: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_storm").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_storm_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_storm_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case VEIL_OF_FIRE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.veil_of_fire").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.veil_of_fire_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.veil_of_fire_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.veil_of_fire_description_3").m_130940_(ChatFormatting.GRAY));
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case BLIGHT: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.blight").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.BOLD));
                for (int i = 1; i <= 5; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.blight_description_" + i)).m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.blight_description_6").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case FAST_PULL: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.fast_pull").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.fast_pull_1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SLOW_PULL: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.slow_pull").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.slow_pull_1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case THIRD_SHOT: {
                float bonus = 0.0f;
                if (stack.m_150930_((Item)WeaponRegistry.KRAKEN_SLAYER.get())) {
                    bonus = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                }
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.third_shot").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.third_shot_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237113_((String)String.valueOf(ConfigConstructor.kraken_slayer_bonus_true_damage + bonus)).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"tooltip.soulsweapons.third_shot_2").m_130940_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.third_shot_3").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(Mth.m_14143_((float)((1.0f - ConfigConstructor.kraken_slayer_player_true_damage_taken_modifier) * 100.0f)) + "%"))).m_130940_(ChatFormatting.DARK_GRAY));
                if (!stack.m_150930_((Item)WeaponRegistry.KRAKEN_SLAYER_CROSSBOW.get())) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.third_shot_4").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case MOONLIGHT_ARROW: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_arrow").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_arrow_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_arrow_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case ARROW_STORM: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arrow_storm").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arrow_storm_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arrow_storm_2").m_130940_(ChatFormatting.GRAY));
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case TRANSPARENT: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transparent").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transparent.1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case CHUNGUS_INFUSED: {
                int id = new Random().nextInt(0, 16);
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chungus_infused").m_130940_(ChatFormatting.m_126647_((int)id)));
                for (int i = 1; i <= 7; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.chungus_infused." + i)).m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.chungus_infused.8", (Object[])new Object[]{Float.valueOf(ConfigConstructor.chungus_staff_ticks_before_explosion)}).m_130940_(ChatFormatting.GRAY));
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chungus_infused.9").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case FROST_MOON: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.frost_moon").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.frost_moon.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.frost_moon.2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.frost_moon.3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.frost_moon.4").m_130940_(ChatFormatting.GRAY));
                TooltipUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case GLAIVE_DANCE: {
                int n;
                int n2;
                Item text = stack.m_41720_();
                if (text instanceof GlaiveOfHodir) {
                    GlaiveOfHodir item = (GlaiveOfHodir)text;
                    n2 = item.getMaxStacks();
                } else {
                    n2 = 5;
                }
                int maxStacks = n2;
                Item item = stack.m_41720_();
                if (item instanceof GlaiveOfHodir) {
                    GlaiveOfHodir item2 = (GlaiveOfHodir)item;
                    n = item2.getMaxStacksCooldown();
                } else {
                    n = 200;
                }
                int cooldown = n;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.glaive_dance").m_130940_(ChatFormatting.GOLD));
                for (int i = 1; i <= 4; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.glaive_dance." + i)).m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.glaive_dance.5", (Object[])new Object[]{maxStacks}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.glaive_dance.6", (Object[])new Object[]{Mth.m_14143_((float)((float)cooldown / 20.0f))}).m_130940_(ChatFormatting.GRAY));
                if (WeaponUtil.isFightModLoaded()) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.glaive_dance.7").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case GHOST_GLAIVE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.ghost_glaive").m_130940_(ChatFormatting.YELLOW));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.ghost_glaive.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.ghost_glaive.2", (Object[])new Object[]{Float.valueOf(ConfigConstructor.glaive_of_hodir_projectile_posture_loss)}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.ghost_glaive.3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case SONIC_BOOM: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sonic_boom").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sonic_boom.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.sonic_boom.2", (Object[])new Object[]{String.format("%.1f", Float.valueOf(ConfigConstructor.excalibur_sonic_boom_max_range))}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.sonic_boom.3", (Object[])new Object[]{String.format("%.1f", Float.valueOf(ConfigConstructor.excalibur_sonic_boom_target_search_range))}).m_130940_(ChatFormatting.GRAY));
                break;
            }
            case LIFE_GUARD: {
                ILifeGuard item = (ILifeGuard)stack.m_41720_();
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.life_guard").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.life_guard.1", (Object[])new Object[]{String.format("%.1f", item.getLifeGuardPercent(stack) * 100.0) + "%"}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.life_guard.2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.life_guard.3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.life_guard.4", (Object[])new Object[]{String.format("%.1f", item.getLifeSaveChance(stack) * 100.0) + "%"}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.life_guard.5").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.life_guard.6", (Object[])new Object[]{item.getLifeSaveStackDamage(stack)}).m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case TRANSIENT_MOONLIGHT: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transient_moonlight").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transient_moonlight.1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transient_moonlight.2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transient_moonlight.3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transient_moonlight.4").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case GUN_ITEM: {
                Item cooldown = stack.m_41720_();
                if (!(cooldown instanceof GunItem)) break;
                GunItem gun = (GunItem)cooldown;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.gun_posture_loss").m_7220_((Component)Component.m_237113_((String)String.valueOf(gun.getPostureLoss(stack)))).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.gun_posture_loss_on_players", (Object[])new Object[]{Mth.m_14143_((float)(ConfigConstructor.silver_bullet_posture_loss_on_player_modifier * 100.0f)) + "%"}).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.gun_damage").m_7220_((Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf(gun.getBulletDamage(stack))))).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.gun_cooldown").m_7220_((Component)Component.m_237113_((String)String.valueOf(gun.getCooldown(stack)))).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.gun_bullets_used").m_7220_((Component)Component.m_237113_((String)String.valueOf(gun.getBulletsNeeded(stack)))).m_130940_(ChatFormatting.GRAY));
                if (gun.m_8105_(stack) == 0) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.gun_max_use_time").m_7220_((Component)Component.m_237113_((String)String.valueOf(gun.m_8105_(stack)))).m_130940_(ChatFormatting.GRAY));
                break;
            }
            case PROJECTILE_POSTURE_LOSS: {
                Item cooldown = stack.m_41720_();
                if (!(cooldown instanceof IPostureLossItem)) break;
                IPostureLossItem postureLoss = (IPostureLossItem)cooldown;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.projectile_posture_loss").m_130940_(ChatFormatting.LIGHT_PURPLE));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.projectile_posture_loss.1", (Object[])new Object[]{postureLoss.getPostureLoss()}).m_130940_(ChatFormatting.GRAY));
                break;
            }
            case DRAGONS_SCOURGE: {
                Item cooldown = stack.m_41720_();
                if (!(cooldown instanceof IDragonBonus)) break;
                IDragonBonus bonus = (IDragonBonus)cooldown;
                float amount = bonus.getDragonBonus(stack);
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.dragons_bane").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.dragons_bane.1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(amount))}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.dragons_bane.2").m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

