/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.C2S;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;

public class DamagingBoxC2S {
    private final BlockPos blockPos;
    private final double expansion;
    private final float damage;
    private final float knockbackStrength;
    private final float knockbackX;
    private final float knockbackZ;
    private final SoundEvent sound;
    private final BlockPos soundPos;
    private final UUID attackerUUID;

    public DamagingBoxC2S(BlockPos blockPos, double expansion, float damage, float knockbackStrength, float knockbackX, float knockbackZ, SoundEvent sound, BlockPos soundPos, UUID attackerUUID) {
        this.blockPos = blockPos;
        this.expansion = expansion;
        this.damage = damage;
        this.knockbackStrength = knockbackStrength;
        this.knockbackX = knockbackX;
        this.knockbackZ = knockbackZ;
        this.sound = sound;
        this.soundPos = soundPos;
        this.attackerUUID = attackerUUID;
    }

    public DamagingBoxC2S(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.expansion = buf.readDouble();
        this.damage = buf.readFloat();
        this.knockbackStrength = buf.readFloat();
        this.knockbackX = buf.readFloat();
        this.knockbackZ = buf.readFloat();
        this.sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(buf.m_130281_());
        this.soundPos = buf.m_130135_();
        this.attackerUUID = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.writeDouble(this.expansion);
        buf.writeFloat(this.damage);
        buf.writeFloat(this.knockbackStrength);
        buf.writeFloat(this.knockbackX);
        buf.writeFloat(this.knockbackZ);
        buf.m_130085_(this.sound.m_11660_());
        buf.m_130064_(this.soundPos);
        buf.m_130077_(this.attackerUUID);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            this.handlePacket(player, this);
        });
        context.setPacketHandled(true);
    }

    private void handlePacket(ServerPlayer player, DamagingBoxC2S packet) {
        DamageSource source;
        ServerLevel serverWorld = (ServerLevel)player.m_9236_();
        Entity attacker = serverWorld.m_8791_(packet.attackerUUID);
        if (attacker instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)attacker;
            source = serverWorld.m_269111_().m_269333_(living);
        } else {
            source = serverWorld.m_269111_().m_269264_();
        }
        for (Entity entity : serverWorld.m_45933_((Entity)player, new AABB(packet.blockPos).m_82400_(packet.expansion))) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            target.m_6469_(source, packet.damage);
            if (packet.knockbackX == 0.0f && packet.knockbackZ == 0.0f) {
                double x = (double)packet.blockPos.m_123341_() - target.m_20185_();
                double z = (double)packet.blockPos.m_123343_() - target.m_20189_();
                target.m_147240_((double)packet.knockbackStrength, x, z);
                continue;
            }
            target.m_147240_((double)packet.knockbackStrength, (double)packet.knockbackX, (double)packet.knockbackZ);
        }
        serverWorld.m_5594_(null, packet.soundPos, packet.sound, SoundSource.HOSTILE, 1.0f, 1.0f);
    }
}

