/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.mixin;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.ParryData;
import net.soulsweaponry.entitydata.UmbralTrespassData;
import net.soulsweaponry.items.IDetonateGround;
import net.soulsweaponry.items.IUltraHeavy;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.WeaponUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerEntityMixin {
    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptFallDamage(float fallDistance, float damageMultiplier, DamageSource source, CallbackInfoReturnable<Boolean> info) {
        if (IDetonateGround.triggerCalculateFall((LivingEntity)((Player)this), fallDistance, source)) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"tickRiding"}, at={@At(value="HEAD")})
    public void interceptTickRiding(CallbackInfo info) {
        Player player = (Player)this;
        if (!player.m_9236_().f_46443_ && UmbralTrespassData.shouldDamageRiding((LivingEntity)player)) {
            int cooldown = UmbralTrespassData.getAbilityCooldown((LivingEntity)player);
            player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.COOLDOWN.get(), cooldown, 0));
            if (!player.m_21023_((MobEffect)EffectRegistry.GHOSTLY.get())) {
                player.m_8127_();
            }
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    public void attack(Entity target, CallbackInfo info) {
        Player player = (Player)this;
        if (!player.m_9236_().f_46443_ && player.m_21023_((MobEffect)EffectRegistry.GHOSTLY.get())) {
            info.cancel();
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        Entity projectilePos;
        Entity entity;
        int frames;
        Player player = (Player)this;
        if (player.m_21023_((MobEffect)EffectRegistry.GHOSTLY.get())) {
            info.setReturnValue((Object)false);
        }
        if ((frames = ParryData.getParryFrames(player)) >= 1 && (float)frames <= ConfigConstructor.shield_parry_frames && !source.m_269533_(DamageTypeTags.f_276146_)) {
            player.m_9236_().m_7605_((Entity)player, (byte)29);
            if (source.m_269533_(DamageTypeTags.f_268524_) && source.m_7640_() instanceof Projectile) {
                info.setReturnValue((Object)false);
                return;
            }
            entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                if (!attacker.m_21023_((MobEffect)EffectRegistry.POSTURE_BREAK.get())) {
                    attacker.m_9236_().m_5594_(null, attacker.m_20183_(), (SoundEvent)SoundRegistry.POSTURE_BREAK_EVENT.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                attacker.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.POSTURE_BREAK.get(), 60, 0));
                attacker.m_147240_((double)0.4f, player.m_20185_() - attacker.m_20185_(), player.m_20189_() - attacker.m_20189_());
                info.setReturnValue((Object)false);
            }
        }
        if (player.m_150109_().m_36052_(2).m_150930_((Item)ArmorRegistry.ENHANCED_ARKENPLATE.get()) && player.m_21223_() < player.m_21233_() * ConfigConstructor.arkenplate_mirror_trigger_percent && source.m_269533_(DamageTypeTags.f_268524_) && (entity = source.m_7640_()) instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            Vec3 playerPos = player.m_20182_();
            projectilePos = projectile.m_20182_();
            Vec3 projectileMotion = projectile.m_20184_();
            Vec3 reflectionVector = this.calculateReflectionVector(playerPos, (Vec3)projectilePos, projectileMotion);
            projectile.m_20256_(reflectionVector);
            info.setReturnValue((Object)false);
        }
        ItemStack stack = player.m_150109_().m_36052_(2);
        projectilePos = source.m_7639_();
        if (projectilePos instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)projectilePos;
            if (player.m_21023_((MobEffect)EffectRegistry.LIFE_LEACH.get()) && !stack.m_41619_() && (stack.m_150930_((Item)ArmorRegistry.ENHANCED_WITHERED_CHEST.get()) || stack.m_150930_((Item)ArmorRegistry.WITHERED_CHEST.get()))) {
                double x = player.m_20185_() - attacker.m_20185_();
                double z = player.m_20189_() - attacker.m_20189_();
                attacker.m_6469_(player.m_269291_().m_269251_(), 1.0f);
                attacker.m_147240_(0.5, x, z);
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19615_, (int)ConfigConstructor.withered_chest_apply_wither_duration, (int)ConfigConstructor.withered_chest_apply_wither_amplifier));
                if (!player.m_150109_().m_36052_(2).m_41619_() && player.m_150109_().m_36052_(2).m_150930_((Item)ArmorRegistry.ENHANCED_WITHERED_CHEST.get())) {
                    attacker.m_20254_((int)ConfigConstructor.withered_chest_apply_fire_seconds);
                }
                if (!player.m_9236_().f_46443_) {
                    for (int i = 0; i < 50; ++i) {
                        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.BLACK_FLAME.get()), player.m_20208_(1.0), player.m_20227_(0.5) + player.m_217043_().m_188500_() * 2.0 - 1.0, player.m_20262_(1.0), 1, 0.0, 0.0, 0.0, player.m_217043_().m_188583_() / 10.0);
                    }
                }
                player.m_5496_(SoundEvents.f_12558_, 1.0f, 1.0f);
            }
        }
    }

    @Unique
    private Vec3 calculateReflectionVector(Vec3 playerPos, Vec3 projectilePos, Vec3 projectileMotion) {
        Vec3 vectorToPlayer = playerPos.m_82546_(projectilePos).m_82541_();
        return projectileMotion.m_82546_(vectorToPlayer.m_82490_(projectileMotion.m_82526_(vectorToPlayer) * 2.0));
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    public void interceptAttack(Entity target, CallbackInfo info) {
        Player player = (Player)this;
        if (target instanceof LivingEntity && player.m_21023_((MobEffect)EffectRegistry.BLOODTHIRSTY.get()) && player.m_21205_().m_41720_() instanceof TieredItem) {
            float attackCooldown = player.m_36403_(0.5f);
            float heal = (2.0f + (float)player.m_21124_((MobEffect)EffectRegistry.BLOODTHIRSTY.get()).m_19564_()) * attackCooldown;
            player.m_5634_(heal);
        }
    }

    @Inject(method={"getEquippedStack"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptGetEquippedStackHead(EquipmentSlot slot, CallbackInfoReturnable<ItemStack> info) {
        IUltraHeavy item;
        boolean offHeavy;
        IUltraHeavy item2;
        if (WeaponUtil.isFightModLoaded()) {
            return;
        }
        Player player = (Player)this;
        ItemStack stack = player.m_150109_().m_36056_();
        Item item3 = stack.m_41720_();
        boolean mainHeavy = item3 instanceof IUltraHeavy && (item2 = (IUltraHeavy)item3).isHeavy();
        ItemStack offStack = (ItemStack)player.m_150109_().f_35976_.get(0);
        Item item4 = offStack.m_41720_();
        boolean bl = offHeavy = item4 instanceof IUltraHeavy && (item = (IUltraHeavy)item4).isHeavy();
        if (ConfigConstructor.ultra_heavy_disable_offhand_when_held) {
            if (slot == EquipmentSlot.OFFHAND && mainHeavy) {
                info.setReturnValue((Object)ItemStack.f_41583_);
                info.cancel();
            }
            if (offHeavy && !stack.m_41619_() && !mainHeavy) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 10, 3));
            }
        }
    }
}

