/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.UmbralTrespassData;
import net.soulsweaponry.items.IDetonateGround;
import net.soulsweaponry.items.IUltraHeavy;
import net.soulsweaponry.items.abilities.FireThorns;
import net.soulsweaponry.items.abilities.StormveilThorns;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.ModifyDamageUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Unique
    private DamageSource capturedDamageSource;

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="HEAD")})
    private void captureDamageSource(DamageSource source, float amount, CallbackInfoReturnable<Float> info) {
        this.capturedDamageSource = source;
    }

    @ModifyReturnValue(method={"modifyAppliedDamage"}, at={@At(value="TAIL")})
    private float modifyDamageReturnValue(float originalAmount) {
        LivingEntity entity = (LivingEntity)this;
        if (this.capturedDamageSource != null) {
            return ModifyDamageUtil.modifyDamageTakenTail(entity, originalAmount, this.capturedDamageSource);
        }
        return originalAmount;
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptDamageHead(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        LivingEntity entity = (LivingEntity)this;
        if (source.m_269533_(DamageTypeTags.f_268725_) && entity.m_21023_((MobEffect)EffectRegistry.STORMVEIL.get())) {
            entity.m_5634_(ConfigConstructor.tonitrus_stormveil_effect_lightning_damage_heal + (float)entity.m_21124_((MobEffect)EffectRegistry.STORMVEIL.get()).m_19564_());
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    public void interceptDamageTail(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        InteractionHand[] interactionHandArray;
        LivingEntity entity = (LivingEntity)this;
        if (((Boolean)info.getReturnValue()).booleanValue() && entity.m_21023_((MobEffect)EffectRegistry.BLADE_DANCE.get())) {
            int amp = entity.m_21124_((MobEffect)EffectRegistry.BLADE_DANCE.get()).m_19564_();
            int duration = entity.m_21124_((MobEffect)EffectRegistry.BLADE_DANCE.get()).m_19557_();
            entity.m_21195_((MobEffect)EffectRegistry.BLADE_DANCE.get());
            if (--amp >= 0) {
                entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLADE_DANCE.get(), duration, amp));
            }
        }
        if ((interactionHandArray = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)interactionHandArray;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = entity.m_21120_(hand);
                if (!stack.m_150930_((Item)WeaponRegistry.SUPERNOVA.get())) continue;
                FireThorns.trigger(entity, attacker);
            }
            if (entity.m_21023_((MobEffect)EffectRegistry.STORMVEIL.get())) {
                StormveilThorns.trigger(entity, attacker, entity.m_21124_((MobEffect)EffectRegistry.STORMVEIL.get()).m_19564_());
            }
        }
    }

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptHeal(float amount, CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_21023_((MobEffect)EffectRegistry.DISABLE_HEAL.get())) {
            info.cancel();
        }
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptFallDamage(float fallDistance, float damageMultiplier, DamageSource source, CallbackInfoReturnable<Boolean> info) {
        LivingEntity entity = (LivingEntity)this;
        if (!(entity instanceof Player) && IDetonateGround.triggerCalculateFall(entity, fallDistance, source)) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"onDismounted"}, at={@At(value="HEAD")})
    public void interceptDismount(Entity entity, CallbackInfo info) {
        LivingEntity thisEntity = (LivingEntity)this;
        if (!thisEntity.m_9236_().f_46443_ && entity instanceof LivingEntity) {
            Player player;
            LivingEntity target = (LivingEntity)entity;
            if (thisEntity instanceof Player && UmbralTrespassData.shouldDamageRiding((LivingEntity)(player = (Player)thisEntity))) {
                float damage = UmbralTrespassData.getAbilityDamage((LivingEntity)player);
                boolean shouldHeal = UmbralTrespassData.shouldAbilityHeal((LivingEntity)player);
                if (shouldHeal) {
                    float healing = (damage += target.m_21233_() * (ConfigConstructor.darkin_scythe_prime_ability_percent_health_damage / 100.0f)) * ConfigConstructor.darkin_scythe_prime_heal_modifier;
                    player.m_5634_(healing);
                }
                player.m_21195_(MobEffects.f_19609_);
                player.m_21195_((MobEffect)EffectRegistry.GHOSTLY.get());
                target.m_6469_(player.m_9236_().m_269111_().m_269333_((LivingEntity)player), damage);
                UmbralTrespassData.setShouldDamageRiding((LivingEntity)player, false);
                if (!player.m_9236_().f_46443_ && player.m_20183_() != null) {
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.SLICE_TARGET_EVENT.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
                    ParticleHandler.particleOutburstMap(player.m_9236_(), 150, player.m_20185_(), player.m_20188_(), player.m_20189_(), ParticleEvents.SOUL_FLAME_SMALL_OUTBURST_MAP, 1.0f);
                }
            }
        }
    }

    @Inject(method={"disablesShield"}, at={@At(value="HEAD")}, cancellable=true)
    private void interceptDisablesShield(CallbackInfoReturnable<Boolean> info) {
        IUltraHeavy item;
        Item item2;
        LivingEntity entity = (LivingEntity)this;
        if (ConfigConstructor.ultra_heavy_disables_shields && (item2 = entity.m_21205_().m_41720_()) instanceof IUltraHeavy && (item = (IUltraHeavy)item2).isHeavy()) {
            info.setReturnValue((Object)true);
            info.cancel();
        }
    }
}

