/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.EmpoweredDawnbreakerRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.noclip.DamagingWarmupEntityEvents;
import net.soulsweaponry.entity.projectile.noclip.FlamePillar;
import net.soulsweaponry.items.sword.AbstractDawnbreaker;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EmpoweredDawnbreaker
extends AbstractDawnbreaker
implements IKeybindAbility {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EmpoweredDawnbreaker(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.empowered_dawnbreaker_damage, ConfigConstructor.empowered_dawnbreaker_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.CHAOS_STORM, TooltipAbilities.VEIL_OF_FIRE);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        int i;
        Player player;
        if (user instanceof Player && !(player = (Player)user).m_36335_().m_41519_((Item)this) && (i = WeaponUtil.getChargeTime(stack, remainingUseTicks)) >= 10) {
            stack.m_41622_(1, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
            this.summonFlamePillars(world, stack, user);
            this.applyItemCooldown(player, this.getScaledCooldown(stack));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 300, 0));
        }
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.empowered_dawnbreaker_ability_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.empowered_dawnbreaker_ability_enchant_reduces_cooldown_ids;
    }

    protected int getScaledCooldown(ItemStack stack) {
        int base = (int)ConfigConstructor.empowered_dawnbreaker_ability_cooldown;
        return (int)Math.max(ConfigConstructor.empowered_dawnbreaker_ability_min_cooldown, (float)(base - this.getReduceCooldownEnchantLevel(stack) * 40));
    }

    private void summonFlamePillars(Level world, ItemStack stack, LivingEntity user) {
        if (!world.f_46443_) {
            int i = 0;
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            list.add(new BlockPos(0, 0, 0));
            while (i < 20 + 3 * WeaponUtil.getEnchantDamageBonus(stack)) {
                int x = user.m_146903_() + user.m_217043_().m_188503_(12) - 6;
                int y = user.m_146904_();
                int z = user.m_146907_() + user.m_217043_().m_188503_(12) - 6;
                BlockPos pos = new BlockPos(x, y, z);
                for (BlockPos listPos : list) {
                    if (listPos == pos) continue;
                    FlamePillar pillar = new FlamePillar(world, user, 1.5f, i * 2, DamagingWarmupEntityEvents.SPAWN_FIRE);
                    pillar.m_36781_(ConfigConstructor.empowered_dawnbreaker_ability_damage + (float)(WeaponUtil.getEnchantDamageBonus(stack) * 2));
                    pillar.m_20343_(x, y, z);
                    world.m_7967_((Entity)pillar);
                    ++i;
                }
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private EmpoweredDawnbreakerRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new EmpoweredDawnbreakerRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (!player.m_36335_().m_41519_((Item)this)) {
            AbstractDawnbreaker.dawnbreakerEvent((LivingEntity)player, (LivingEntity)player, stack);
            player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VEIL_OF_FIRE.get(), 200, Mth.m_14143_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f))));
            this.applyItemCooldown(player, this.getScaledCooldown(stack));
        }
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, Player player) {
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_empowered_dawnbreaker;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_empowered_dawnbreaker;
    }
}

