/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.staff;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;

public class ChungusStaff
extends ModdedSword
implements IKeybindAbility {
    public ChungusStaff(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.chungus_staff_damage, ConfigConstructor.chungus_staff_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.CHUNGUS_INFUSED);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!this.isDisabled(stack) && entity.f_19797_ % 100 == 0 && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.CHUNGUS_TONIC_EFFECT.get(), 120, 0, true, false));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (this.isDisabled(stack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        PrimedTnt tnt = (PrimedTnt)((EntityType)EntityRegistry.CHUNGUS_HEAD.get()).m_20615_(world);
        assert (tnt != null);
        tnt.m_20343_(user.m_20185_(), user.m_20188_() - (double)0.4f, user.m_20189_());
        tnt.f_19794_ = true;
        Vec3 look = user.m_20252_(1.0f);
        double speed = 1.5;
        tnt.m_20334_(look.f_82479_ * speed, look.f_82480_ * speed, look.f_82481_ * speed);
        tnt.m_146926_(user.m_146909_());
        tnt.m_146922_(user.m_146908_());
        tnt.m_32085_((int)ConfigConstructor.chungus_staff_ticks_before_explosion);
        tnt.m_20242_(true);
        world.m_7967_((Entity)tnt);
        user.m_36335_().m_41524_((Item)this, (int)ConfigConstructor.chungus_staff_use_cooldown);
        stack.m_41622_(3, (LivingEntity)user, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_chungus_staff;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_chungus_staff;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.chungus_staff_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.chungus_staff_enchant_reduces_cooldown_ids;
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (this.isDisabled(stack)) {
            this.notifyDisabled((LivingEntity)player);
            return;
        }
        if (player.m_21023_((MobEffect)EffectRegistry.COOLDOWN.get())) {
            this.notifyCooldown((LivingEntity)player);
            return;
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 1200, 2));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1200, 2));
        if (!player.m_7500_()) {
            stack.m_41622_(3, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(player.m_7655_()));
            this.applyEffectCooldown(player, (int)(ConfigConstructor.chungus_staff_ability_cooldown - (float)(this.getReduceCooldownEnchantLevel(stack) * 160)));
        }
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, Player player) {
        if (this.isDisabled(stack) || player.m_21023_((MobEffect)EffectRegistry.COOLDOWN.get())) {
            return;
        }
        player.m_5496_(SoundEvents.f_11887_, 1.0f, 1.0f);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.m_41777_();
    }
}

