/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.gun;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.gun.GunItem;
import net.soulsweaponry.registry.EnchantRegistry;

public class HunterPistol
extends GunItem {
    public HunterPistol(Item.Properties settings) {
        super(settings);
    }

    @Override
    public int getPostureLoss(ItemStack stack) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.VISCERAL, (ItemStack)stack);
        return (int)(ConfigConstructor.hunter_pistol_posture_loss + (float)lvl * ConfigConstructor.hunter_pistol_posture_loss_per_enchant_level);
    }

    @Override
    public float getBulletDamage(ItemStack stack) {
        return ConfigConstructor.hunter_pistol_damage;
    }

    @Override
    public float getBulletVelocity(ItemStack stack) {
        return ConfigConstructor.hunter_pistol_velocity;
    }

    @Override
    public float getBulletDivergence(ItemStack stack) {
        return ConfigConstructor.hunter_pistol_divergence;
    }

    @Override
    public int getCooldown(ItemStack stack) {
        return (int)(ConfigConstructor.hunter_pistol_cooldown - (float)this.getReducedCooldown(stack));
    }

    @Override
    public int getBulletsNeeded(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0 ? this.getBulletsNeededWithInfinity(stack) : (int)ConfigConstructor.hunter_pistol_bullets_needed;
    }

    @Override
    public int getBulletsNeededWithInfinity(ItemStack stack) {
        return (int)ConfigConstructor.hunter_pistol_bullets_needed_with_infinity;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_hunter_pistol;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (this.isDisabled(user.m_21120_(hand))) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        ItemStack stack = user.m_21120_(hand);
        ItemStack itemStack = this.canShoot(user, stack);
        if (itemStack != null) {
            this.spawnShotParticles(world, user, 10, 0.1f);
            AbstractArrow entity = this.createSilverBulletEntity(world, (LivingEntity)user, stack);
            world.m_7967_((Entity)entity);
            this.postShot(world, user, stack);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_hunter_pistol;
    }
}

