/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.bow;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.projectile_damage.api.IProjectileWeapon;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.arrow.MoonlightArrow;
import net.soulsweaponry.entity.projectile.noclip.ArrowStormEntity;
import net.soulsweaponry.items.ModdedBow;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;

public class DarkmoonLongbow
extends ModdedBow
implements IKeybindAbility {
    public DarkmoonLongbow(Item.Properties settings) {
        super(settings);
        this.addTooltipAbility(TooltipAbilities.SLOW_PULL, TooltipAbilities.MOONLIGHT_ARROW, TooltipAbilities.ARROW_STORM);
        ((IProjectileWeapon)this).setProjectileDamage((double)ConfigConstructor.darkmoon_longbow_damage);
        ((IProjectileWeapon)this).setCustomLaunchVelocity(Double.valueOf(ConfigConstructor.darkmoon_longbow_max_velocity));
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_darkmoon_longbow;
    }

    @Override
    public AbstractArrow getModifiedProjectile(Level world, ItemStack bowStack, ItemStack arrowStack, LivingEntity shooter, AbstractArrow originalArrow) {
        MoonlightArrow projectile = new MoonlightArrow(world, shooter);
        projectile.m_36767_((byte)4);
        projectile.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        return projectile;
    }

    @Override
    public int getPullTime() {
        return (int)ConfigConstructor.darkmoon_longbow_pull_time_ticks;
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (!player.m_36335_().m_41519_((Item)this)) {
            world.m_5594_(null, player.m_20183_(), SoundEvents.f_12616_, SoundSource.PLAYERS, 1.0f, 1.0f);
            ArrowStormEntity entity = new ArrowStormEntity((EntityType<? extends ArrowStormEntity>)((EntityType)EntityRegistry.ARROW_STORM_ENTITY.get()), (Level)world);
            entity.m_20343_(player.m_20185_(), player.m_20186_() + 4.5, player.m_20189_());
            entity.m_37251_((Entity)player, 0.0f, player.m_146908_(), 0.0f, 1.0f, 1.0f);
            entity.m_5602_((Entity)player);
            double power = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
            entity.m_36781_(ConfigConstructor.darkmoon_longbow_ability_damage / (double)2.6f + power * 1.25);
            entity.setMaxArrowAge(40);
            world.m_7967_((Entity)entity);
            this.applyItemCooldown(player, (int)Math.max(ConfigConstructor.darkmoon_longbow_ability_min_cooldown_ticks, ConfigConstructor.darkmoon_longbow_ability_cooldown_ticks - (float)(this.getReduceCooldownEnchantLevel(stack) * 30)));
            stack.m_41622_(3, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(player.m_7655_()));
        }
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, Player player) {
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_darkmoon_longbow;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.darkmoon_longbow_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.darkmoon_longbow_enchant_reduces_cooldown_ids;
    }
}

