/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.soulsweaponry.entitydata.UmbralTrespassData;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.TooltipAbilities;

public abstract class UmbralTrespassItem
extends ModdedSword {
    private final int ticksBeforeDismount;

    public UmbralTrespassItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings, int ticksBeforeDismount) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
        this.ticksBeforeDismount = ticksBeforeDismount;
        this.addTooltipAbility(TooltipAbilities.UMBRAL_TRESPASS);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        LivingEntity target;
        ItemStack stack = user.m_21120_(hand);
        if (this.isDisabled(stack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (user.m_21023_((MobEffect)EffectRegistry.COOLDOWN.get())) {
            this.notifyCooldown((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (user.m_21214_() != null && user.m_20280_((Entity)user.m_21214_()) < 200.0 && !world.f_46443_ && user.m_7998_((Entity)(target = user.m_21214_()), true)) {
            if (!UmbralTrespassData.shouldDamageRiding((LivingEntity)user)) {
                UmbralTrespassData.setShouldDamageRiding((LivingEntity)user, true);
                UmbralTrespassData.setOtherStats((LivingEntity)user, this.getAbilityDamage() + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)target.m_6336_()), this.getAbilityCooldown(stack), this.shouldAbilityHeal());
                user.m_7292_(new MobEffectInstance(MobEffects.f_19609_, this.ticksBeforeDismount, 0));
                user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.GHOSTLY.get(), this.ticksBeforeDismount, 0));
            }
            world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.UMBRAL_TRESPASS_EVENT.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
            ParticleHandler.particleOutburstMap(world, 150, user.m_20185_(), user.m_20188_(), user.m_20189_(), ParticleEvents.SOUL_FLAME_SMALL_OUTBURST_MAP, 1.0f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public abstract float getAbilityDamage();

    public abstract int getAbilityCooldown(ItemStack var1);

    public abstract boolean shouldAbilityHeal();
}

