/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.ArrayList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ModdedItem;
import net.soulsweaponry.items.sword.Skofnung;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.TooltipAbilities;

public class SkofnungStone
extends ModdedItem {
    public SkofnungStone(Item.Properties settings) {
        super(settings);
        this.addTooltipAbility(TooltipAbilities.DISABLE_DEBUFS);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stoneStack = user.m_21120_(hand);
        if (this.isDisabled(stoneStack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)stoneStack);
        }
        boolean shouldDamage = false;
        for (InteractionHand offHand : InteractionHand.values()) {
            ItemStack swordStack = user.m_21120_(offHand);
            if (!(swordStack.m_41720_() instanceof Skofnung)) continue;
            swordStack.m_41784_().m_128405_("empowered_attacks_left", (int)ConfigConstructor.skofnung_stone_additional_empowered_strikes);
            shouldDamage = true;
            world.m_5594_(user, user.m_20183_(), (SoundEvent)SoundRegistry.SHARPEN_EVENT.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            world.m_5594_(user, user.m_20183_(), SoundEvents.f_11894_, SoundSource.PLAYERS, 0.5f, 0.5f);
        }
        ArrayList<MobEffect> effects = new ArrayList<MobEffect>();
        for (MobEffectInstance effectInstance : user.m_21220_()) {
            if (!effectInstance.m_19544_().m_19483_().equals((Object)MobEffectCategory.HARMFUL)) continue;
            effects.add(effectInstance.m_19544_());
            shouldDamage = true;
        }
        effects.forEach(arg_0 -> ((Player)user).m_21195_(arg_0));
        if (shouldDamage) {
            world.m_5594_(user, user.m_20183_(), (SoundEvent)SoundRegistry.RESTORE_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            stoneStack.m_41622_(1, (LivingEntity)user, e -> e.m_21190_(hand));
            return InteractionResultHolder.m_19090_((Object)user.m_21120_(hand));
        }
        return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
    }

    @Override
    public boolean m_41475_() {
        return false;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_skofnung_stone;
    }
}

