/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.events;

import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import net.soulsweaponry.SoulsWeaponry;
import net.soulsweaponry.entity.mobs.AccursedLordBoss;
import net.soulsweaponry.entity.mobs.BigChungus;
import net.soulsweaponry.entity.mobs.ChaosMonarch;
import net.soulsweaponry.entity.mobs.DarkSorcerer;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.entity.mobs.DraugrBoss;
import net.soulsweaponry.entity.mobs.EvilForlorn;
import net.soulsweaponry.entity.mobs.Forlorn;
import net.soulsweaponry.entity.mobs.FreyrSwordEntity;
import net.soulsweaponry.entity.mobs.FrostGiant;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.mobs.NightShade;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.mobs.ReturningKnight;
import net.soulsweaponry.entity.mobs.RimeSpectre;
import net.soulsweaponry.entity.mobs.SoulReaperGhost;
import net.soulsweaponry.entity.mobs.Soulmass;
import net.soulsweaponry.entity.mobs.WarmthEntity;
import net.soulsweaponry.entity.mobs.WitheredDemon;
import net.soulsweaponry.entity.projectile.NightsEdge;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.registry.AttributeRegistry;
import net.soulsweaponry.registry.EntityRegistry;

@Mod.EventBusSubscriber(modid="soulsweapons", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBusEvents {
    @SubscribeEvent
    public static void onEntityAttributeModification(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)AttributeRegistry.POSTURE_BUILDUP_RESISTANCE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributeRegistry.BASE_POSTURE_INCREASE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributeRegistry.BLEED_BUILDUP_RESISTANCE.get());
        event.add(EntityType.f_20532_, (Attribute)AttributeRegistry.BLEED_DAMAGE_RESISTANCE.get());
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)EntityRegistry.WITHERED_DEMON.get(), WitheredDemon.createDemonAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.ACCURSED_LORD_BOSS.get(), AccursedLordBoss.createDemonAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.DRAUGR_BOSS.get(), DraugrBoss.createBossAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.NIGHT_SHADE.get(), NightShade.createBossAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.RETURNING_KNIGHT.get(), ReturningKnight.createBossAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.BIG_CHUNGUS.get(), BigChungus.createChungusAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.REMNANT.get(), Remnant.createRemnantAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.DARK_SORCERER.get(), DarkSorcerer.createSorcererAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.SOUL_REAPER_GHOST.get(), SoulReaperGhost.createGhostAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.FORLORN.get(), Forlorn.createForlornAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.EVIL_FORLORN.get(), EvilForlorn.createForlornAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.SOULMASS.get(), Soulmass.createSoulmassAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.CHAOS_MONARCH.get(), ChaosMonarch.createBossAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.FREYR_SWORD_ENTITY_TYPE.get(), FreyrSwordEntity.createEntityAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.MOONKNIGHT.get(), Moonknight.createBossAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.FROST_GIANT.get(), FrostGiant.createGiantAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.RIME_SPECTRE.get(), RimeSpectre.createSpectreAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.DAY_STALKER.get(), DayStalker.createBossAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.NIGHT_PROWLER.get(), NightProwler.createBossAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.WARMTH_ENTITY.get(), WarmthEntity.createEntityAttributes().m_22265_());
        event.put((EntityType)EntityRegistry.NIGHTS_EDGE.get(), NightsEdge.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void addBuiltinPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            IModFileInfo modFileInfo = ModList.get().getModFileById("soulsweapons");
            if (modFileInfo == null) {
                SoulsWeaponry.LOGGER.error("Could not find mod file for {}", (Object)"soulsweapons");
                return;
            }
            IModFile modFile = modFileInfo.getFile();
            ModBusEvents.addBuiltin(event, "builtin/2d_weapons", (Component)Component.m_237113_((String)"2D Weapon Models"), modFile.findResource(new String[]{"resourcepacks/2d_weapons"}));
            ModBusEvents.addBuiltin(event, "builtin/legacy_2d", (Component)Component.m_237113_((String)"Legacy 2D Models"), modFile.findResource(new String[]{"resourcepacks/legacy_2d"}));
            ModBusEvents.addBuiltin(event, "builtin/legacy_3d", (Component)Component.m_237113_((String)"Legacy 3D Models"), modFile.findResource(new String[]{"resourcepacks/legacy_3d"}));
            ModBusEvents.addBuiltin(event, "builtin/fresh_animations_compat", (Component)Component.m_237113_((String)"Fresh Animations Compat."), modFile.findResource(new String[]{"resourcepacks/fresh_animations_compat"}));
            ModBusEvents.addBuiltin(event, "builtin/enhanced_gow", (Component)Component.m_237113_((String)"Szombie's 3D GOW Weapons"), modFile.findResource(new String[]{"resourcepacks/enhanced_gow"}));
        }
    }

    private static void addBuiltin(AddPackFindersEvent event, String id, Component displayName, Path path) {
        Pack pack = Pack.m_245429_((String)id, (Component)displayName, (boolean)false, name -> new PathPackResources(name, true, path), (PackType)event.getPackType(), (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
        if (pack != null) {
            event.addRepositorySource(consumer -> consumer.accept(pack));
        } else {
            SoulsWeaponry.LOGGER.warn("Failed to create builtin resource pack '{}' from path {}", (Object)id, (Object)path);
        }
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ModMessages.register());
    }
}

