/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.ShouldDamageRidingSyncS2C;
import net.soulsweaponry.networking.packets.S2C.UTDamageCooldownSyncS2C;

public class UmbralTrespassData {
    public static final String DAMAGE_RIDING_ID = "should_damage_riding";
    public static final String UMBRAL_DAMAGE_ID = "umbral_trespass_damage";
    public static final String COOLDOWN_ID = "umbral_trespass_cooldown";
    public static final String HEAL_ID = "umbral_trespass_should_heal";

    public static boolean shouldDamageRiding(LivingEntity entity) {
        if (!entity.getPersistentData().m_128441_(DAMAGE_RIDING_ID)) {
            entity.getPersistentData().m_128379_(DAMAGE_RIDING_ID, false);
        }
        return entity.getPersistentData().m_128471_(DAMAGE_RIDING_ID);
    }

    public static void setShouldDamageRiding(LivingEntity entity, boolean bl) {
        CompoundTag nbt = entity.getPersistentData();
        nbt.m_128379_(DAMAGE_RIDING_ID, bl);
        if (entity instanceof ServerPlayer) {
            UmbralTrespassData.syncDamageRidingData(bl, (ServerPlayer)entity);
        }
    }

    public static void setOtherStats(LivingEntity entity, float damage, int cooldown, boolean shouldHeal) {
        CompoundTag nbt = entity.getPersistentData();
        nbt.m_128350_(UMBRAL_DAMAGE_ID, damage);
        nbt.m_128405_(COOLDOWN_ID, cooldown);
        nbt.m_128379_(HEAL_ID, shouldHeal);
        if (entity instanceof ServerPlayer) {
            UmbralTrespassData.syncOtherStats(damage, cooldown, shouldHeal, (ServerPlayer)entity);
        }
    }

    public static float getAbilityDamage(LivingEntity entity) {
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_(UMBRAL_DAMAGE_ID)) {
            nbt.m_128350_(UMBRAL_DAMAGE_ID, 20.0f);
        }
        return nbt.m_128457_(UMBRAL_DAMAGE_ID);
    }

    public static int getAbilityCooldown(LivingEntity entity) {
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_(COOLDOWN_ID)) {
            nbt.m_128405_(COOLDOWN_ID, 350);
        }
        return nbt.m_128451_(COOLDOWN_ID);
    }

    public static boolean shouldAbilityHeal(LivingEntity entity) {
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_(HEAL_ID)) {
            nbt.m_128379_(HEAL_ID, false);
        }
        return nbt.m_128471_(HEAL_ID);
    }

    public static void syncDamageRidingData(boolean bl, ServerPlayer entity) {
        ModMessages.sendToPlayer(new ShouldDamageRidingSyncS2C(bl), entity);
    }

    public static void syncOtherStats(float damage, int cooldown, boolean shouldHeal, ServerPlayer entity) {
        ModMessages.sendToPlayer(new UTDamageCooldownSyncS2C(damage, cooldown, shouldHeal), entity);
    }
}

