/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.soulsweaponry.api.entitystats.EntityPosture;
import net.soulsweaponry.entitydata.PostureData;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.TargetPostureSyncS2C;

public class TargetPostureData {
    public static final String POSTURE_ID = "target_posture";
    public static final String MAX_POSTURE_ID = "target_max_posture";
    public static final String NAME_ID = "target_name";

    public static int getTargetPosture(LivingEntity target) {
        if (!target.getPersistentData().m_128441_(POSTURE_ID)) {
            target.getPersistentData().m_128405_(POSTURE_ID, 0);
        }
        return target.getPersistentData().m_128451_(POSTURE_ID);
    }

    public static String getTargetName(LivingEntity target) {
        if (!target.getPersistentData().m_128441_(NAME_ID)) {
            target.getPersistentData().m_128359_(NAME_ID, "");
        }
        return target.getPersistentData().m_128461_(NAME_ID);
    }

    public static int getTargetsMaxPosture(LivingEntity target) {
        if (!target.getPersistentData().m_128441_(MAX_POSTURE_ID)) {
            target.getPersistentData().m_128405_(MAX_POSTURE_ID, 200);
        }
        return target.getPersistentData().m_128451_(MAX_POSTURE_ID);
    }

    public static void updateTargetPosture(LivingEntity mainEntity, LivingEntity target) {
        CompoundTag nbt = mainEntity.getPersistentData();
        int amount = PostureData.getPosture(target);
        String name = target.m_7755_().getString();
        int max = EntityPosture.getMaxPostureLoss(target);
        nbt.m_128405_(POSTURE_ID, amount);
        nbt.m_128359_(NAME_ID, name);
        nbt.m_128405_(MAX_POSTURE_ID, max);
        if (mainEntity instanceof ServerPlayer) {
            TargetPostureData.syncData(amount, name, max, (ServerPlayer)mainEntity);
        }
    }

    public static void resetValues(LivingEntity mainEntity) {
        CompoundTag nbt = mainEntity.getPersistentData();
        nbt.m_128405_(POSTURE_ID, 0);
        nbt.m_128359_(NAME_ID, "");
        nbt.m_128405_(MAX_POSTURE_ID, 200);
        if (mainEntity instanceof ServerPlayer) {
            TargetPostureData.syncData(0, "", 200, (ServerPlayer)mainEntity);
        }
    }

    public static void syncData(int data, String name, int maxPosture, ServerPlayer entity) {
        ModMessages.sendToPlayer(new TargetPostureSyncS2C(data, name, maxPosture), entity);
    }
}

