/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.soulsweaponry.api.entitystats.EntityBleed;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.BleedSyncS2C;

public class BleedData {
    public static final String BLEED_ID = "bleed";

    public static int addBleed(LivingEntity entity, int amount) {
        int value;
        if (EntityBleed.isBleedDisabled(entity) || entity.m_21224_() || entity.m_9236_().f_46443_) {
            return 0;
        }
        int newAmount = EntityBleed.getBleedBuildup(entity, amount);
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_(BLEED_ID)) {
            nbt.m_128405_(BLEED_ID, 0);
        }
        value = (value = nbt.m_128451_(BLEED_ID)) < 0 ? 0 : (value += newAmount);
        nbt.m_128405_(BLEED_ID, value);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            BleedData.syncData(value, serverPlayer);
        }
        return value;
    }

    public static int getBleed(LivingEntity target) {
        if (!target.getPersistentData().m_128441_(BLEED_ID)) {
            target.getPersistentData().m_128405_(BLEED_ID, 0);
        }
        return target.getPersistentData().m_128451_(BLEED_ID);
    }

    public static int reduceBleed(LivingEntity entity, int amount) {
        return BleedData.addBleed(entity, -amount);
    }

    public static int setBleed(LivingEntity entity, int amount) {
        CompoundTag nbt = entity.getPersistentData();
        nbt.m_128405_(BLEED_ID, amount);
        if (entity instanceof ServerPlayer) {
            BleedData.syncData(amount, (ServerPlayer)entity);
        }
        return amount;
    }

    public static void syncData(int data, ServerPlayer entity) {
        ModMessages.sendToPlayer(new BleedSyncS2C(data), entity);
    }
}

