/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.noclip;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.entity.projectile.noclip.DamagingWarmupEntityEvents;
import net.soulsweaponry.entity.projectile.noclip.NoClipWarmupEntity;

public abstract class DamagingWarmupEntity
extends NoClipWarmupEntity {
    private boolean startedAttack;
    private int ticksLeft = 20;
    private static final EntityDataAccessor<Boolean> EMERGE = SynchedEntityData.m_135353_(DamagingWarmupEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> PARTICLE_MOD = SynchedEntityData.m_135353_(DamagingWarmupEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> EVENT_ID = SynchedEntityData.m_135353_(DamagingWarmupEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private DamagingWarmupEntityEvents.OtherAttributes otherAttributes = new DamagingWarmupEntityEvents.OtherAttributes();

    public DamagingWarmupEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.ticksLeft = this.getMaxTicks();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.reduceWarmup(1);
            if (this.getWarmup() < 0) {
                if (this.getWarmup() == -7) {
                    this.setEmerge(true);
                    List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.2));
                    for (LivingEntity livingEntity : list) {
                        boolean wasHit;
                        if (!livingEntity.m_6084_() || livingEntity.m_20147_() || this.m_19749_() != null && (livingEntity.m_7307_(this.m_19749_()) || this.m_150171_((Entity)livingEntity))) continue;
                        Entity entity = this.m_19749_();
                        if (entity instanceof LivingEntity) {
                            LivingEntity owner = (LivingEntity)entity;
                            wasHit = livingEntity.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, owner), (float)this.m_36789_() + this.getBonusDamage(livingEntity));
                        } else {
                            wasHit = livingEntity.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, null), (float)this.m_36789_() + this.getBonusDamage(livingEntity));
                        }
                        this.applyDamageEffects(wasHit, livingEntity);
                    }
                    this.onTrigger();
                }
                if (!this.startedAttack) {
                    this.m_9236_().m_7605_((Entity)this, (byte)4);
                    this.startedAttack = true;
                }
                if (--this.ticksLeft < 0) {
                    this.m_146870_();
                }
            }
        }
    }

    public int getMaxTicks() {
        return 20;
    }

    public void m_7822_(byte status) {
        super.m_7822_(status);
        if (status == 4 && !this.m_20067_()) {
            this.handleSoundStatus(status);
        }
    }

    public void setEmerge(boolean bl) {
        this.f_19804_.m_135381_(EMERGE, (Object)bl);
    }

    public boolean getEmerge() {
        return (Boolean)this.f_19804_.m_135370_(EMERGE);
    }

    public void setParticleAmountMod(float particleMod) {
        this.f_19804_.m_135381_(PARTICLE_MOD, (Object)Float.valueOf(particleMod));
    }

    public float getParticleAmountMod() {
        return ((Float)this.f_19804_.m_135370_(PARTICLE_MOD)).floatValue();
    }

    public void setEventId(int eventId) {
        this.f_19804_.m_135381_(EVENT_ID, (Object)eventId);
    }

    public int getEventId() {
        return (Integer)this.f_19804_.m_135370_(EVENT_ID);
    }

    public void setOtherAttributes(DamagingWarmupEntityEvents.OtherAttributes otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public DamagingWarmupEntityEvents.OtherAttributes getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EMERGE, (Object)false);
        this.f_19804_.m_135372_(PARTICLE_MOD, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(EVENT_ID, (Object)-1);
    }

    public abstract void handleSoundStatus(byte var1);

    public abstract void applyDamageEffects(boolean var1, LivingEntity var2);

    public void onTrigger() {
        BiConsumer<DamagingWarmupEntity, DamagingWarmupEntityEvents.OtherAttributes> consumer = DamagingWarmupEntityEvents.EVENTS.get(this.getEventId());
        if (consumer != null) {
            consumer.accept(this, this.otherAttributes);
        }
    }

    public float getBonusDamage(LivingEntity target) {
        return 0.0f;
    }

    public Vec3 getParticleVec() {
        return new Vec3((double)1.2f, (double)0.34f, (double)1.2f);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("ParticleModifier")) {
            this.setParticleAmountMod(nbt.m_128457_("ParticleModifier"));
        }
        if (nbt.m_128441_("EventId")) {
            this.setEventId(nbt.m_128451_("EventId"));
        }
        this.otherAttributes = DamagingWarmupEntityEvents.OtherAttributes.getInstanceFromNbt(nbt);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128350_("ParticleModifier", this.getParticleAmountMod());
        nbt.m_128405_("EventId", this.getEventId());
        this.otherAttributes.writeCustomDataToNbt(nbt);
    }
}

