/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.AreaEffectSphere;
import net.soulsweaponry.entity.projectile.NonArrowProjectile;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NightSkull
extends NonArrowProjectile
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public NightSkull(EntityType<? extends NightSkull> entityType, Level world) {
        super(entityType, world);
        this.m_36781_(10.0);
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.DECAY.get(), 60, 0));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 80, 0));
        }
        this.detonate();
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.detonate();
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)SoundRegistry.NIGHT_SKULL_DIE.get();
    }

    protected boolean m_5603_(Entity entity) {
        if (entity instanceof Projectile || this.m_150171_(entity)) {
            return false;
        }
        return super.m_5603_(entity);
    }

    public boolean m_142038_() {
        return ConfigConstructor.night_prowler_eclipse_skulls_glow;
    }

    private void detonate() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, false, Level.ExplosionInteraction.MOB);
            List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(4.0, 2.0, 4.0));
            AreaEffectSphere areaEffectCloudEntity = new AreaEffectSphere(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                areaEffectCloudEntity.setOwner((LivingEntity)entity);
            }
            areaEffectCloudEntity.setParticleAmountModifier(2.0f);
            areaEffectCloudEntity.setParticleType((ParticleOptions)ParticleRegistry.DARK_STAR.get());
            areaEffectCloudEntity.setRadius(0.5f);
            areaEffectCloudEntity.setDuration(80);
            areaEffectCloudEntity.setRadiusGrowth((2.5f - areaEffectCloudEntity.getRadius()) / (float)areaEffectCloudEntity.getDuration());
            areaEffectCloudEntity.addEffect(new MobEffectInstance((MobEffect)EffectRegistry.DECAY.get(), 60, 0));
            areaEffectCloudEntity.addEffect(new MobEffectInstance(MobEffects.f_19615_, 80, 0));
            if (!list.isEmpty()) {
                for (LivingEntity livingEntity : list) {
                    double d = this.m_20280_((Entity)livingEntity);
                    if (!(d < 16.0)) continue;
                    areaEffectCloudEntity.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
                    break;
                }
            }
            this.m_9236_().m_7967_((Entity)areaEffectCloudEntity);
            this.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 100) {
            this.detonate();
        }
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    private PlayState idle(AnimationState<?> state) {
        state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idle)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected ItemStack m_7941_() {
        return Items.f_42679_.m_7968_();
    }
}

