/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.MjolnirProjectile;
import net.soulsweaponry.entity.projectile.ReturningProjectile;
import net.soulsweaponry.items.axe.LeviathanAxe;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class LeviathanAxeEntity
extends ReturningProjectile
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public LeviathanAxeEntity(EntityType<? extends LeviathanAxeEntity> entityType, Level world) {
        super(entityType, world);
        this.setItemStack(new ItemStack((ItemLike)WeaponRegistry.LEVIATHAN_AXE.get()));
    }

    public LeviathanAxeEntity(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.LEVIATHAN_AXE_ENTITY_TYPE.get()), owner, world, stack);
    }

    @Override
    public float getDamage(Entity target) {
        return ConfigConstructor.leviathan_axe_projectile_damage + (float)WeaponUtil.getEnchantDamageBonus(this.m_7941_());
    }

    @Override
    public boolean collide(Entity owner, Entity target, float damage) {
        DamageSource damageSource;
        boolean damaged;
        if (!this.m_9236_().f_46443_ && target instanceof MjolnirProjectile) {
            ParticleEvents.mjolnirLeviathanAxeCollision(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_9236_().m_255391_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f, true, Level.ExplosionInteraction.TNT);
        }
        if (damaged = target.m_6469_(damageSource = this.m_9236_().m_269111_().m_269525_((Entity)this, owner), damage)) {
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                living.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZING.get(), 200, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)this.m_7941_())));
            }
            LeviathanAxe.iceExplosion(this.m_9236_(), this.m_20183_(), this.m_19749_(), EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)this.m_7941_()));
        }
        return damaged;
    }

    @Override
    public double getReturnSpeed(ItemStack stack) {
        return ConfigConstructor.leviathan_axe_return_speed + (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)stack) / 2.0;
    }

    protected boolean m_5603_(Entity entity) {
        if (entity instanceof MjolnirProjectile) {
            return true;
        }
        return super.m_5603_(entity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

