/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.entity.AreaEffectSphere;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.projectile.UntargetableFireball;
import net.soulsweaponry.entitydata.ParryData;
import net.soulsweaponry.registry.EntityRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GrowingFireball
extends UntargetableFireball
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int maxAge = 126;
    private boolean hasChangedCourse;
    private static final EntityDataAccessor<Optional<UUID>> TARGET_UUID = SynchedEntityData.m_135353_(GrowingFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(GrowingFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float radiusGrowth;

    public GrowingFireball(EntityType<? extends GrowingFireball> entityType, Level world) {
        super(entityType, world);
    }

    public GrowingFireball(Level world, Entity owner) {
        super((EntityType<? extends LargeFireball>)((EntityType)EntityRegistry.GROWING_FIREBALL_ENTITY.get()), world);
        this.m_5602_(owner);
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && !(entity instanceof DayStalker) && !(entity instanceof NightProwler);
    }

    public void m_8119_() {
        Entity target;
        super.m_8119_();
        float radius = this.getRadius();
        if (this.m_9236_().f_46443_ && this.f_19796_.m_188499_()) {
            int points = Mth.m_14143_((float)(this.getRadius() * 4.0f));
            AreaEffectSphere.randomParticleBox(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)(this.getRadius() / 2.0f), this.m_20189_(), points, this.getRadius() * 0.5f, (ParticleOptions)ParticleTypes.f_123744_, this.f_19796_);
        }
        if (this.radiusGrowth != 0.0f) {
            if ((radius += this.radiusGrowth) < 0.5f) {
                this.m_146870_();
                return;
            }
            this.setRadius(radius);
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ >= this.getMaxAge() && !this.hasChangedCourse && (target = this.getSavedTarget((ServerLevel)this.m_9236_())) != null) {
            double f = target.m_20185_() - this.m_20185_();
            double g = target.m_20227_(0.5) - this.m_20227_(0.5);
            double h = target.m_20189_() - this.m_20189_();
            this.m_6686_(f, g, h, 1.0f, 1.0f);
            this.hasChangedCourse = true;
        }
        if (this.f_19797_ >= this.getMaxAge() * 3) {
            this.detonate();
        }
        if (!(this.m_19749_() instanceof DayStalker) && !this.m_9236_().f_46443_) {
            for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_())) {
                if (this.m_150171_(entity) || !(entity instanceof LivingEntity)) continue;
                this.detonate();
            }
        }
    }

    public float getExplosionPower() {
        return 1.0f + this.getRadius();
    }

    protected float m_6884_() {
        return 1.0f;
    }

    protected void m_6532_(HitResult hitResult) {
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            Player player;
            Entity entity = ((EntityHitResult)hitResult).m_82443_();
            if (entity instanceof Player && ParryData.successfulParry(player = (Player)entity, false, this.m_269291_().m_269036_((Entity)this, this.m_19749_())) && !this.m_9236_().f_46443_) {
                Vec3 vec3d = player.m_20154_();
                this.m_20256_(vec3d);
                this.f_36813_ = vec3d.f_82479_ * 0.1;
                this.f_36814_ = vec3d.f_82480_ * 0.1;
                this.f_36815_ = vec3d.f_82481_ * 0.1;
                this.m_5602_((Entity)player);
                return;
            }
            this.m_5790_((EntityHitResult)hitResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        } else if (type == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            this.m_8060_(blockHitResult);
            BlockPos blockPos = blockHitResult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockPos)));
        }
        this.detonate();
    }

    private void detonate() {
        if (!this.m_9236_().f_46443_) {
            boolean bl = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getExplosionPower(), bl, Level.ExplosionInteraction.MOB);
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_UUID, Optional.empty());
        this.m_20088_().m_135372_(RADIUS, (Object)Float.valueOf(0.5f));
    }

    public void setRadius(float radius) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double e = this.m_20186_();
        double f = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, e, f);
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public void setTargetUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(TARGET_UUID, Optional.ofNullable(uuid));
    }

    public UUID getTargetUuid() {
        return ((Optional)this.f_19804_.m_135370_(TARGET_UUID)).orElse(null);
    }

    @Nullable
    public Entity getSavedTarget(ServerLevel world) {
        return world.m_8791_(this.getTargetUuid());
    }

    public void setMaxAge(int age) {
        this.maxAge = age;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setRadiusGrowth(float radiusGrowth) {
        this.radiusGrowth = radiusGrowth;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("MaxAge", this.getMaxAge());
        if (this.getTargetUuid() != null) {
            nbt.m_128362_("TargetUuid", this.getTargetUuid());
        }
        nbt.m_128379_("ChangedCourse", this.hasChangedCourse);
        nbt.m_128350_("RadiusPerTick", this.radiusGrowth);
        nbt.m_128350_("Radius", this.getRadius());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("MaxAge")) {
            this.setMaxAge(nbt.m_128451_("MaxAge"));
        }
        UUID uUID = null;
        if (nbt.m_128403_("TargetUuid")) {
            uUID = nbt.m_128342_("TargetUuid");
        }
        if (uUID != null) {
            try {
                this.setTargetUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (nbt.m_128441_("ChangedCourse")) {
            this.hasChangedCourse = nbt.m_128471_("ChangedCourse");
        }
        if (nbt.m_128441_("RadiusPerTick")) {
            this.radiusGrowth = nbt.m_128457_("RadiusPerTick");
        }
        if (nbt.m_128441_("Radius")) {
            this.setRadius(nbt.m_128457_("Radius"));
        }
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("spin2", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

