/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.ModPersistentProjectile;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DraupnirSpearEntity
extends ModPersistentProjectile
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean dealtDamage;

    public DraupnirSpearEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.setItemStack(new ItemStack((ItemLike)WeaponRegistry.DRAUPNIR_SPEAR.get()));
    }

    public DraupnirSpearEntity(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.DRAUPNIR_SPEAR_TYPE.get()), owner, world);
        this.setItemStack(stack.m_41777_());
    }

    public void detonate() {
        if (this.m_19749_() != null && this.m_20183_() != null && !this.m_9236_().f_46443_) {
            float power = ConfigConstructor.draupnir_spear_detonate_power + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)this.m_7941_()) / 2.5f;
            this.m_9236_().m_255391_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), power, false, Level.ExplosionInteraction.NONE);
            if (power > 2.0f) {
                for (Entity entity : this.m_9236_().m_45933_(this.m_19749_(), this.m_20191_().m_82400_((double)power))) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, Mth.m_14143_((float)(power - 2.0f))));
                }
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        float f = ConfigConstructor.draupnir_spear_projectile_damage;
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_7941_(), (MobType)livingEntity.m_6336_());
        }
        Entity entity2 = this.m_19749_();
        DamageSource damageSource = this.m_9236_().m_269111_().m_269390_((Entity)this, entity2);
        this.dealtDamage = true;
        SoundEvent soundEvent = SoundEvents.f_12514_;
        if (entity.m_6469_(damageSource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                if (entity2 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity2, (Entity)entity2);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity2), (Entity)livingEntity2);
                }
                this.m_7761_(livingEntity2);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float g = 1.0f;
        this.m_5496_(soundEvent, g, 1.0f);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if ((float)this.f_19797_ > ConfigConstructor.draupnir_spear_max_age) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_8119_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 currentPosition, Vec3 nextPosition) {
        return this.dealtDamage ? null : super.m_6351_(currentPosition, nextPosition);
    }

    protected boolean m_142470_(Player player) {
        return false;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    private PlayState predicate(AnimationState<?> state) {
        state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_5825_() {
        return true;
    }
}

