/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.enchantments;

import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.PostureData;
import net.soulsweaponry.items.IUltraHeavy;

public class StaggerEnchantment
extends Enchantment {
    public StaggerEnchantment(Enchantment.Rarity weight, EquipmentSlot ... slotTypes) {
        super(weight, EnchantmentCategory.WEAPON, slotTypes);
    }

    public int m_6183_(int level) {
        return 10 + level * 10;
    }

    public int m_6586_() {
        return (int)ConfigConstructor.stagger_enchant_max_level;
    }

    public void m_7677_(LivingEntity user, Entity target, int level) {
        LivingEntity living;
        if (!user.m_9236_().f_46443_ && target instanceof LivingEntity && !(living = (LivingEntity)target).m_21224_()) {
            IUltraHeavy heavy;
            int postureLoss = Mth.m_14143_((float)(ConfigConstructor.stagger_enchant_posture_loss_on_player_modifier * ConfigConstructor.stagger_enchant_posture_loss_applied_per_level));
            Item item = user.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            if (item instanceof IUltraHeavy && (heavy = (IUltraHeavy)item).isHeavy()) {
                postureLoss = Mth.m_14143_((float)((float)postureLoss * ConfigConstructor.ultra_heavy_posture_loss_modifier_when_stagger_enchant));
            }
            PostureData.addPostureLoss(living, postureLoss *= level);
        }
        super.m_7677_(user, target, level);
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_41720_() instanceof IUltraHeavy || super.m_6081_(stack);
    }
}

