/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.renderer.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.soulsweaponry.entity.projectile.noclip.FrozenLightning;
import org.joml.Matrix4f;

public class FrozenLightningRenderer
extends EntityRenderer<FrozenLightning> {
    public FrozenLightningRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(FrozenLightning entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        for (long seed : entity.seeds) {
            float[] xCoords = new float[8];
            float[] zCoords = new float[8];
            float currentX = 0.0f;
            float currentZ = 0.0f;
            RandomSource random = RandomSource.m_216335_((long)seed);
            for (int segmentIndex = 7; segmentIndex >= 0; --segmentIndex) {
                xCoords[segmentIndex] = currentX;
                zCoords[segmentIndex] = currentZ;
                currentX += (float)(random.m_188503_(11) - 5);
                currentZ += (float)(random.m_188503_(11) - 5);
            }
            VertexConsumer vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110502_());
            Matrix4f positionMatrix = matrices.m_85850_().m_252922_();
            for (int layer = 0; layer < 4; ++layer) {
                float blue;
                float green;
                float red;
                RandomSource layerRandom = RandomSource.m_216335_((long)seed);
                if (layer >= 2) {
                    red = 0.2f;
                    green = 0.45f;
                    blue = 0.5f;
                } else {
                    red = 0.45f;
                    green = 0.92f;
                    blue = 1.0f;
                }
                for (int branchDepth = 0; branchDepth < 3; ++branchDepth) {
                    int startSegment = 7;
                    int endSegment = 0;
                    if (branchDepth > 0) {
                        startSegment = 7 - branchDepth;
                        endSegment = startSegment - 2;
                    }
                    float prevXOffset = xCoords[startSegment] - currentX;
                    float prevZOffset = zCoords[startSegment] - currentZ;
                    for (int segment = startSegment; segment >= endSegment; --segment) {
                        float currentXOffset = prevXOffset;
                        float currentZOffset = prevZOffset;
                        if (branchDepth == 0) {
                            prevXOffset += (float)(layerRandom.m_188503_(11) - 5);
                            prevZOffset += (float)(layerRandom.m_188503_(11) - 5);
                        } else {
                            prevXOffset += (float)(layerRandom.m_188503_(31) - 15);
                            prevZOffset += (float)(layerRandom.m_188503_(31) - 15);
                        }
                        float thicknessStart = 0.1f + (float)layer * 0.2f;
                        if (branchDepth == 0) {
                            thicknessStart *= (float)segment * 0.1f + 1.0f;
                        }
                        float thicknessEnd = 0.1f + (float)layer * 0.2f;
                        if (branchDepth == 0) {
                            thicknessEnd *= ((float)segment - 1.0f) * 0.1f + 1.0f;
                        }
                        FrozenLightningRenderer.drawBranch(positionMatrix, vertexConsumer, prevXOffset, prevZOffset, segment, currentXOffset, currentZOffset, red, green, blue, thicknessStart, thicknessEnd, false, false, true, false);
                        FrozenLightningRenderer.drawBranch(positionMatrix, vertexConsumer, prevXOffset, prevZOffset, segment, currentXOffset, currentZOffset, red, green, blue, thicknessStart, thicknessEnd, true, false, true, true);
                        FrozenLightningRenderer.drawBranch(positionMatrix, vertexConsumer, prevXOffset, prevZOffset, segment, currentXOffset, currentZOffset, red, green, blue, thicknessStart, thicknessEnd, true, true, false, true);
                        FrozenLightningRenderer.drawBranch(positionMatrix, vertexConsumer, prevXOffset, prevZOffset, segment, currentXOffset, currentZOffset, red, green, blue, thicknessStart, thicknessEnd, false, true, false, false);
                    }
                }
            }
        }
    }

    private static void drawBranch(Matrix4f matrix, VertexConsumer buffer, float x1, float z1, int y, float x2, float z2, float red, float green, float blue, float offset2, float offset1, boolean shiftEast1, boolean shiftSouth1, boolean shiftEast2, boolean shiftSouth2) {
        buffer.m_252986_(matrix, x1 + (shiftEast1 ? offset1 : -offset1), (float)(y * 16), z1 + (shiftSouth1 ? offset1 : -offset1)).m_85950_(red, green, blue, 0.3f).m_5752_();
        buffer.m_252986_(matrix, x2 + (shiftEast1 ? offset2 : -offset2), (float)((y + 1) * 16), z2 + (shiftSouth1 ? offset2 : -offset2)).m_85950_(red, green, blue, 0.3f).m_5752_();
        buffer.m_252986_(matrix, x2 + (shiftEast2 ? offset2 : -offset2), (float)((y + 1) * 16), z2 + (shiftSouth2 ? offset2 : -offset2)).m_85950_(red, green, blue, 0.3f).m_5752_();
        buffer.m_252986_(matrix, x1 + (shiftEast2 ? offset1 : -offset1), (float)(y * 16), z1 + (shiftSouth2 ? offset1 : -offset1)).m_85950_(red, green, blue, 0.3f).m_5752_();
    }

    public ResourceLocation getTexture(FrozenLightning entity) {
        return InventoryMenu.f_39692_;
    }
}

