/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.renderer.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.soulsweaponry.client.model.entity.mobs.MoonknightModel;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import org.joml.Vector3d;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MoonknightRenderer
extends GeoEntityRenderer<Moonknight> {
    int[] rgbColorOne = new int[]{254, 200, 203};
    int[] rgbColorTwo = new int[]{254, 254, 218};
    int[] rgbColorThree = new int[]{106, 73, 156};
    int[] rgbColorFour = new int[]{176, 253, 252};
    double[] translation = new double[]{0.0, 4.0, 0.0};
    public static final ResourceLocation CRYSTAL_BEAM_TEXTURE = new ResourceLocation("soulsweapons", "textures/entity/core_beam.png");
    private static final RenderType CRYSTAL_BEAM_LAYER = RenderType.m_110476_((ResourceLocation)CRYSTAL_BEAM_TEXTURE);
    private int currentTick = -1;
    private static final int FULLBRIGHT_LIGHT = 0xF000F0;

    public MoonknightRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new MoonknightModel());
        this.f_114477_ = 2.5f;
    }

    protected float getDeathMaxRotation(Moonknight entityLivingBaseIn) {
        return 0.0f;
    }

    public boolean shouldRender(Moonknight entity, Frustum frustum, double x, double y, double z) {
        return entity.getCanBeam() || super.m_5523_((Entity)entity, frustum, x, y, z);
    }

    public void render(Moonknight entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        CustomDeathHandler.renderDeathLight((LivingEntity)entity, entityYaw, partialTicks, stack, this.translation, bufferIn, packedLightIn, entity.deathTicks, this.rgbColorOne, this.rgbColorTwo, this.rgbColorThree, this.rgbColorFour);
        BlockPos blockPos = entity.getBeamLocation();
        if (entity.getCanBeam() && blockPos != null && !entity.m_21224_()) {
            float yOffset = 6.0f;
            float exactTarget = Mth.m_14179_((float)partialTicks, (float)entity.prevBeamHeight, (float)entity.getBeamHeight());
            if (exactTarget < entity.renderBeamHeight) {
                entity.renderBeamHeight = exactTarget;
            }
            entity.renderBeamHeight += (exactTarget - entity.renderBeamHeight) * 0.1f;
            float m = (float)blockPos.m_123341_() + 0.5f;
            float n = (float)blockPos.m_123342_() + entity.renderBeamHeight;
            float o = (float)blockPos.m_123343_() + 0.5f;
            float p = (float)((double)m - entity.m_20185_());
            float q = (float)((double)n - entity.m_20186_());
            float r = (float)((double)o - entity.m_20189_());
            stack.m_252880_(p, q, r);
            this.renderCoreBeam(-p, -q + yOffset, -r, partialTicks, entity.f_19797_, stack, bufferIn, packedLightIn);
        }
    }

    private void renderCoreBeam(float dx, float dy, float dz, float tickDelta, int age, PoseStack matrices, MultiBufferSource consumers, int packedLight) {
        MoonknightRenderer.renderBeamRing(dx, dy, dz, tickDelta, age, matrices, consumers, packedLight, 1.0f, 255, 255, 255, 255);
        MoonknightRenderer.renderBeamRing(dx, dy, dz, tickDelta, age, matrices, consumers, packedLight, 0.8f, 200, 200, 255, 200);
        MoonknightRenderer.renderBeamRing(dx, dy, dz, tickDelta, age, matrices, consumers, packedLight, 0.4f, 255, 255, 255, 128);
    }

    private static void renderBeamRing(float dx, float dy, float dz, float tickDelta, int age, PoseStack matrices, MultiBufferSource consumers, int packedLight, float radiusScale, int r, int g, int b, int a) {
        VertexConsumer vb = consumers.m_6299_(CRYSTAL_BEAM_LAYER);
        float xzLen = Mth.m_14116_((float)(dx * dx + dz * dz));
        float vecLen = Mth.m_14116_((float)(dx * dx + dy * dy + dz * dz));
        matrices.m_85836_();
        matrices.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(dz, dx)) - 1.5707964f));
        matrices.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(xzLen, dy)) - 1.5707964f));
        float vMin = 0.0f - ((float)age + tickDelta) * -0.05f;
        float vMax = vecLen / 32.0f - ((float)age + tickDelta) * -0.05f;
        float prevX = 0.0f;
        float prevY = 0.0f;
        float prevU = 0.0f;
        for (int i = 1; i <= 8; ++i) {
            float theta = (float)i * ((float)Math.PI * 2) / 8.0f;
            float cx = Mth.m_14031_((float)theta) * 0.75f * radiusScale;
            float cy = Mth.m_14089_((float)theta) * 0.75f * radiusScale;
            float u = (float)i / 8.0f;
            vb.m_252986_(matrices.m_85850_().m_252922_(), prevX * radiusScale, prevY * radiusScale, 0.0f).m_6122_(r, g, b, a).m_7421_(prevU, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrices.m_85850_().m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
            vb.m_252986_(matrices.m_85850_().m_252922_(), prevX, prevY, vecLen).m_6122_(r, g, b, a).m_7421_(prevU, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrices.m_85850_().m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
            vb.m_252986_(matrices.m_85850_().m_252922_(), cx, cy, vecLen).m_6122_(r, g, b, a).m_7421_(u, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrices.m_85850_().m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
            vb.m_252986_(matrices.m_85850_().m_252922_(), cx * radiusScale, cy * radiusScale, 0.0f).m_6122_(r, g, b, a).m_7421_(u, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrices.m_85850_().m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
            prevX = cx;
            prevY = cy;
            prevU = u;
        }
        matrices.m_85849_();
    }

    public void renderFinal(PoseStack poseStack, Moonknight animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (animatable.isPhaseTwo() && !animatable.m_21224_() && animatable.isSwordCharging() && (this.currentTick < 0 || this.currentTick != animatable.f_19797_)) {
            this.currentTick = animatable.f_19797_;
            this.model.getBone("particle1").ifPresent(sword1 -> this.model.getBone("particle2").ifPresent(sword2 -> {
                RandomSource rand = animatable.m_217043_();
                Vector3d pos1 = sword1.getWorldPosition();
                Vector3d pos2 = sword2.getWorldPosition();
                int segments = 8;
                for (int i = 0; i <= segments; ++i) {
                    double t = (double)i / (double)segments;
                    double interpolatedX = pos1.x() + t * (pos2.x() - pos1.x());
                    double interpolatedY = pos1.y() + t * (pos2.y() - pos1.y());
                    double interpolatedZ = pos1.z() + t * (pos2.z() - pos1.z());
                    for (int j = 0; j < 4; ++j) {
                        animatable.m_20193_().m_7106_((ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get(), interpolatedX, interpolatedY, interpolatedZ, (rand.m_188500_() - 0.5) * 0.25, (rand.m_188500_() - 0.5) * 0.25, (rand.m_188500_() - 0.5) * 0.25);
                    }
                }
            }));
        }
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

