/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.hud;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.soulsweaponry.api.entitystats.EntityPosture;
import net.soulsweaponry.client.entitydata.ClientPostureData;
import net.soulsweaponry.client.hud.EffectHudOverlay;
import net.soulsweaponry.config.ClientConfig;

public class PostureHudOverlay
extends EffectHudOverlay {
    private static final ResourceLocation TEXTURE = new ResourceLocation("soulsweapons", "textures/gui/posture_bars.png");
    public static final PostureHudOverlay INSTANCE = new PostureHudOverlay();
    public static final IGuiOverlay HUD_POSTURE = (gui, drawContext, partialTicks, width, height) -> INSTANCE.render(drawContext, partialTicks);

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public int getBarPixelOffset(LocalPlayer player) {
        int posture = ClientPostureData.getPosture();
        float posturePerPixel = (float)EntityPosture.getMaxPostureLoss((LivingEntity)player) / 182.0f;
        return Mth.m_14143_((float)((float)posture / posturePerPixel));
    }

    @Override
    public boolean shouldShow(LocalPlayer player) {
        int posture = ClientPostureData.getPosture();
        return posture > 0 && !ClientConfig.disable_player_posture_hud;
    }
}

