/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.client.particle;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.utils.EntitySnapshot;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.WearableItemLayer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class AvalonInterpolationEntityAfterImageParticle
extends CustomModelParticle<SkinnedMesh> {
    protected final EntitySnapshot<?> entitySnapshot;
    protected final EntitySnapshot.RenderableFigure entityFigure;
    protected final LivingEntityPatch<?> entitypatch;
    protected final List<EntitySnapshot.RenderableFigure> armorMeshes;
    private final AssetAccessor<? extends DynamicAnimation> animation;
    private final float time;
    private final float timeO;
    private final Vec3 pos;
    private final Vec3 posO;
    protected float alphaO;

    public AvalonInterpolationEntityAfterImageParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, EntitySnapshot<?> entitySnapshot, EntitySnapshot.RenderableFigure entityFigure, LivingEntityPatch<?> entitypatch, List<EntitySnapshot.RenderableFigure> armorMeshes, AssetAccessor<? extends DynamicAnimation> animation, float time, float timeO, Vec3 pos, Vec3 posO) {
        super(level, x, y, z, xd, yd, zd, null);
        this.entityFigure = entityFigure;
        this.entitypatch = entitypatch;
        this.armorMeshes = armorMeshes;
        this.animation = animation;
        this.time = time;
        this.timeO = timeO;
        this.pos = pos;
        this.posO = posO;
        this.f_107225_ = 20;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.alphaO = 0.3f;
        this.f_107230_ = 0.3f;
        this.entitySnapshot = entitySnapshot;
        this.yawO = entitySnapshot.getYRot();
        this.yaw = entitySnapshot.getYRot();
    }

    public void m_5989_() {
        super.m_5989_();
        this.alphaO = this.f_107230_;
        this.f_107230_ = (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_ * 0.8f;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        float alpha = this.alphaO + (this.f_107230_ - this.alphaO) * partialTicks;
        int lightColor = this.m_6355_(partialTicks);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        float step = (this.time - this.timeO) / 20.0f;
        Vec3 posStep = new Vec3(this.pos.m_82546_((Vec3)this.posO).f_82479_ / 20.0, this.pos.m_82546_((Vec3)this.posO).f_82480_ / 20.0, this.pos.m_82546_((Vec3)this.posO).f_82481_ / 20.0);
        Vec3 startPos = this.pos;
        for (float f = this.timeO; f < this.time; f += step) {
            PoseStack poseStack = new PoseStack();
            this.setupPoseStack(poseStack, startPos, camera, partialTicks);
            this.renderTextured(f, poseStack, (MultiBufferSource)buffers, EpicFightRenderTypes::entityAfterimageStencil, Mesh.DrawingFunction.POSITION_TEX, 0, 0.0f, 0.0f, 0.0f, 1.0f);
            buffers.m_173043_();
            this.renderTextured(f, poseStack, (MultiBufferSource)buffers, EpicFightRenderTypes::entityAfterimageTranslucent, Mesh.DrawingFunction.NEW_ENTITY, lightColor, this.f_107227_, this.f_107228_, this.f_107229_, alpha);
            buffers.m_173043_();
            this.revert(poseStack);
            startPos = startPos.m_82549_(posStep);
        }
    }

    protected void setupPoseStack(PoseStack poseStack, Vec3 pos, Camera camera, float partialTicks) {
        poseStack.m_85836_();
        poseStack.m_252931_(RenderSystem.getModelViewStack().m_85850_().m_252922_());
        RenderSystem.getModelViewStack().m_85836_();
        RenderSystem.getModelViewStack().m_166856_();
        RenderSystem.applyModelViewMatrix();
        Vec3 cameraPosition = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)pos.f_82479_, (double)pos.f_82479_) - cameraPosition.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)pos.f_82480_, (double)pos.f_82480_) - cameraPosition.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)pos.f_82481_, (double)pos.f_82481_) - cameraPosition.m_7094_());
        poseStack.m_252880_(x, y, z);
        Quaternionf rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        float roll = Mth.m_14189_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
        float pitch = Mth.m_14189_((float)partialTicks, (float)this.pitchO, (float)this.pitch);
        float yaw = Mth.m_14189_((float)partialTicks, (float)this.yawO, (float)this.yaw);
        rotation.mul((Quaternionfc)QuaternionUtils.YP.rotationDegrees(180.0f - yaw));
        rotation.mul((Quaternionfc)QuaternionUtils.XP.rotationDegrees(pitch));
        rotation.mul((Quaternionfc)QuaternionUtils.ZP.rotationDegrees(roll));
        poseStack.m_252781_(rotation);
        float scale = Mth.m_14179_((float)partialTicks, (float)this.scaleO, (float)this.scale);
        poseStack.m_252880_(0.0f, this.entitySnapshot.getHeightHalf(), 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(0.0f, -this.entitySnapshot.getHeightHalf(), 0.0f);
    }

    protected void revert(PoseStack poseStack) {
        poseStack.m_85849_();
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public void renderTextured(float time, PoseStack poseStack, MultiBufferSource buffers, Function<ResourceLocation, RenderType> rendertypeFunction, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a) {
        if (this.entityFigure.mesh() != null && this.entityFigure.texture() != null) {
            this.entityFigure.mesh().initialize();
            Pose pose = ((DynamicAnimation)this.animation.get()).getRawPose(time);
            this.entityFigure.mesh().draw(poseStack, buffers, rendertypeFunction.apply(this.entityFigure.texture()), drawingFunction, packedLight, r, g, b, a, OverlayTexture.f_118083_, this.entitypatch.getArmature(), this.entitypatch.getArmature().getPoseAsTransformMatrix(pose, false));
            for (EntitySnapshot.RenderableFigure armorFigures : this.armorMeshes) {
                armorFigures.mesh().initialize();
                armorFigures.mesh().draw(poseStack, buffers, rendertypeFunction.apply(armorFigures.texture()), drawingFunction, packedLight, r, g, b, a, OverlayTexture.f_118083_, this.entitypatch.getArmature(), this.entitypatch.getArmature().getPoseAsTransformMatrix(pose, false));
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return EpicFightParticleRenderTypes.ENTITY_PARTICLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EntitySnapshot entitySnapshot;
            Entity entity = level.m_6815_((int)Double.doubleToLongBits(xSpeed));
            LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
            LivingEntityRenderer vanillarenderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((LivingEntity)entitypatch.getOriginal()));
            PatchedEntityRenderer patchedrenderer = ClientEngine.getInstance().renderEngine.getEntityRenderer(entitypatch.getOriginal());
            AssetAccessor meshAccessor = patchedrenderer.getMeshProvider(entitypatch);
            ResourceLocation textureLocation = vanillarenderer.m_5478_((Entity)((LivingEntity)entitypatch.getOriginal()));
            EntitySnapshot.RenderableFigure entityFigure = new EntitySnapshot.RenderableFigure((Mesh)meshAccessor.get(), textureLocation);
            ImmutableList.Builder builder = ImmutableList.builder();
            ((LivingEntity)entitypatch.getOriginal()).m_6168_().forEach(itemstackx -> {
                if (itemstackx.m_41720_() instanceof ArmorItem) {
                    EquipmentSlot armorSlot = itemstackx.getEquipmentSlot();
                    SkinnedMesh armor = WearableItemLayer.getCachedModel((Item)itemstackx.m_41720_());
                    ResourceLocation texture = WearableItemLayer.getArmorResource((Entity)entitypatch.getOriginal(), (ItemStack)itemstackx, (EquipmentSlot)armorSlot, (String)null);
                    if (armor != null) {
                        builder.add((Object)new EntitySnapshot.RenderableFigure((Mesh)armor, texture));
                    }
                }
            });
            if (ClientEngine.getInstance().renderEngine.hasRendererFor(entitypatch.getOriginal()) && (entitySnapshot = entitypatch.captureEntitySnapshot()) != null) {
                return new AvalonInterpolationEntityAfterImageParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, entitySnapshot, entityFigure, entitypatch, (List<EntitySnapshot.RenderableFigure>)builder.build(), (AssetAccessor<? extends DynamicAnimation>)entitypatch.getAnimator().getPlayerFor(null).getAnimation(), entitypatch.getAnimator().getPlayerFor(null).getElapsedTime() + ((DynamicAnimation)entitypatch.getAnimator().getPlayerFor(null).getAnimation().get()).getPlaySpeed(entitypatch, (DynamicAnimation)entitypatch.getAnimator().getPlayerFor(null).getAnimation().get()), entitypatch.getAnimator().getPlayerFor(null).getPrevElapsedTime(), entity.m_20182_().m_82549_(entity.m_20184_()), new Vec3(entity.f_19790_, entity.f_19791_, entity.f_19792_));
            }
            return null;
        }
    }
}

