/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.block;

import com.google.common.collect.ImmutableMap;
import com.merlin204.avalon.block.MeshBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.LayerOffAnimation;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.physics.cloth.ClothSimulatable;
import yesman.epicfight.api.client.physics.cloth.ClothSimulator;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.physics.PhysicsSimulator;
import yesman.epicfight.api.physics.SimulatableObject;
import yesman.epicfight.api.physics.SimulationTypes;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.StunType;

public class MeshBlock
extends Block
implements EntityBlock {
    private float yRotO = 180.0f;
    private float yRot = 180.0f;
    public final AssetAccessor<? extends StaticAnimation> animation = Animations.BIPED_WALK;
    @OnlyIn(value=Dist.CLIENT)
    public MeshBlockEntityPatch entitypatch;
    @OnlyIn(value=Dist.CLIENT)
    public MeshBlockEntityAnimator animator;
    private boolean started = false;
    private ResourceLocation TEST = ResourceLocation.fromNamespaceAndPath((String)"epic_fight_avalon", (String)"textures/all_black.png");

    public MeshBlock(BlockBehaviour.Properties pProperties) {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_222994_().m_60971_((state, world, pos) -> false));
    }

    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return Meshes.SKELETON;
    }

    public AssetAccessor<? extends Armature> getArmature() {
        return Armatures.BIPED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new MeshBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof MeshBlockEntity) {
                MeshBlockEntity meshEntity = (MeshBlockEntity)blockEntity;
                if (level1.f_46443_) {
                    this._tick();
                }
            }
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected ImmutableMap<BlockState, VoxelShape> m_152458_(Function<BlockState, VoxelShape> pShapeGetter) {
        return super.m_152458_(pShapeGetter);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void _tick() {
        if (this.getArmature() != null && !this.started) {
            this.started = true;
            this.entitypatch = new MeshBlockEntityPatch((Armature)this.getArmature().get());
            this.animator = new MeshBlockEntityAnimator(this.entitypatch);
            this.entitypatch.initAnimator((Animator)this.animator);
        }
        if (this.animator != null) {
            this.animator.tick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawMesh(PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        Pose pose = this.animator.getPose(partialTicks);
        ((SkinnedMesh)this.getMesh().get()).initialize();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        OpenMatrix4f[] poseMatrices = this.entitypatch.getArmature().getPoseAsTransformMatrix(pose, false);
        ((SkinnedMesh)this.getMesh().get()).draw(poseStack, bufferSource, RenderType.m_110473_((ResourceLocation)this.TEST), 0xF000F0, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, this.entitypatch.getArmature(), poseMatrices);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class MeshBlockEntityPatch
    extends LivingEntityPatch<LivingEntity>
    implements SimulatableObject,
    ClothSimulatable {
        public MeshBlockEntityPatch(Armature armature) {
            this.armature = armature.deepCopy();
        }

        public void setAnimator() {
            this.animator = MeshBlock.this.animator;
        }

        public void initAnimator(Animator animator) {
            this.animator = animator;
        }

        public void updateMotion(boolean considerInaction) {
        }

        public AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
            return null;
        }

        public boolean isLogicalClient() {
            return true;
        }

        public OpenMatrix4f getModelMatrix(float partialTicks) {
            return MathUtils.getModelMatrixIntegral((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public void poseTick(DynamicAnimation animation, Pose pose, float time, float partialTicks) {
        }

        public void updateEntityState() {
        }

        public boolean invalid() {
            return false;
        }

        public Vec3 getObjectVelocity() {
            return Vec3.f_82478_;
        }

        public Vec3 getAccurateCloakLocation(float partialFrame) {
            return Vec3.f_82478_;
        }

        public Vec3 getAccuratePartialLocation(float partialFrame) {
            return Vec3.f_82478_;
        }

        public float getAccurateYRot(float partialFrame) {
            return MeshBlock.this.yRot;
        }

        public float getYRotDelta(float partialFrame) {
            return MeshBlock.this.yRot - MeshBlock.this.yRotO;
        }

        public float getYRot() {
            return MeshBlock.this.yRot;
        }

        public float getYRotO() {
            return MeshBlock.this.yRotO;
        }

        public <SIM extends PhysicsSimulator<?, ?, ?, ?, ?>> Optional<SIM> getSimulator(SimulationTypes<?, ?, ?, ?, ?, SIM> simulationType) {
            return Optional.empty();
        }

        public float getScale() {
            return 1.0f;
        }

        public Animator getSimulatableAnimator() {
            return this.animator;
        }

        public float getGravity() {
            return 9.8f;
        }

        public ClothSimulator getClothSimulator() {
            return null;
        }

        public Faction getFaction() {
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class MeshBlockEntityAnimator
    extends ClientAnimator {
        public MeshBlockEntityAnimator(LivingEntityPatch<?> entitypatch) {
            super(entitypatch, MeshBlockEntityBaseLayer::new);
        }

        public void tick() {
            this.baseLayer.update(this.entitypatch);
        }

        public LivingEntityPatch<?> getEntityPatch() {
            return this.entitypatch;
        }

        @OnlyIn(value=Dist.CLIENT)
        static class MeshBlockEntityBaseLayer
        extends Layer.BaseLayer {
            public MeshBlockEntityBaseLayer() {
                super(NoEntityAnimationPlayer::new);
                this.compositeLayers.clear();
                for (Layer.Priority priority : Layer.Priority.values()) {
                    this.compositeLayers.computeIfAbsent(priority, MeshBlockEntityLayer::new);
                }
                this.baseLayerPriority = Layer.Priority.LOWEST;
            }

            public void playAnimation(AssetAccessor<? extends StaticAnimation> nextAnimation, LivingEntityPatch<?> entitypatch, float convertTimeModifier) {
                Layer.Priority priority;
                this.baseLayerPriority = priority = ((StaticAnimation)nextAnimation.get()).getPriority();
                this.offCompositeLayersLowerThan(entitypatch, nextAnimation);
                Pose lastPose = entitypatch.getAnimator().getPose(1.0f);
                this.resume();
                if (!((StaticAnimation)nextAnimation.get()).isMetaAnimation()) {
                    this.setLinkAnimation(nextAnimation, entitypatch, lastPose, convertTimeModifier);
                    this.linkAnimation.putOnPlayer(this.animationPlayer, entitypatch);
                    entitypatch.updateEntityState();
                    this.nextAnimation = nextAnimation;
                }
            }

            public void playAnimationInstantly(AssetAccessor<? extends DynamicAnimation> nextAnimation, LivingEntityPatch<?> entitypatch) {
                this.resume();
                ((DynamicAnimation)nextAnimation.get()).putOnPlayer(this.animationPlayer, entitypatch);
                this.nextAnimation = null;
            }

            protected void playLivingAnimation(AssetAccessor<? extends StaticAnimation> nextAnimation, LivingEntityPatch<?> entitypatch) {
                this.resume();
                if (!((StaticAnimation)nextAnimation.get()).isMetaAnimation()) {
                    this.concurrentLinkAnimation.acceptFrom(((DynamicAnimation)this.animationPlayer.getAnimation().get()).getRealAnimation(), nextAnimation, this.animationPlayer.getElapsedTime());
                    this.concurrentLinkAnimation.putOnPlayer(this.animationPlayer, entitypatch);
                    this.nextAnimation = nextAnimation;
                }
            }

            public void update(LivingEntityPatch<?> entitypatch) {
                this.animationPlayer.tick(entitypatch);
                if (!this.paused && this.animationPlayer.isEnd()) {
                    if (this.nextAnimation != null) {
                        ((StaticAnimation)this.nextAnimation.get()).putOnPlayer(this.animationPlayer, entitypatch);
                        this.nextAnimation = null;
                    } else if (this.animationPlayer.getAnimation() instanceof LayerOffAnimation) {
                        ((DynamicAnimation)this.animationPlayer.getAnimation().get()).end(entitypatch, (AssetAccessor)Animations.EMPTY_ANIMATION, true);
                    } else {
                        this.off(entitypatch);
                    }
                }
                for (Layer layer : this.compositeLayers.values()) {
                    layer.update(entitypatch);
                }
            }

            protected void setLinkAnimation(AssetAccessor<? extends StaticAnimation> nextAnimation, LivingEntityPatch<?> entitypatch, Pose lastPose, float convertTimeModifier) {
                AssetAccessor fromAnimation;
                Pose currentPose = ((DynamicAnimation)this.animationPlayer.getAnimation().get()).getRawPose(this.animationPlayer.getElapsedTime());
                Pose nextAnimationPose = ((StaticAnimation)nextAnimation.get()).getRawPose(0.0f);
                float totalTime = ((StaticAnimation)nextAnimation.get()).getTransitionTime();
                AssetAccessor assetAccessor = fromAnimation = this.animationPlayer.isEmpty() ? entitypatch.getClientAnimator().baseLayer.animationPlayer.getAnimation() : this.animationPlayer.getAnimation();
                if (fromAnimation instanceof LinkAnimation) {
                    LinkAnimation linkAnimation = (LinkAnimation)fromAnimation;
                    fromAnimation = linkAnimation.getFromAnimation();
                }
                this.linkAnimation.getTransfroms().clear();
                this.linkAnimation.setTotalTime(totalTime);
                this.linkAnimation.setConnectedAnimations(fromAnimation, nextAnimation);
                Map data1 = currentPose.getJointTransformData();
                Map data2 = nextAnimationPose.getJointTransformData();
                for (String jointName : data1.keySet()) {
                    if (!data1.containsKey(jointName) || !data2.containsKey(jointName)) continue;
                    Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, (JointTransform)data1.get(jointName)), new Keyframe(totalTime, (JointTransform)data2.get(jointName))};
                    TransformSheet sheet = new TransformSheet(keyframes);
                    this.linkAnimation.getAnimationClip().addJointTransform(jointName, sheet);
                }
                this.animationPlayer.setPlayAnimation((AssetAccessor)this.linkAnimation);
            }

            public void offCompositeLayerLowerThan(LivingEntityPatch<?> entitypatch, StaticAnimation nextAnimation) {
                for (Layer.Priority p : nextAnimation.getPriority().lowersAndEqual()) {
                    if (p == Layer.Priority.LOWEST && !nextAnimation.isMainFrameAnimation()) continue;
                    ((Layer)this.compositeLayers.get(p)).off(entitypatch);
                }
            }

            public Layer getLayer(Layer.Priority priority) {
                return (Layer)this.compositeLayers.get(priority);
            }

            public void off(LivingEntityPatch<?> entitypatch) {
            }

            protected boolean isDisabled() {
                return false;
            }

            protected boolean isBaseLayer() {
                return true;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        static class MeshBlockEntityLayer
        extends Layer {
            public MeshBlockEntityLayer(Layer.Priority priority) {
                super(priority, NoEntityAnimationPlayer::new);
            }

            public void playAnimation(AssetAccessor<? extends StaticAnimation> nextAnimation, LivingEntityPatch<?> entitypatch, float convertTimeModifier) {
                Pose lastPose = entitypatch.getAnimator().getPose(1.0f);
                this.resume();
                if (!((StaticAnimation)nextAnimation.get()).isMetaAnimation()) {
                    this.setLinkAnimation(nextAnimation, entitypatch, lastPose, convertTimeModifier);
                    this.linkAnimation.putOnPlayer(this.animationPlayer, entitypatch);
                    this.nextAnimation = nextAnimation;
                }
            }

            public void playAnimationInstantly(AssetAccessor<? extends DynamicAnimation> nextAnimation, LivingEntityPatch<?> entitypatch) {
                this.resume();
                ((DynamicAnimation)nextAnimation.get()).putOnPlayer(this.animationPlayer, entitypatch);
                this.nextAnimation = null;
            }

            protected void setLinkAnimation(AssetAccessor<? extends StaticAnimation> nextAnimation, LivingEntityPatch<?> entitypatch, Pose lastPose, float convertTimeModifier) {
                AssetAccessor fromAnimation;
                Pose currentPose = ((DynamicAnimation)this.animationPlayer.getAnimation().get()).getRawPose(this.animationPlayer.getElapsedTime());
                Pose nextAnimationPose = ((StaticAnimation)nextAnimation.get()).getRawPose(0.0f);
                float totalTime = ((StaticAnimation)nextAnimation.get()).getTransitionTime();
                AssetAccessor assetAccessor = fromAnimation = this.animationPlayer.isEmpty() ? entitypatch.getClientAnimator().baseLayer.animationPlayer.getAnimation() : this.animationPlayer.getAnimation();
                if (fromAnimation instanceof LinkAnimation) {
                    LinkAnimation linkAnimation = (LinkAnimation)fromAnimation;
                    fromAnimation = linkAnimation.getFromAnimation();
                }
                this.linkAnimation.getTransfroms().clear();
                this.linkAnimation.setTotalTime(totalTime);
                this.linkAnimation.setConnectedAnimations(fromAnimation, nextAnimation);
                Map data1 = currentPose.getJointTransformData();
                Map data2 = nextAnimationPose.getJointTransformData();
                for (String jointName : data1.keySet()) {
                    if (!data1.containsKey(jointName) || !data2.containsKey(jointName)) continue;
                    Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, (JointTransform)data1.get(jointName)), new Keyframe(totalTime, (JointTransform)data2.get(jointName))};
                    TransformSheet sheet = new TransformSheet(keyframes);
                    this.linkAnimation.getAnimationClip().addJointTransform(jointName, sheet);
                }
                this.animationPlayer.setPlayAnimation((AssetAccessor)this.linkAnimation);
            }

            public void update(LivingEntityPatch<?> entitypatch) {
                this.animationPlayer.tick(entitypatch);
                if (this.animationPlayer.isEnd()) {
                    if (this.nextAnimation != null) {
                        ((StaticAnimation)this.nextAnimation.get()).putOnPlayer(this.animationPlayer, entitypatch);
                        this.nextAnimation = null;
                    } else if (this.animationPlayer.getAnimation() instanceof LayerOffAnimation) {
                        ((DynamicAnimation)this.animationPlayer.getAnimation().get()).end(entitypatch, (AssetAccessor)Animations.EMPTY_ANIMATION, true);
                    } else {
                        this.off(entitypatch);
                    }
                }
            }

            public Pose getEnabledPose(LivingEntityPatch<?> entitypatch, float partialTick) {
                DynamicAnimation animation = (DynamicAnimation)this.animationPlayer.getAnimation().get();
                Pose pose = animation.getRawPose(this.animationPlayer.getPrevElapsedTime() + (this.animationPlayer.getElapsedTime() - this.animationPlayer.getPrevElapsedTime()) * partialTick);
                pose.disableJoint(entry -> !animation.hasTransformFor((String)entry.getKey()));
                return pose;
            }

            public void off(LivingEntityPatch<?> entitypatch) {
                if (!this.isDisabled() && !(this.animationPlayer.getAnimation() instanceof LayerOffAnimation)) {
                    float convertTime = ((DynamicAnimation)entitypatch.getClientAnimator().baseLayer.animationPlayer.getAnimation().get()).getTransitionTime();
                    MeshBlockEntityLayer.setLayerOffAnimation((AssetAccessor)this.animationPlayer.getAnimation(), (Pose)this.getEnabledPose(entitypatch, 1.0f), (LayerOffAnimation)this.layerOffAnimation, (float)convertTime);
                    this.playAnimationInstantly((AssetAccessor<? extends DynamicAnimation>)this.layerOffAnimation, entitypatch);
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        static class NoEntityAnimationPlayer
        extends AnimationPlayer {
            NoEntityAnimationPlayer() {
            }

            public void tick(LivingEntityPatch<?> entitypatch) {
                DynamicAnimation nowPlay = (DynamicAnimation)this.getAnimation().get();
                float tickDelta = 0.05f;
                this.prevElapsedTime = this.elapsedTime;
                this.elapsedTime += tickDelta;
                if (this.elapsedTime >= nowPlay.getTotalTime()) {
                    if (nowPlay.isRepeat()) {
                        this.elapsedTime %= nowPlay.getTotalTime();
                        this.prevElapsedTime = 0.0f;
                    } else {
                        this.elapsedTime = nowPlay.getTotalTime();
                        this.isEnd = true;
                    }
                }
            }

            public Pose getCurrentPose(LivingEntityPatch<?> entitypatch, float partialTicks) {
                float interpolatedTime = this.prevElapsedTime + (this.elapsedTime - this.prevElapsedTime) * partialTicks;
                return ((DynamicAnimation)this.play.get()).getRawPose(interpolatedTime);
            }

            public void begin(AssetAccessor<? extends DynamicAnimation> animation, LivingEntityPatch<?> entitypatch) {
            }
        }
    }
}

