/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.world.structure;

import dev.muon.medieval.config.MedievalConfig;
import dev.muon.medieval.item.WayfindersMedallionItem;
import dev.muon.medieval.world.saved_data.StructureRegenerationState;
import dev.muon.medieval.world.structure.StructureRegenerator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(modid="medieval")
public class AutomaticStructureRegenerator {
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!MedievalConfig.get().enableAutoRegeneration) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (++tickCounter % MedievalConfig.get().autoRegenCheckInterval != 0) {
            return;
        }
        boolean hasActiveMedallion = false;
        if (player2.m_21205_().m_41720_() instanceof WayfindersMedallionItem) {
            hasActiveMedallion = WayfindersMedallionItem.isActive(player2.m_21205_());
        }
        if (!hasActiveMedallion && player2.m_21206_().m_41720_() instanceof WayfindersMedallionItem) {
            hasActiveMedallion = WayfindersMedallionItem.isActive(player2.m_21206_());
        }
        if (!hasActiveMedallion) {
            hasActiveMedallion = AutomaticStructureRegenerator.checkCuriosForMedallion(player2);
        }
        if (!hasActiveMedallion) {
            return;
        }
        ServerLevel level = player2.m_284548_();
        StructureRegenerationState data = StructureRegenerationState.get(level);
        BlockPos playerPos = player2.m_20183_();
        ChunkPos playerChunk = new ChunkPos(playerPos);
        int chunkRadius = (int)Math.ceil(MedievalConfig.get().autoRegenRadius / 16.0);
        for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
            for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                ChunkPos checkChunk = new ChunkPos(playerChunk.f_45578_ + dx, playerChunk.f_45579_ + dz);
                AutomaticStructureRegenerator.checkStructuresInChunk(level, player2, checkChunk, playerPos, data);
            }
        }
    }

    private static void checkStructuresInChunk(ServerLevel level, ServerPlayer player, ChunkPos chunkPos, BlockPos playerPos, StructureRegenerationState data) {
        Map structuresInChunk = level.m_215010_().m_220522_(chunkPos.m_45615_());
        for (Map.Entry entry : structuresInChunk.entrySet()) {
            BoundingBox boundingBox;
            StructureStart start;
            ResourceLocation structureId = level.m_9598_().m_175515_(Registries.f_256944_).m_7981_((Object)((Structure)entry.getKey()));
            if (structureId == null || !MedievalConfig.get().isStructureWhitelisted(structureId) || (start = level.m_215010_().m_220512_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)0), (Structure)entry.getKey(), (StructureAccess)level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_))) == null || !start.m_73603_() || !AutomaticStructureRegenerator.isPlayerInStructure(playerPos, boundingBox = start.m_73601_())) continue;
            BlockPos structureCenter = boundingBox.m_162394_();
            if (data.hasPlayerRegeneratedStructure(player.m_20148_(), structureId, structureCenter) || !AutomaticStructureRegenerator.canAutoRegenerate(level, player, structureId, boundingBox, data)) continue;
            if (StructureRegenerator.isAnyClaimed(level, boundingBox) != null) {
                AutomaticStructureRegenerator.sendActionBar(player, "message.medieval.structure.claimed", ChatFormatting.RED, structureId);
                continue;
            }
            AutomaticStructureRegenerator.sendActionBar(player, "message.medieval.structure.regenerating", ChatFormatting.YELLOW, structureId);
            StructureRegenerator.RegenerationResult result = StructureRegenerator.regenerateStructure(level, playerPos, structureId);
            if (result.success) {
                data.markStructureRegenerated(player.m_20148_(), structureId, structureCenter);
                data.clearStructureInteraction(structureId);
                AutomaticStructureRegenerator.sendActionBar(player, "message.medieval.structure.success", ChatFormatting.GREEN, structureId);
                continue;
            }
            AutomaticStructureRegenerator.sendActionBar(player, "message.medieval.structure.fail", ChatFormatting.RED, structureId, result.message);
        }
    }

    private static boolean isPlayerInStructure(BlockPos playerPos, BoundingBox boundingBox) {
        return playerPos.m_123341_() >= boundingBox.m_162395_() && playerPos.m_123341_() <= boundingBox.m_162399_() && playerPos.m_123342_() >= boundingBox.m_162396_() && playerPos.m_123342_() <= boundingBox.m_162400_() && playerPos.m_123343_() >= boundingBox.m_162398_() && playerPos.m_123343_() <= boundingBox.m_162401_();
    }

    private static boolean canAutoRegenerate(ServerLevel level, ServerPlayer player, ResourceLocation structureId, BoundingBox boundingBox, StructureRegenerationState data) {
        StructureRegenerationState.StructureInteraction interaction;
        long currentTime = level.m_46467_();
        if (data.hasRecentInteraction(structureId, currentTime, MedievalConfig.get().structureInactivityTimeoutSeconds) && (interaction = data.getLastInteraction(structureId)) != null) {
            long timeSince = (currentTime - interaction.timestamp) / 20L;
            AutomaticStructureRegenerator.sendActionBar(player, "message.medieval.structure.recent_activity", ChatFormatting.YELLOW, structureId, interaction.type.name().toLowerCase(), timeSince);
            return false;
        }
        if (AutomaticStructureRegenerator.hasOtherPlayersInStructure(level, player, boundingBox)) {
            AutomaticStructureRegenerator.sendActionBar(player, "message.medieval.structure.players_present", ChatFormatting.YELLOW, structureId);
            return false;
        }
        return true;
    }

    private static boolean hasOtherPlayersInStructure(ServerLevel level, ServerPlayer excludePlayer, BoundingBox boundingBox) {
        AABB aabb = new AABB((double)boundingBox.m_162395_(), (double)boundingBox.m_162396_(), (double)boundingBox.m_162398_(), (double)(boundingBox.m_162399_() + 1), (double)(boundingBox.m_162400_() + 1), (double)(boundingBox.m_162401_() + 1));
        List playersInStructure = level.m_45976_(Player.class, aabb);
        return playersInStructure.stream().anyMatch(p -> p != excludePlayer && p instanceof ServerPlayer);
    }

    private static void sendActionBar(ServerPlayer player, String translationKey, ChatFormatting formatting, Object ... args) {
        player.m_5661_((Component)Component.m_237110_((String)translationKey, (Object[])args).m_130940_(formatting), true);
    }

    private static boolean checkCuriosForMedallion(ServerPlayer player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(handler -> {
            ICurioStacksHandler charmHandler = (ICurioStacksHandler)handler.getCurios().get("charm");
            if (charmHandler != null) {
                for (int i = 0; i < charmHandler.getSlots(); ++i) {
                    ItemStack stack = charmHandler.getStacks().getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof WayfindersMedallionItem) || !WayfindersMedallionItem.isActive(stack)) continue;
                    return true;
                }
            }
            return false;
        }).orElse(false);
    }
}

