/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TownPortalScrollItem
extends Item {
    private static final int CHANNEL_TICKS = 80;
    private static final int COOLDOWN_TICKS = 12000;

    public TownPortalScrollItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack pStack) {
        return 80;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"item.medieval.town_portal_scroll.tooltip").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)"Cast Time: 4.0s").m_130940_(ChatFormatting.GREEN));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!level.f_46443_) {
                double remainingSeconds = (double)remainingUseDuration / 20.0;
                String formattedTime = String.format("%.1f", remainingSeconds);
                player.m_5661_((Component)Component.m_237113_((String)("Channeling: " + formattedTime + "s")), true);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"item.medieval.town_portal_scroll.interrupted").m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        Optional<Vec3> respawnLocation;
        if (!(entity instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ServerLevel serverLevel = player.m_284548_();
        BlockPos respawnPos = player.m_8961_();
        ServerLevel respawnLevel = player.f_8924_.m_129880_(player.m_8963_());
        boolean teleported = false;
        MutableComponent resultMessage = null;
        if (respawnLevel != null && respawnPos != null && (respawnLocation = this.findRespawnLocation(respawnLevel, respawnPos, player.m_8962_(), player.m_8964_())).isPresent()) {
            Vec3 pos = respawnLocation.get();
            player.m_8999_(respawnLevel, pos.f_82479_, pos.f_82480_, pos.f_82481_, player.m_146908_(), player.m_146909_());
            teleported = true;
            resultMessage = Component.m_237115_((String)"item.medieval.town_portal_scroll.teleport_bed").m_130940_(ChatFormatting.GREEN);
        }
        if (!teleported) {
            ServerLevel overworld = player.f_8924_.m_129783_();
            BlockPos worldSpawn = overworld.m_220360_();
            player.m_8999_(overworld, (double)worldSpawn.m_123341_() + 0.5, (double)worldSpawn.m_123342_() + 0.1, (double)worldSpawn.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            resultMessage = Component.m_237115_((String)"item.medieval.town_portal_scroll.teleport_world_spawn").m_130940_(ChatFormatting.GREEN);
        }
        serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 0.75f);
        player.m_36335_().m_41524_((Item)this, 12000);
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        player.m_5661_(resultMessage, true);
        return stack;
    }

    private Optional<Vec3> findRespawnLocation(ServerLevel level, BlockPos pos, float angle, boolean forced) {
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof RespawnAnchorBlock && (forced || (Integer)blockState.m_61143_((Property)RespawnAnchorBlock.f_55833_) > 0) && RespawnAnchorBlock.m_55850_((Level)level)) {
            return RespawnAnchorBlock.m_55839_((EntityType)EntityType.f_20532_, (CollisionGetter)level, (BlockPos)pos);
        }
        if (block instanceof BedBlock && BedBlock.m_49488_((Level)level)) {
            return BedBlock.m_260958_((EntityType)EntityType.f_20532_, (CollisionGetter)level, (BlockPos)pos, (Direction)((Direction)blockState.m_61143_((Property)BedBlock.f_54117_)), (float)angle);
        }
        if (forced) {
            boolean flag = block.m_48673_(blockState);
            BlockState blockState1 = level.m_8055_(pos.m_7494_());
            boolean flag1 = blockState1.m_60734_().m_48673_(blockState1);
            if (flag && flag1) {
                return Optional.of(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5));
            }
        }
        return Optional.empty();
    }
}

