/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.medieval.Medieval;
import dev.muon.medieval.hotbar.HUDPositioning;
import dev.muon.medieval.hotbar.Position;
import dev.muon.medieval.hotbar.RenderUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;

public class StaminaBarRenderer {
    private static float lastStamina = -1.0f;
    private static long aboveThresholdStartTime = 0L;
    private static final float SPRINT_THRESHOLD = 6.0f;

    public static void render(GuiGraphics graphics, Player player, float partialTicks) {
        FoodData foodData = player.m_36324_();
        int foodLevel = foodData.m_38702_();
        Position staminaPos = HUDPositioning.getHungerAnchor().offset(HUDPositioning.getStaminaBarXOffset(), HUDPositioning.getStaminaBarYOffset());
        int borderWidth = 80;
        int borderHeight = 10;
        int barWidth = 74;
        int barHeight = 4;
        int barXOffset = 3;
        int barYOffset = 3;
        int animationCycles = 33;
        int frameHeight = 6;
        int xPos = staminaPos.x() - borderWidth;
        int yPos = staminaPos.y();
        graphics.m_280163_(Medieval.loc("textures/gui/stamina_border.png"), xPos, yPos, 0.0f, 0.0f, borderWidth, borderHeight, 256, 256);
        float maxStamina = 20.0f;
        float currentStamina = player.m_36324_().m_38702_();
        float staminaPercent = currentStamina / maxStamina;
        int partialBarWidth = (int)((float)barWidth * staminaPercent);
        int animOffset = (int)(((float)player.f_19797_ + partialTicks) / 3.0f % (float)animationCycles) * frameHeight;
        boolean hasHungerEffect = player.m_21023_(MobEffects.f_19612_);
        if (hasHungerEffect) {
            graphics.m_280163_(Medieval.loc("textures/gui/stamina_bar_hunger.png"), xPos + barXOffset, yPos + barYOffset, 0.0f, (float)animOffset, partialBarWidth, barHeight, 256, 256);
        } else {
            graphics.m_280163_(Medieval.loc("textures/gui/stamina_bar.png"), xPos + barXOffset, yPos + barYOffset, 0.0f, (float)animOffset, partialBarWidth, barHeight, 256, 256);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textX = xPos + borderWidth / 2;
        int textY = yPos + barYOffset;
        if (StaminaBarRenderer.shouldRenderText(currentStamina, hasHungerEffect)) {
            int color = StaminaBarRenderer.getStaminaTextColor();
            RenderUtil.renderText(currentStamina, maxStamina, graphics, textX, textY, color);
        }
    }

    private static boolean shouldRenderText(float currentStamina, boolean hasHungerEffect) {
        if (hasHungerEffect) {
            return true;
        }
        if (currentStamina >= 6.0f) {
            if (lastStamina < 6.0f) {
                aboveThresholdStartTime = System.currentTimeMillis();
            }
        } else {
            aboveThresholdStartTime = 0L;
        }
        lastStamina = currentStamina;
        long timeSinceAboveThreshold = aboveThresholdStartTime > 0L ? System.currentTimeMillis() - aboveThresholdStartTime : 0L;
        return currentStamina < 6.0f || aboveThresholdStartTime > 0L && timeSinceAboveThreshold < 2000L;
    }

    private static int getStaminaTextColor() {
        long timeSinceAboveThreshold = aboveThresholdStartTime > 0L ? System.currentTimeMillis() - aboveThresholdStartTime : 0L;
        int alpha = RenderUtil.calculateTextAlpha(timeSinceAboveThreshold, 2000L, 500L, 200);
        return alpha << 24 | 0xFFFFFF;
    }
}

