/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.resources.ResourceLocation;

@Config(name="medieval")
public class MedievalConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean enableCustomResourceBars = true;
    @ConfigEntry.Gui.Tooltip(count=2)
    public boolean cancelLevelsForPassives = true;
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(min=1L, max=32L)
    public int structureSearchRadius = 6;
    @ConfigEntry.Gui.Tooltip(count=2)
    public boolean enableStructureLevelBonus = false;
    @ConfigEntry.Gui.Tooltip(count=2)
    public Map<String, Integer> structureLevelBonuses = new HashMap<String, Integer>();
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(min=1L, max=256L)
    public double levelingSearchRadius = 128.0;
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(min=0L, max=10L)
    public double levelsPerPoint = 0.2;
    @ConfigEntry.Gui.Tooltip(count=2)
    public boolean applyPlayerBasedLeveling = false;
    @ConfigEntry.Gui.Tooltip(count=2)
    public boolean enableAutoRegeneration = true;
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(min=20L, max=200L)
    public int autoRegenCheckInterval = 40;
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(min=60L, max=3600L)
    public int structureInactivityTimeoutSeconds = 900;
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(min=8L, max=128L)
    public double autoRegenRadius = 32.0;
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.Gui.CollapsibleObject
    public StructureWhitelist structureWhitelist = new StructureWhitelist();
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(min=1L, max=1024L)
    public int maxStacksPerEntity = 128;

    public static MedievalConfig get() {
        return (MedievalConfig)AutoConfig.getConfigHolder(MedievalConfig.class).getConfig();
    }

    public static void register() {
        AutoConfig.register(MedievalConfig.class, JanksonConfigSerializer::new);
    }

    public int getStructureLevelBonus(ResourceLocation structureId) {
        return this.structureLevelBonuses.getOrDefault(structureId.toString(), 0);
    }

    public boolean isStructureWhitelisted(ResourceLocation structureId) {
        if (this.structureWhitelist.blacklistedStructures.contains(structureId.toString())) {
            return false;
        }
        return this.structureWhitelist.allowedNamespaces.contains(structureId.m_135827_()) || this.structureWhitelist.additionalStructures.contains(structureId.toString());
    }

    public static class StructureWhitelist {
        @ConfigEntry.Gui.Tooltip(count=2)
        public List<String> allowedNamespaces = new ArrayList<String>();
        @ConfigEntry.Gui.Tooltip(count=2)
        public List<String> additionalStructures = new ArrayList<String>();
        @ConfigEntry.Gui.Tooltip(count=2)
        public List<String> blacklistedStructures = new ArrayList<String>();
    }
}

