/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class TagLike<T> {
    private final Registry<T> registry;
    private final List<TagKey<T>> tags = new LinkedList<TagKey<T>>();
    private final Set<T> items = new HashSet<T>();

    public TagLike(Registry<T> registry) {
        this.registry = registry;
    }

    public void addTag(ResourceLocation id) {
        this.addTag(TagKey.m_203882_((ResourceKey)this.registry.m_123023_(), (ResourceLocation)id));
    }

    public void add(ResourceLocation id) {
        this.add(this.registry.m_7745_(id));
    }

    public void addTag(TagKey<T> tagKey) {
        this.tags.add(tagKey);
    }

    public void add(T t) {
        this.items.add(t);
    }

    public boolean contains(T t) {
        if (this.items.contains(t)) {
            return true;
        }
        Holder entry = this.registry.m_263177_(t);
        for (TagKey<T> tagKey : this.tags) {
            if (!entry.m_203656_(tagKey)) continue;
            return true;
        }
        return false;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.tags.size());
        for (TagKey<T> tagKey : this.tags) {
            buf.m_130070_(tagKey.f_203868_().toString());
        }
        buf.m_130130_(this.items.size());
        for (Object t : this.items) {
            buf.m_130070_(this.registry.m_7981_(t).toString());
        }
    }

    public void read(FriendlyByteBuf buf) {
        int i;
        this.tags.clear();
        int count = buf.m_130242_();
        for (i = 0; i < count; ++i) {
            this.tags.add(TagKey.m_203882_((ResourceKey)this.registry.m_123023_(), (ResourceLocation)new ResourceLocation(buf.m_130277_())));
        }
        this.items.clear();
        count = buf.m_130242_();
        for (i = 0; i < count; ++i) {
            Object t = this.registry.m_7745_(new ResourceLocation(buf.m_130277_()));
            this.items.add(t);
        }
    }
}

