/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.resource;

import com.google.common.collect.Lists;
import io.github.apace100.calio.resource.OrderedResourceListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;

@Deprecated
public class OrderedResourceListenerManager {
    private final HashMap<PackType, Instance> instances = new HashMap();

    OrderedResourceListenerManager() {
    }

    public OrderedResourceListener.Registration register(PackType resourceType, IdentifiableResourceReloadListener resourceReloadListener) {
        Instance inst = this.instances.computeIfAbsent(resourceType, rt -> new Instance(arg_0 -> ((ResourceManagerHelper)ResourceManagerHelper.get((PackType)rt)).registerReloadListener(arg_0)));
        return new OrderedResourceListener.Registration(inst, resourceReloadListener);
    }

    void finishRegistration() {
        for (Instance inst : this.instances.values()) {
            inst.finish();
        }
    }

    private static <T> List<T> copy(List<T> list) {
        return Lists.newLinkedList(list);
    }

    static class Instance {
        private final HashMap<ResourceLocation, OrderedResourceListener.Registration> registrations = new HashMap();
        private final HashMap<Integer, List<ResourceLocation>> sortedMap = new HashMap();
        private int maxIndex = 0;
        private final Consumer<IdentifiableResourceReloadListener> registrationMethod;

        private Instance(Consumer<IdentifiableResourceReloadListener> registrationMethod) {
            this.registrationMethod = registrationMethod;
        }

        void add(OrderedResourceListener.Registration registration) {
            this.registrations.put(registration.id, registration);
        }

        void finish() {
            List<ResourceLocation> nextListeners;
            this.prepareSetsAndSort();
            LinkedList<ResourceLocation> sortedList = new LinkedList<ResourceLocation>();
            while (!(nextListeners = OrderedResourceListenerManager.copy(this.getRegistrations(0))).isEmpty()) {
                sortedList.addAll(nextListeners);
                this.sortedMap.remove(0);
                for (int i = 1; i <= this.maxIndex; ++i) {
                    for (ResourceLocation resourceLocation : OrderedResourceListenerManager.copy(this.getRegistrations(i))) {
                        OrderedResourceListener.Registration registration = this.registrations.get(resourceLocation);
                        int before = registration.dependencies.size();
                        nextListeners.forEach(registration.dependencies::remove);
                        this.update(registration, before);
                    }
                }
            }
            if (!this.sortedMap.isEmpty()) {
                StringBuilder errorBuilder = new StringBuilder("Couldn't resolve ordered resource listener dependencies. Unsolved:");
                for (int i = 0; i <= this.maxIndex; ++i) {
                    if (this.getRegistrations(i).isEmpty()) continue;
                    errorBuilder.append("\t").append(i).append(" dependencies:");
                    for (ResourceLocation id : this.getRegistrations(i)) {
                        OrderedResourceListener.Registration registration = this.registrations.get(id);
                        errorBuilder.append("\t\t").append(registration.toString());
                        this.registrationMethod.accept(registration.resourceReloadListener);
                    }
                }
                throw new RuntimeException(errorBuilder.toString());
            }
            for (ResourceLocation id : sortedList) {
                OrderedResourceListener.Registration registration = this.registrations.get(id);
                this.registrationMethod.accept(registration.resourceReloadListener);
            }
        }

        private void prepareSetsAndSort() {
            for (OrderedResourceListener.Registration reg : this.registrations.values()) {
                reg.dependencies.removeIf(id -> !this.registrations.containsKey(id));
                reg.dependants.forEach(id -> {
                    if (this.registrations.containsKey(id)) {
                        this.registrations.get((Object)id).dependencies.add(reg.id);
                    }
                });
            }
            this.registrations.values().forEach(this::sortIntoMap);
        }

        private void sortIntoMap(OrderedResourceListener.Registration registration) {
            int index = registration.dependencies.size();
            List list = this.sortedMap.computeIfAbsent(index, i -> new LinkedList());
            list.add(registration.id);
            if (index > this.maxIndex) {
                this.maxIndex = index;
            }
        }

        private void update(OrderedResourceListener.Registration registration, int indexBefore) {
            int index = registration.dependencies.size();
            if (index == indexBefore) {
                return;
            }
            List<ResourceLocation> regs = this.getRegistrations(indexBefore);
            regs.remove(registration.id);
            if (regs.isEmpty()) {
                this.sortedMap.remove(indexBefore);
            }
            List list = this.sortedMap.computeIfAbsent(index, i -> new LinkedList());
            list.add(registration.id);
        }

        private List<ResourceLocation> getRegistrations(int index) {
            return this.sortedMap.getOrDefault(index, new LinkedList());
        }
    }
}

